package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.Constants;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.Include;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.util.UMLUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppIncludeUtil {
  public static String includeDirective(final String path) {
    if (((path != null) && (path.length() > 0))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("#include ");
      String _plus = (_builder.toString() + "\"");
      String _plus_1 = (_plus + path);
      return (_plus_1 + "\"");
    }
    return null;
  }
  
  public static String declareDirective(final String path) {
    if (((path != null) && (path.length() > 0))) {
      return path;
    }
    return null;
  }
  
  public static String usingDirective(final String path) {
    if (((path != null) && (path.length() > 0))) {
      return (("using namespace " + path) + ";");
    }
    return null;
  }
  
  public static String CppIncludeHeader(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Include.class);
    if (_hasStereotype) {
      UMLUtil.<Include>getStereotypeApplication(ne, Include.class);
      String header = UMLUtil.<Include>getStereotypeApplication(ne, Include.class).getHeader();
      if (((header != null) && (header.length() > 0))) {
        CharSequence _constIncludeHeaderStart = CppIncludeUtil.constIncludeHeaderStart();
        String _cleanCR = GenUtils.cleanCR(header);
        String _plus = (_constIncludeHeaderStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constIncludeHeaderEnd = CppIncludeUtil.constIncludeHeaderEnd();
        String includeHeader = (_plus_1 + _constIncludeHeaderEnd);
        return includeHeader;
      }
    }
    return null;
  }
  
  public static CharSequence constIncludeHeaderStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// Include from Include stereotype (header)");
    _builder.newLine();
    return _builder;
  }
  
  public static CharSequence constIncludeHeaderEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// End of Include stereotype (header)");
    _builder.newLine();
    return _builder;
  }
  
  public static String CppIncludePreBody(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Include.class);
    if (_hasStereotype) {
      String preBody = UMLUtil.<Include>getStereotypeApplication(ne, Include.class).getPreBody();
      if (((preBody != null) && (preBody.length() > 0))) {
        CharSequence _constIncludePreBodyStart = CppIncludeUtil.constIncludePreBodyStart();
        String _cleanCR = GenUtils.cleanCR(preBody);
        String _plus = (_constIncludePreBodyStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constIncludePreBodyEnd = CppIncludeUtil.constIncludePreBodyEnd();
        String includePreBody = (_plus_1 + _constIncludePreBodyEnd);
        return includePreBody;
      }
    }
    return null;
  }
  
  public static CharSequence constIncludePreBodyStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(Constants.cppIncPreBodyStart);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static CharSequence constIncludePreBodyEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(Constants.cppIncPreBodyEnd);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static String CppIncludeBody(final NamedElement ne) {
    boolean _hasStereotype = GenUtils.hasStereotype(ne, Include.class);
    if (_hasStereotype) {
      String body = UMLUtil.<Include>getStereotypeApplication(ne, Include.class).getBody();
      if (((body != null) && (body.length() > 0))) {
        CharSequence _constIncludeBodyStart = CppIncludeUtil.constIncludeBodyStart();
        String _cleanCR = GenUtils.cleanCR(body);
        String _plus = (_constIncludeBodyStart + _cleanCR);
        String _plus_1 = (_plus + "\n");
        CharSequence _constIncludeBodyEnd = CppIncludeUtil.constIncludeBodyEnd();
        String includeBody = (_plus_1 + _constIncludeBodyEnd);
        return includeBody;
      }
    }
    return null;
  }
  
  public static CharSequence constIncludeBodyStart() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(Constants.cppIncBodyStart);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
  
  public static CharSequence constIncludeBodyEnd() {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append(Constants.cppIncBodyEnd);
    _builder.newLineIfNotEmpty();
    return _builder;
  }
}
