package org.eclipse.papyrus.designer.languages.cpp.codegen.xtend;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.papyrus.designer.languages.common.base.GenUtils;
import org.eclipse.papyrus.designer.languages.common.profile.Codegen.NoCodeGen;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppClassUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.utils.CppGenUtils;
import org.eclipse.papyrus.designer.languages.cpp.codegen.xtend.CppClassIncludeDeclaration;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.CppRoot;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.ExternLibrary;
import org.eclipse.papyrus.designer.languages.cpp.profile.C_Cpp.External;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * @author Önder GÜRCAN (onder.gurcan@cea.fr)
 */
@SuppressWarnings("all")
public class CppClassIncludeClassDeclaration {
  public static String cppOwnerPackageIncludePath(final org.eclipse.uml2.uml.Package pkg) {
    if (((pkg != null) && (!GenUtils.hasStereotype(pkg, CppRoot.class)))) {
      String _fullPath = GenUtils.getFullPath(pkg);
      String _plus = (_fullPath + "/Pkg_");
      String _name = pkg.getName();
      String _plus_1 = (_plus + _name);
      return (_plus_1 + ".h");
    } else {
      return null;
    }
  }
  
  public static Iterable<String> CppClassAllIncludesDeclarationBody(final Classifier classifier) {
    return CppClassIncludeClassDeclaration.cppClassAllIncludes(classifier, CppClassUtils.includedImplementationClassifiers(classifier));
  }
  
  public static Iterable<String> cppClassAllIncludes(final Classifier classifier, final EList<Classifier> list) {
    List<String> newList = new ArrayList<String>();
    for (final Classifier cl : list) {
      if ((((!Objects.equal(cl, classifier)) && (!GenUtils.hasStereotype(cl, NoCodeGen.class))) || GenUtils.hasStereotype(cl, External.class))) {
        if (((((cl instanceof Enumeration) || (cl instanceof PrimitiveType)) && 
          (!GenUtils.hasStereotype(cl, External.class))) && (!GenUtils.hasStereotypeTree(cl, ExternLibrary.class)))) {
          if (((cl.getOwner() instanceof org.eclipse.uml2.uml.Package) && (!Objects.equal(cl.getOwner(), classifier.getOwner())))) {
            Element _owner = cl.getOwner();
            String includePath = CppClassIncludeClassDeclaration.cppOwnerPackageIncludePath(((org.eclipse.uml2.uml.Package) _owner));
            boolean _contains = newList.contains(includePath);
            boolean _not = (!_contains);
            if (_not) {
              newList.add(includePath);
            }
          } else {
          }
        } else {
          List<String> _cppClassIncludes = CppClassIncludeDeclaration.cppClassIncludes(cl);
          for (final String includePath_1 : _cppClassIncludes) {
            boolean _contains_1 = newList.contains(includePath_1);
            boolean _not_1 = (!_contains_1);
            if (_not_1) {
              newList.add(includePath_1);
            }
          }
        }
      } else {
      }
    }
    final Function1<String, Boolean> _function = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String str) {
        return Boolean.valueOf((str != null));
      }
    };
    return IterableExtensions.<String>filter(newList, _function);
  }
  
  /**
   * Provide a forward declaration of used classifiers
   */
  public static Iterable<String> CppClassAllDeclares(final Classifier clazz) {
    return CppClassIncludeClassDeclaration.cppClassAllDeclares(clazz, CppClassUtils.declaredClassifiers(clazz), CppClassUtils.includedClassifiers(clazz));
  }
  
  /**
   * Provide a forward declaration for declared classifiers that are NOT already included
   * 
   * @param declaredClassifiers the list of classifiers to declare
   * @param includedClassifiers the list of classifiers to include (used to reduce list of classifiers with forwards)
   */
  public static Iterable<String> cppClassAllDeclares(final Classifier classifier, final EList<Classifier> declaredClassifiers, final EList<Classifier> includedClassifiers) {
    List<String> newList = new ArrayList<String>();
    if ((declaredClassifiers != null)) {
      if ((includedClassifiers != null)) {
        declaredClassifiers.removeAll(includedClassifiers);
      }
      for (final Classifier cl : declaredClassifiers) {
        if (((!Objects.equal(cl, classifier)) && 
          (!(GenUtils.hasStereotype(cl, NoCodeGen.class) || GenUtils.hasStereotype(cl, External.class))))) {
          String declaration = "";
          if (((!(cl instanceof Enumeration)) && (!(cl instanceof PrimitiveType)))) {
            if ((cl instanceof DataType)) {
              String _openNSMinimal = CppGenUtils.openNSMinimal(cl);
              String _plus = (_openNSMinimal + "struct ");
              String _name = ((DataType)cl).getName();
              String _plus_1 = (_plus + _name);
              String _plus_2 = (_plus_1 + ";");
              String _closeNSMinimal = CppGenUtils.closeNSMinimal(cl);
              String _plus_3 = (_plus_2 + _closeNSMinimal);
              declaration = _plus_3;
            } else {
              String _replaceAll = CppGenUtils.openNSMinimal(cl).replaceAll("\r", "").replaceAll("\n", "");
              String _plus_4 = (_replaceAll + 
                "class ");
              String _name_1 = cl.getName();
              String _plus_5 = (_plus_4 + _name_1);
              String _plus_6 = (_plus_5 + ";");
              String _replaceAll_1 = CppGenUtils.closeNSMinimal(cl).replaceAll("\r", "").replaceAll("\n", "");
              String _plus_7 = (_plus_6 + _replaceAll_1);
              declaration = _plus_7;
            }
          }
          boolean _notEquals = (!Objects.equal(declaration, ""));
          if (_notEquals) {
            boolean _contains = newList.contains(declaration);
            boolean _not = (!_contains);
            if (_not) {
              newList.add(declaration);
            }
          }
        }
      }
    }
    final Function1<String, Boolean> _function = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String str) {
        return Boolean.valueOf((str != null));
      }
    };
    return IterableExtensions.<String>filter(newList, _function);
  }
  
  public static Iterable<String> CppClassAllIncludes(final Classifier clazz) {
    return CppClassIncludeClassDeclaration.cppClassAllIncludes(clazz, CppClassUtils.includedClassifiers(clazz));
  }
  
  public static Iterable<String> CppClassAllUsings(final Classifier classifier, final CppClassUtils.Position position) {
    Iterable<String> _xblockexpression = null;
    {
      final EList<Classifier> usingClasses = CppClassUtils.usingClassifiers(classifier, position);
      boolean _equals = Objects.equal(position, CppClassUtils.Position.FOR_BODY);
      if (_equals) {
        final EList<Classifier> bothUsingClasses = CppClassUtils.usingClassifiers(classifier, CppClassUtils.Position.FOR_BOTH);
        CppGenUtils _cgu = CppGenUtils.cgu(classifier);
        _cgu.setUsing(bothUsingClasses);
      } else {
        CppGenUtils _cgu_1 = CppGenUtils.cgu(classifier);
        _cgu_1.setUsing(usingClasses);
      }
      _xblockexpression = CppClassIncludeClassDeclaration.cppClassAllUsings(classifier, usingClasses);
    }
    return _xblockexpression;
  }
  
  public static Iterable<String> cppClassAllUsings(final Classifier classifier, final EList<Classifier> list) {
    Set<String> newList = new HashSet<String>();
    for (final Classifier cl : list) {
      boolean _notEquals = (!Objects.equal(cl, classifier));
      if (_notEquals) {
        Element _owner = cl.getOwner();
        if ((_owner instanceof org.eclipse.uml2.uml.Package)) {
          Element _owner_1 = cl.getOwner();
          newList.add(((org.eclipse.uml2.uml.Package) _owner_1).getQualifiedName());
        }
      }
    }
    final Function1<String, Boolean> _function = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String str) {
        return Boolean.valueOf((str != null));
      }
    };
    return IterableExtensions.<String>filter(newList, _function);
  }
}
