/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.type.baseimpl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.internal.xtend.type.baseimpl.OperationImpl;
import org.eclipse.internal.xtend.type.baseimpl.PropertyImpl;
import org.eclipse.internal.xtend.type.baseimpl.types.BuiltinBaseType;
import org.eclipse.xtend.expression.TypeSystem;
import org.eclipse.xtend.typesystem.Feature;
import org.eclipse.xtend.typesystem.ParameterizedType;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionTypeImpl
extends BuiltinBaseType
implements ParameterizedType {
    private Type innerType;

    public CollectionTypeImpl(Type innerType, TypeSystem ts, String name) {
        super(ts, name);
        this.innerType = innerType;
    }

    @Override
    public Type getInnerType() {
        return this.innerType;
    }

    @Override
    public ParameterizedType cloneWithInnerType(Type innerType) {
        return (ParameterizedType)this.getTypeSystem().getCollectionType(innerType);
    }

    @Override
    protected boolean internalIsAssignableFrom(Type t) {
        return super.internalIsAssignableFrom(t);
    }

    @Override
    public boolean isInstance(Object o) {
        return o instanceof Collection;
    }

    @Override
    public Object newInstance() {
        return new ArrayList();
    }

    @Override
    public Feature[] getContributedFeatures() {
        return new Feature[]{new OperationImpl(this, "toList", this.getTypeSystem().getListType(this.getInnerType()), new Type[0]){

            public String getDocumentation() {
                return "converts this collection to List";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return new ArrayList((Collection)target);
            }

            public Type getReturnType(Type targetType, Type[] paramTypes) {
                if (!(targetType instanceof ParameterizedType)) {
                    return this.getReturnType();
                }
                TypeSystem ts = CollectionTypeImpl.this.getTypeSystem();
                return ts.getListType(((ParameterizedType)targetType).getInnerType());
            }
        }, new OperationImpl(this, "toSet", this.getTypeSystem().getSetType(this.getInnerType()), new Type[0]){

            public String getDocumentation() {
                return "converts this collection to Set";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return new HashSet((Collection)target);
            }

            public Type getReturnType(Type targetType, Type[] paramTypes) {
                if (!(targetType instanceof ParameterizedType)) {
                    return this.getReturnType();
                }
                TypeSystem ts = CollectionTypeImpl.this.getTypeSystem();
                return ts.getSetType(((ParameterizedType)targetType).getInnerType());
            }
        }, new OperationImpl(this, "toString", this.getTypeSystem().getStringType(), new Type[]{this.getTypeSystem().getStringType()}){

            public String getDocumentation() {
                return "concatenates each contained element (using toString()), separated by the specified String.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                StringBuffer buff = new StringBuffer();
                Iterator iter = ((Collection)target).iterator();
                while (iter.hasNext()) {
                    buff.append(iter.next().toString());
                    if (!iter.hasNext()) continue;
                    buff.append(params[0].toString());
                }
                return buff.toString();
            }
        }, new PropertyImpl(this, "size", this.getTypeSystem().getIntegerType()){

            public String getDocumentation() {
                return "returns the size of this Collection";
            }

            public Object get(Object target) {
                return new Long(((Collection)target).size());
            }
        }, new PropertyImpl(this, "isEmpty", this.getTypeSystem().getBooleanType()){

            public String getDocumentation() {
                return "returns true if this Collection is empty";
            }

            public Object get(Object target) {
                return new Boolean(((Collection)target).size() == 0);
            }
        }, new OperationImpl(this, "add", (Type)this, new Type[]{this.getInnerType()}){

            public String getDocumentation() {
                return "adds an element to the Collection (modifies it!). returns this Collection.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ((Collection)target).add(params[0]);
                return target;
            }
        }, new OperationImpl(this, "addAll", (Type)this, new Type[]{this.getTypeSystem().getCollectionType(this.getInnerType())}){

            public String getDocumentation() {
                return "adds all elements to the Collection (modifies it!). returns this Collection.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ((Collection)target).addAll((Collection)params[0]);
                return target;
            }
        }, new OperationImpl(this, "contains", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getObjectType()}){

            public String getDocumentation() {
                return "returns true if this collection contains the specified object. otherwise false. returns this Collection.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return ((Collection)target).contains(params[0]);
            }
        }, new OperationImpl(this, "containsAll", this.getTypeSystem().getBooleanType(), new Type[]{this.getTypeSystem().getCollectionType(this.getTypeSystem().getObjectType())}){

            public String getDocumentation() {
                return "returns true if this collection contains each element contained in the specified collection. otherwise false. returns this Collection.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                return ((Collection)target).containsAll((Collection)params[0]);
            }
        }, new OperationImpl(this, "remove", (Type)this, new Type[]{this.getTypeSystem().getObjectType()}){

            public String getDocumentation() {
                return "removes the specified element from this Collection if contained (modifies it!). returns this Collection.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ((Collection)target).remove(params[0]);
                return target;
            }
        }, new OperationImpl(this, "removeAll", (Type)this, new Type[]{this.getTypeSystem().getObjectType()}){

            public String getDocumentation() {
                return "removes all elements contained in the specified collection from this Collection if contained (modifies it!). returns this Collection.";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                ((Collection)target).removeAll((Collection)params[0]);
                return target;
            }
        }, new OperationImpl(this, "union", this.getTypeSystem().getSetType(this.getInnerType()), new Type[]{this.getTypeSystem().getCollectionType(this.getTypeSystem().getObjectType())}){

            public String getDocumentation() {
                return "returns a new Set, containing all elements from this and the specified Collection";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                HashSet r = new HashSet((Collection)target);
                r.addAll((Collection)params[0]);
                return r;
            }
        }, new OperationImpl(this, "without", this.getTypeSystem().getSetType(this.getInnerType()), new Type[]{this.getTypeSystem().getCollectionType(this.getTypeSystem().getObjectType())}){

            public String getDocumentation() {
                return "returns a new Set, containing all elements from this Collection without the elements from specified Collection";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                HashSet r = new HashSet((Collection)target);
                r.removeAll((Collection)params[0]);
                return r;
            }
        }, new OperationImpl(this, "intersect", this.getTypeSystem().getSetType(this.getInnerType()), new Type[]{this.getTypeSystem().getCollectionType(this.getTypeSystem().getObjectType())}){

            public String getDocumentation() {
                return "returns a new Set, containing only the elements contained in this and the specified Collection";
            }

            public Object evaluateInternal(Object target, Object[] params) {
                HashSet r = new HashSet((Collection)target);
                r.retainAll((Collection)params[0]);
                return r;
            }
        }, new OperationImpl(this, "flatten", this.getTypeSystem().getListType(this.getTypeSystem().getObjectType()), new Type[0]){

            @Override
            public String getDocumentation() {
                return "returns a flatten List.";
            }

            @Override
            public Object evaluateInternal(Object target, Object[] params) {
                return this.flattenRec((Collection)target);
            }

            public List<Object> flattenRec(Collection col) {
                ArrayList<Object> result = new ArrayList<Object>();
                for (Object element : col) {
                    if (element instanceof Collection) {
                        result.addAll(this.flattenRec((Collection)element));
                        continue;
                    }
                    result.add(element);
                }
                return result;
            }
        }};
    }

    public Set<Type> getSuperTypes() {
        return Collections.singleton(this.getTypeSystem().getObjectType());
    }

    @Override
    public String toString() {
        String s = this.getName();
        if (this.innerType != null) {
            s = String.valueOf(s) + "[" + this.innerType + "]";
        }
        return s;
    }
}

