/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.internal.xtend.expression.ast;

import java.util.Set;
import org.eclipse.internal.xtend.expression.ast.Expression;
import org.eclipse.internal.xtend.expression.ast.Identifier;
import org.eclipse.internal.xtend.expression.ast.SyntaxElement;
import org.eclipse.xtend.expression.AnalysationIssue;
import org.eclipse.xtend.expression.EvaluationException;
import org.eclipse.xtend.expression.ExecutionContext;
import org.eclipse.xtend.typesystem.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructorCallExpression
extends Expression {
    private Identifier type;

    public ConstructorCallExpression(Identifier type) {
        this.type = type;
    }

    public String getTypeName() {
        return this.type.getValue();
    }

    @Override
    protected Object evaluateInternal(ExecutionContext ctx) {
        Type t = ctx.getTypeForName(this.type.getValue());
        if (t != null) {
            return t.newInstance();
        }
        throw new EvaluationException("Couldn't find type " + this.type, (SyntaxElement)this, ctx);
    }

    @Override
    public Type analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        Type t = ctx.getTypeForName(this.type.getValue());
        if (t == null) {
            issues.add(new AnalysationIssue(AnalysationIssue.TYPE_NOT_FOUND, "Type not found : " + this.type, this.type));
        }
        return t;
    }

    @Override
    protected String toStringInternal() {
        return "new " + this.getTypeName();
    }
}

