/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.WriterPositionException;
import org.eclipse.jet.internal.InternalJET2Platform;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ILineTrackerExtension;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Position;

public class BodyContentWriter
implements BufferedJET2Writer {
    private final BodyContentWriter parentWriter;
    private final IDocument document = new StringBufferDocument();
    private final Map listeners;
    static /* synthetic */ Class class$0;

    public BodyContentWriter() {
        this.parentWriter = null;
        this.listeners = new LinkedHashMap(5);
    }

    private BodyContentWriter(BodyContentWriter parentWriter) {
        this.parentWriter = parentWriter;
        this.listeners = Collections.EMPTY_MAP;
    }

    public final void write(String string) {
        try {
            this.document.replace(this.document.getLength(), 0, string != null ? string : "null");
        }
        catch (BadLocationException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
    }

    public final void write(JET2Writer bodyContent) {
        if (!(bodyContent instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        BufferedJET2Writer bufferedWriter = (BufferedJET2Writer)bodyContent;
        int positionDelta = this.document.getLength();
        this.write(bufferedWriter.getContent());
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IDocument childDocument = (IDocument)bufferedWriter.getAdapter((Class)clazz);
            String[] categories = childDocument.getPositionCategories();
            int i = 0;
            while (i < categories.length) {
                DocumentHelper.installPositionCategory(this.document, categories[i]);
                Position[] positions = childDocument.getPositions(categories[i]);
                int j = 0;
                while (j < positions.length) {
                    childDocument.removePosition(categories[i], positions[j]);
                    positions[j].setOffset(positions[j].getOffset() + positionDelta);
                    this.document.addPosition(categories[i], positions[j]);
                    ++j;
                }
                ++i;
            }
        }
        catch (BadPositionCategoryException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
        catch (BadLocationException e) {
            InternalJET2Platform.logError("Internal Error", (Exception)((Object)e));
        }
    }

    public final void write(int i) {
        this.write(String.valueOf(i));
    }

    public String toString() {
        return this.document.get();
    }

    public final JET2Writer newNestedContentWriter() {
        return new BodyContentWriter(this);
    }

    public final int getLength() {
        return this.getContentLength();
    }

    public final IDocument getDocument() {
        return this.document;
    }

    public final void addEventListener(String category, IWriterListener listener) {
        if (this.parentWriter != null) {
            this.parentWriter.addEventListener(category, listener);
        } else if (!this.listeners.containsKey(category)) {
            this.listeners.put(category, listener);
        }
    }

    public final void addPositionCategory(String category) {
        DocumentHelper.installPositionCategory(this.document, category);
    }

    public final void addPosition(String category, Position position) {
        try {
            this.document.addPosition(category, position);
        }
        catch (BadLocationException e) {
            throw new WriterPositionException(e);
        }
        catch (BadPositionCategoryException e) {
            throw new WriterPositionException(e);
        }
    }

    public final Position[] getPositions(String category) {
        try {
            return this.document.getPositions(category);
        }
        catch (BadPositionCategoryException e) {
            throw new WriterPositionException(e);
        }
    }

    public final void replace(int offset, int length, String text) {
        try {
            this.document.replace(offset, length, text);
        }
        catch (BadLocationException e) {
            throw new WriterPositionException(e);
        }
    }

    public final JET2Writer getParentWriter() {
        return this.parentWriter;
    }

    public final void write(boolean b) {
        this.write(String.valueOf(b));
    }

    public final void write(char c) {
        this.write(String.valueOf(c));
    }

    public final void write(char[] data) {
        this.write(String.valueOf(data));
    }

    public final void write(double d) {
        this.write(String.valueOf(d));
    }

    public final void write(float f) {
        this.write(String.valueOf(f));
    }

    public final void write(long l) {
        this.write(String.valueOf(l));
    }

    public final void write(Object obj) {
        this.write(obj != null ? obj.toString() : "");
    }

    public String getContent() {
        return this.document.get();
    }

    public int getContentLength() {
        return this.getContent().length();
    }

    public IWriterListener[] getEventListeners() {
        return this.listeners.values().toArray(new IWriterListener[this.listeners.size()]);
    }

    public void replaceContent(int offset, int length, String text) {
        try {
            this.document.replace(offset, length, text);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException();
        }
    }

    public void setContent(String content) {
        this.document.set(content);
    }

    public String getContent(int offset, int length) {
        try {
            return this.document.get(offset, length);
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException();
        }
    }

    public Object getAdapter(Class adapterClass) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapterClass == clazz) {
            return this.document;
        }
        return null;
    }

    private static class LazyLineTracker
    implements ILineTracker,
    ILineTrackerExtension {
        private final IDocument document;

        public LazyLineTracker(IDocument document) {
            this.document = document;
        }

        private ILineTracker getDelegate() {
            DefaultLineTracker lineTracker = new DefaultLineTracker();
            lineTracker.set(this.document.get());
            return lineTracker;
        }

        public int computeNumberOfLines(String text) {
            return this.getDelegate().computeNumberOfLines(text);
        }

        public String[] getLegalLineDelimiters() {
            return this.getDelegate().getLegalLineDelimiters();
        }

        public String getLineDelimiter(int line) throws BadLocationException {
            return this.getDelegate().getLineDelimiter(line);
        }

        public IRegion getLineInformation(int line) throws BadLocationException {
            return this.getDelegate().getLineInformation(line);
        }

        public IRegion getLineInformationOfOffset(int offset) throws BadLocationException {
            return this.getDelegate().getLineInformationOfOffset(offset);
        }

        public int getLineLength(int line) throws BadLocationException {
            return this.getDelegate().getLineLength(line);
        }

        public int getLineNumberOfOffset(int offset) throws BadLocationException {
            return this.getDelegate().getLineNumberOfOffset(offset);
        }

        public int getLineOffset(int line) throws BadLocationException {
            return this.getDelegate().getLineOffset(line);
        }

        public int getNumberOfLines() {
            return this.getDelegate().getNumberOfLines();
        }

        public int getNumberOfLines(int offset, int length) throws BadLocationException {
            return this.getDelegate().getNumberOfLines(offset, length);
        }

        public void replace(int offset, int length, String text) throws BadLocationException {
        }

        public void set(String text) {
        }

        public void startRewriteSession(DocumentRewriteSession session) throws IllegalStateException {
        }

        public void stopRewriteSession(DocumentRewriteSession session, String text) {
        }
    }

    private static class StringBufferDocument
    extends AbstractDocument {
        private boolean defaultPositionCategoryInitialized = false;
        private static final Position[] EMPTY_POSITION_ARRAY = new Position[0];
        private ILineTracker lazyLineTracker;
        private final ITextStore textStore = new StringBufferTextStore();

        public StringBufferDocument() {
            this.completeInitialization();
        }

        protected ILineTracker getTracker() {
            if (this.lazyLineTracker == null) {
                this.lazyLineTracker = new LazyLineTracker((IDocument)this);
            }
            return this.lazyLineTracker;
        }

        protected ITextStore getStore() {
            return this.textStore;
        }

        protected void completeInitialization() {
            super.completeInitialization();
            this.removePositionUpdater(this.getPositionUpdaters()[0]);
            try {
                super.removePositionCategory("__dflt_position_category");
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public void addPosition(String category, Position position) throws BadLocationException, BadPositionCategoryException {
            if (!this.defaultPositionCategoryInitialized && "__dflt_position_category".equals(category)) {
                this.addPositionCategory("__dflt_position_category");
                this.addPositionUpdater((IPositionUpdater)new DefaultPositionUpdater("__dflt_position_category"));
                this.defaultPositionCategoryInitialized = true;
            }
            super.addPosition(category, position);
        }

        public int computeIndexInCategory(String category, int offset) throws BadLocationException, BadPositionCategoryException {
            if (!this.defaultPositionCategoryInitialized && "__dflt_position_category".equals(category)) {
                return 0;
            }
            return super.computeIndexInCategory(category, offset);
        }

        public Position[] getPositions(String category) throws BadPositionCategoryException {
            if (!this.defaultPositionCategoryInitialized && "__dflt_position_category".equals(category)) {
                return EMPTY_POSITION_ARRAY;
            }
            return super.getPositions(category);
        }

        public void removePosition(String category, Position position) throws BadPositionCategoryException {
            if (!this.defaultPositionCategoryInitialized && "__dflt_position_category".equals(category)) {
                return;
            }
            super.removePosition(category, position);
        }

        public void removePositionCategory(String category) throws BadPositionCategoryException {
            if (!this.defaultPositionCategoryInitialized && "__dflt_position_category".equals(category)) {
                this.defaultPositionCategoryInitialized = true;
                return;
            }
            super.removePositionCategory(category);
        }

        public void addDocumentListener(IDocumentListener listener) {
            throw new UnsupportedOperationException();
        }

        public void set(String text, long modificationStamp) {
            this.getStore().set(text);
            this.getTracker().set(text);
        }

        public void replace(int pos, int length, String text, long modificationStamp) throws BadLocationException {
            if (pos < 0 || length < 0 || pos + length > this.getLength()) {
                throw new BadLocationException();
            }
            this.getStore().replace(pos, length, text);
            this.getTracker().replace(pos, length, text);
            DocumentEvent e = new DocumentEvent((IDocument)this, pos, length, text);
            this.updatePositions(e);
        }
    }

    private static class StringBufferTextStore
    implements ITextStore {
        private final StringBuffer buffer = new StringBuffer(1024);

        private StringBufferTextStore() {
        }

        public char get(int offset) {
            return this.buffer.charAt(offset);
        }

        public String get(int offset, int length) {
            return this.buffer.substring(offset, offset + length);
        }

        public void set(String text) {
            this.buffer.replace(0, this.buffer.length(), text);
        }

        public int getLength() {
            return this.buffer.length();
        }

        public void replace(int offset, int length, String text) {
            if (offset == this.buffer.length() && length == 0) {
                this.buffer.append(text);
            } else {
                this.buffer.replace(offset, offset + length, text);
            }
        }
    }
}

