/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.xpath.inspector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.jet.xpath.inspector.ExpandedName;
import org.eclipse.jet.xpath.inspector.INodeInspector;

public final class InspectorManager {
    private final INodeInspector unknownObjectInspector = new UnknownObjectInspector();
    private static InspectorManager instance = null;
    private Map inspectorInstances = new HashMap();
    private Map cachedInspectorsByConcreteClass = new HashMap();
    private final Map registeredInspectorsByInspectableClass = new HashMap();

    private InspectorManager() {
    }

    public static InspectorManager getInstance() {
        if (instance == null) {
            instance = new InspectorManager();
        }
        return instance;
    }

    private void computeClassOrder(Class adaptable, Collection classes) {
        Class clazz = adaptable;
        HashSet seen = new HashSet(4);
        while (clazz != null) {
            classes.add(clazz);
            this.computeInterfaceOrder(clazz.getInterfaces(), classes, seen);
            clazz = clazz.getSuperclass();
        }
    }

    private void computeInterfaceOrder(Class[] interfaces, Collection classes, Set seen) {
        ArrayList<Class> newInterfaces = new ArrayList<Class>(interfaces.length);
        int i = 0;
        while (i < interfaces.length) {
            Class interfac = interfaces[i];
            if (seen.add(interfac)) {
                classes.add(interfac);
                newInterfaces.add(interfac);
            }
            ++i;
        }
        Iterator it = newInterfaces.iterator();
        while (it.hasNext()) {
            this.computeInterfaceOrder(((Class)it.next()).getInterfaces(), classes, seen);
        }
    }

    public synchronized void registerInspector(Class[] inspectableClasses, Class inspectorClass) {
        int i = 0;
        while (i < inspectableClasses.length) {
            this.registeredInspectorsByInspectableClass.put(inspectableClasses[i].getName(), inspectorClass);
            ++i;
        }
        this.flushCaches();
    }

    public synchronized void registerInspector(String[] inspectableClassNames, Class inspectorClass) {
        int i = 0;
        while (i < inspectableClassNames.length) {
            this.registeredInspectorsByInspectableClass.put(inspectableClassNames[i], inspectorClass);
            ++i;
        }
        this.flushCaches();
    }

    public INodeInspector getInspector(Object object) {
        if (object == null) {
            return null;
        }
        Map cache = this.cachedInspectorsByConcreteClass;
        String inspectableClassName = object.getClass().getName();
        INodeInspector inspector = (INodeInspector)cache.get(inspectableClassName);
        if (inspector == null) {
            ArrayList classOrder = new ArrayList();
            this.computeClassOrder(object.getClass(), classOrder);
            Iterator i = classOrder.iterator();
            while (i.hasNext()) {
                Class aClass = (Class)i.next();
                Class inspectorClass = (Class)this.registeredInspectorsByInspectableClass.get(aClass.getName());
                if (inspectorClass == null) continue;
                inspector = this.getInspectorInstance(inspectorClass);
                break;
            }
            if (inspector == null) {
                inspector = this.unknownObjectInspector;
            }
            cache.put(inspectableClassName, inspector);
        }
        return inspector;
    }

    private INodeInspector getInspectorInstance(Class inspectorClass) {
        INodeInspector inspector = null;
        try {
            Map inspectors = this.inspectorInstances;
            inspector = (INodeInspector)inspectors.get(inspectorClass.getName());
            if (inspector == null) {
                inspector = (INodeInspector)inspectorClass.newInstance();
                inspectors.put(inspectorClass.getName(), inspector);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return inspector;
    }

    private synchronized void flushCaches() {
        this.cachedInspectorsByConcreteClass = new HashMap();
        this.inspectorInstances = new HashMap();
    }

    public synchronized void unregisterInspector(String[] inspectableClassNames, String inspectorClassName) {
        int i = 0;
        while (i < inspectableClassNames.length) {
            this.registeredInspectorsByInspectableClass.remove(inspectableClassNames[i]);
            ++i;
        }
        this.flushCaches();
    }

    private static final class UnknownObjectInspector
    implements INodeInspector {
        private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

        private UnknownObjectInspector() {
        }

        public ExpandedName expandedNameOf(Object node) {
            return new ExpandedName("");
        }

        public Object[] getChildren(Object node) {
            return EMPTY_OBJECT_ARRAY;
        }

        public Object getDocumentRoot(Object node) {
            return null;
        }

        public INodeInspector.NodeKind getNodeKind(Object obj) {
            return null;
        }

        public Object getParent(Object obj) {
            return null;
        }

        public String nameOf(Object node) {
            return "";
        }

        public String stringValueOf(Object node) {
            return node.toString();
        }

        public boolean testExpandedName(Object node, ExpandedName testName) {
            return false;
        }
    }
}

