/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.compiler;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jet.compiler.IJETCompilerState;
import org.eclipse.jet.core.compiler.JETCompilerOptions;
import org.eclipse.jet.internal.builder.WorkspaceCompiler;
import org.eclipse.jet.internal.compiler.JETCompilerState;

public class JET2Compiler {
    public static final String RUNTIME_PROBLEM_MARKER = "org.eclipse.jet.runtimeProblem";
    public static final String COMPILE_PROBLEM_MARKER = "org.eclipse.jet.compileProblem";
    public static final String DEFAULT_COMPILED_TEMPLATE_PACKAGE = "org.eclipse.jet.compiled";
    public static final String DEFAULT_COMPILED_TEMPLATE_SRC_DIR = "jet2java";
    public static final String DEFAULT_TEMPLATE_EXT = "jet";
    public static final Boolean DEFAULT_SET_JAVA_FILES_AS_DERIVED = JETCompilerOptions.DEFAULT_SET_JAVA_FILES_AS_DERIVED;
    public static final String OPTION_COMPILED_TEMPLATE_PACKAGE = "org.eclipse.jet.compiledTemplatePackage";
    public static final String OPTION_COMPILED_TEMPLATE_SRC_DIR = "org.eclipse.jet.compiledTemplateSrcDir";
    public static final String OPTION_TEMPLATE_EXT = "org.eclipse.jet.templateExt";
    public static final String OPTION_SET_JAVA_FILES_AS_DERIVED = "org.eclipse.jet.setJavaDerived";
    private int noCompiles;
    private final Map options;
    private Set sourceExtensions = null;
    private final WorkspaceCompiler workspaceCompiler;

    public static Map getDefaultCompilerOptions() {
        return JETCompilerOptions.getDefaultCompilerOptions();
    }

    public JET2Compiler(IProject project, Map options, IJETCompilerState compilerState, IProgressMonitor monitor) {
        this.workspaceCompiler = new WorkspaceCompiler(project, null, options, monitor);
        this.options = options == null ? JETCompilerOptions.getDefaultCompilerOptions() : options;
        this.noCompiles = 0;
    }

    public JET2Compiler(IProject project, IProgressMonitor monitor, Map options) {
        this(project, options, new JETCompilerState(), monitor);
    }

    public void createTransformFiles() {
        this.workspaceCompiler.finish();
    }

    private boolean isJETSource(IPath path) {
        if (this.sourceExtensions == null) {
            this.sourceExtensions = new HashSet();
            String[] extensions = JETCompilerOptions.getStringOption((Map)this.options, (String)OPTION_TEMPLATE_EXT).split(",");
            int i = 0;
            while (i < extensions.length) {
                this.sourceExtensions.add(extensions[i]);
                ++i;
            }
        }
        return this.sourceExtensions.contains(path.getFileExtension());
    }

    public boolean isJET2SourceFile(IResource resource) {
        return resource.getType() == 1 && this.isJETSource(resource.getFullPath());
    }

    public void compile(IResource resource) {
        ++this.noCompiles;
        this.workspaceCompiler.compile(resource.getProjectRelativePath().toString());
    }

    public void removeDerivedResources(IResource resource) throws CoreException {
        this.removeDerivedResources(resource, false);
    }

    public void removeDerivedResources(IResource resource, boolean derivedOnly) throws CoreException {
        this.workspaceCompiler.removeTemplate(resource.getProjectRelativePath().toString());
    }

    public final int getNoCompiles() {
        return this.noCompiles;
    }

    public void clean() {
        this.workspaceCompiler.clean();
    }
}

