/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.runtime;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jet.AbstractContextExtender;
import org.eclipse.jet.ContextLogEntry;
import org.eclipse.jet.JET2Context;
import org.eclipse.jet.internal.runtime.RuntimeTagLogger;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jet.transform.TransformContextExtender;

public class RuntimeLoggerContextExtender
extends AbstractContextExtender {
    public static final int ERROR_LEVEL = 5;
    public static final int WARNING_LEVEL = 4;
    public static final int INFO_LEVEL = 3;
    public static final int TRACE_LEVEL = 2;
    public static final int DEBUG_LEVEL = 1;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static RuntimeLoggerContextExtender getInstance(JET2Context context) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (context.hasContextExtender((Class)clazz)) {
            return new RuntimeLoggerContextExtender(context);
        }
        return null;
    }

    public static void install(JET2Context context) {
        new RuntimeLoggerContextExtender(context);
    }

    private RuntimeLoggerContextExtender(JET2Context context) {
        super(context);
    }

    protected Object createExtendedData(JET2Context context) {
        RuntimeLogger runtimeLogger = new RuntimeLogger();
        context.addLogListener((JET2Context.LogListener)runtimeLogger);
        return runtimeLogger;
    }

    private RuntimeLogger getRuntimeLogger() {
        return (RuntimeLogger)this.getExtendedData();
    }

    public void addListener(RuntimeTagLogger logger) {
        this.getRuntimeLogger().listeners.add(logger);
    }

    public void removeListener(RuntimeTagLogger logger) {
        this.getRuntimeLogger().listeners.remove(logger);
    }

    public static void log(JET2Context context, String message, TagInfo td, int level) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (context.hasContextExtender((Class)clazz)) {
            RuntimeLoggerContextExtender rl = RuntimeLoggerContextExtender.getInstance(context);
            String templatePath = null;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jet.transform.TransformContextExtender");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (context.hasContextExtender((Class)clazz2)) {
                TransformContextExtender tce = new TransformContextExtender(context);
                templatePath = tce.getTemplatePath();
            }
            rl.log(message, td, templatePath, level);
        }
    }

    public void log(String message, TagInfo td, String templatePath, int level) {
        Iterator i = this.getRuntimeLogger().listeners.iterator();
        while (i.hasNext()) {
            RuntimeTagLogger logger = (RuntimeTagLogger)i.next();
            logger.log(message, td, templatePath, level);
        }
    }

    public static void log(JET2Context context, String message, TagInfo tagInfo, String templatePath, int level) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.internal.runtime.RuntimeLoggerContextExtender");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (context.hasContextExtender((Class)clazz)) {
            RuntimeLoggerContextExtender.getInstance(context).getRuntimeLogger().log(message, tagInfo, templatePath, level);
        }
    }

    private static final class RuntimeLogger
    implements JET2Context.LogListener {
        private final List listeners = new ArrayList();

        private RuntimeLogger() {
        }

        public void log(String message, TagInfo td, String templatePath, int level) {
            Iterator i = this.listeners.iterator();
            while (i.hasNext()) {
                RuntimeTagLogger logger = (RuntimeTagLogger)i.next();
                logger.log(message, td, templatePath, level);
            }
        }

        public void log(ContextLogEntry entry) {
            this.log(entry.getMessage(), entry.getTagInfo(), entry.getTemplatePath(), this.getLevel(entry.getSeverity()));
        }

        private int getLevel(int severity) {
            switch (severity) {
                case 4: 
                case 8: {
                    return 5;
                }
                case 2: {
                    return 4;
                }
                case 0: 
                case 1: {
                    return 3;
                }
            }
            return 5;
        }
    }
}

