/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.ui.prefs;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jet.internal.ui.l10n.Messages;
import org.eclipse.jet.internal.ui.prefs.ExtensionListEditor;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CompilePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private IProject element;
    private StringFieldEditor packageFieldEditor;
    private ExtensionListEditor extFieldEditor;
    private StringFieldEditor srcFolderFieldEditor;
    private BooleanFieldEditor derivedJavaFieldEditor;
    private BooleanFieldEditor projectSpecificSettingsEditor = null;

    public CompilePreferencePage() {
        super(1);
        this.setDescription(Messages.CompilePreferencePage_Description);
    }

    protected void createFieldEditors() {
        if (this.element == null) {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "org.eclipse.jet"));
        } else {
            this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore((IScopeContext)new ProjectScope(this.element), "org.eclipse.jet"));
            this.projectSpecificSettingsEditor = new BooleanFieldEditor("org.eclipse.jet.projectPrefs", Messages.CompilePreferencePage_EnableProjectSettings, this.getFieldEditorParent());
            this.addField((FieldEditor)this.projectSpecificSettingsEditor);
        }
        this.packageFieldEditor = new StringFieldEditor("org.eclipse.jet.compiledTemplatePackage", Messages.CompilePreferencePage_JavaPackage, this.getFieldEditorParent());
        this.addField((FieldEditor)this.packageFieldEditor);
        this.extFieldEditor = new ExtensionListEditor("org.eclipse.jet.templateExt", Messages.CompilePreferencePage_FileExtensions, this.getFieldEditorParent());
        this.addField((FieldEditor)this.extFieldEditor);
        this.srcFolderFieldEditor = new StringFieldEditor("org.eclipse.jet.compiledTemplateSrcDir", Messages.CompilePreferencePage_SourceFolder, this.getFieldEditorParent());
        this.addField((FieldEditor)this.srcFolderFieldEditor);
        this.derivedJavaFieldEditor = new BooleanFieldEditor("org.eclipse.jet.setJavaDerived", Messages.CompilePreferencePage_DeriveJavaFiles, this.getFieldEditorParent());
        this.addField((FieldEditor)this.derivedJavaFieldEditor);
    }

    private void updateControlEnablement() {
        boolean enabled = this.projectSpecificSettingsEditor.getBooleanValue();
        this.packageFieldEditor.setEnabled(enabled, this.getFieldEditorParent());
        this.extFieldEditor.setEnabled(enabled, this.getFieldEditorParent());
        this.srcFolderFieldEditor.setEnabled(enabled, this.getFieldEditorParent());
        this.derivedJavaFieldEditor.setEnabled(enabled, this.getFieldEditorParent());
        if (!enabled) {
            this.packageFieldEditor.loadDefault();
            this.extFieldEditor.loadDefault();
            this.srcFolderFieldEditor.loadDefault();
            this.derivedJavaFieldEditor.loadDefault();
        }
    }

    public void init(IWorkbench workbench) {
    }

    public IAdaptable getElement() {
        return this.element;
    }

    public void setElement(IAdaptable element) {
        this.element = (IProject)element;
    }

    protected void initialize() {
        super.initialize();
        if (this.projectSpecificSettingsEditor != null) {
            this.updateControlEnablement();
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource() == this.projectSpecificSettingsEditor && "field_editor_value".equals(event.getProperty())) {
            this.updateControlEnablement();
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.projectSpecificSettingsEditor != null) {
            this.updateControlEnablement();
        }
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        if (ok) {
            try {
                if (this.element != null) {
                    this.element.build(15, null);
                } else {
                    ResourcesPlugin.getWorkspace().build(15, null);
                }
            }
            catch (CoreException coreException) {}
        }
        return ok;
    }
}

