/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.core.parser.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jet.core.parser.ast.BodyElement;
import org.eclipse.jet.core.parser.ast.JETASTElement;

class BodyElements {
    private List bodyElements = new ArrayList();
    private final JETASTElement owner;

    public BodyElements(JETASTElement owner) {
        this.owner = owner;
    }

    public List getBodyElements() {
        return Collections.unmodifiableList(this.bodyElements);
    }

    public void addBodyElement(BodyElement bodyElement) {
        this.bodyElements.add(bodyElement);
        bodyElement.setParent(this.owner);
    }

    public final JETASTElement getOwner() {
        return this.owner;
    }

    public BodyElement elementAfter(JETASTElement element) {
        BodyElement nextElement = null;
        if (this.bodyElements == null) {
            throw new IllegalArgumentException();
        }
        int index = this.bodyElements.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        if (index + 1 < this.bodyElements.size()) {
            nextElement = (BodyElement)this.bodyElements.get(index + 1);
        }
        return nextElement;
    }

    public BodyElement elementBefore(JETASTElement element) {
        BodyElement prevElement = null;
        if (this.bodyElements == null) {
            throw new IllegalArgumentException();
        }
        int index = this.bodyElements.indexOf(element);
        if (index == -1) {
            throw new IllegalArgumentException();
        }
        if (index > 0) {
            prevElement = (BodyElement)this.bodyElements.get(index - 1);
        }
        return prevElement;
    }
}

