/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.parser.ast.ocl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Stack;
import org.eclipse.acceleo.internal.parser.ast.ocl.WrappedOCLException;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironment;
import org.eclipse.acceleo.internal.parser.ast.ocl.environment.AcceleoEnvironmentFactory;
import org.eclipse.acceleo.model.mtl.Block;
import org.eclipse.acceleo.model.mtl.ForBlock;
import org.eclipse.acceleo.model.mtl.LetBlock;
import org.eclipse.acceleo.model.mtl.Macro;
import org.eclipse.acceleo.model.mtl.MacroInvocation;
import org.eclipse.acceleo.model.mtl.Module;
import org.eclipse.acceleo.model.mtl.ModuleElement;
import org.eclipse.acceleo.model.mtl.MtlFactory;
import org.eclipse.acceleo.model.mtl.Query;
import org.eclipse.acceleo.model.mtl.QueryInvocation;
import org.eclipse.acceleo.model.mtl.Template;
import org.eclipse.acceleo.model.mtl.TemplateInvocation;
import org.eclipse.acceleo.model.mtl.TypedModel;
import org.eclipse.acceleo.model.mtl.VisibilityKind;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.OCL;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VariableExp;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.CallingASTNode;
import org.eclipse.ocl.utilities.TypedASTNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLParser {
    public static final String ANNOTATION_SOURCE = "MTL";
    public static final String ANNOTATION_KEY_TYPE = "type";
    private Stack<EClassifier> contextStack = new Stack();
    private OCL.Helper helper;
    private AcceleoEnvironment environment;
    private Map<Variable, EObject> saveVariableContainer = new HashMap<Variable, EObject>();
    private Map<Variable, EStructuralFeature> saveVariableContainingFeature = new HashMap<Variable, EStructuralFeature>();
    private Map<EOperation, ModuleElement> eOperation2ModuleElement = new HashMap<EOperation, ModuleElement>();

    public OCLParser(Resource oclEnvironmentResource) {
        this.init(oclEnvironmentResource);
    }

    public void init(Resource oclEnvironmentResource) {
        this.helper = OCL.newInstance((EnvironmentFactory)AcceleoEnvironmentFactory.ACCELEO_INSTANCE, (Resource)oclEnvironmentResource).createOCLHelper();
        this.environment = (AcceleoEnvironment)this.helper.getEnvironment();
        this.helper.setContext((Object)EcorePackage.eINSTANCE.getEObject());
        this.contextStack.clear();
        this.saveVariableContainer.clear();
        this.saveVariableContainingFeature.clear();
        this.eOperation2ModuleElement.clear();
    }

    public void pushContext(EClassifier newContext) {
        this.helper.setContext((Object)newContext);
        this.contextStack.push(newContext);
    }

    public void popContext() {
        this.contextStack.pop();
        if (this.contextStack.isEmpty()) {
            this.helper.setContext((Object)EcorePackage.eINSTANCE.getEObject());
        } else {
            this.helper.setContext((Object)this.contextStack.peek());
        }
    }

    public void addVariableToScope(Variable newVariable) {
        if (newVariable != null && newVariable.getName() != null && newVariable.getName().length() > 0) {
            if (newVariable.getType() == null) {
                this.resolveType(newVariable);
            }
            EObject eContainer = newVariable.eContainer();
            EStructuralFeature eContainingFeature = newVariable.eContainingFeature();
            this.saveVariableContainer.put(newVariable, eContainer);
            this.saveVariableContainingFeature.put(newVariable, eContainingFeature);
            this.environment.addElement(newVariable.getName(), (org.eclipse.ocl.expressions.Variable)newVariable, true);
        }
    }

    private void resolveType(Variable newVariable) {
        String type;
        EAnnotation eAnnotation = newVariable.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)ANNOTATION_KEY_TYPE)) != null) {
            EClassifier eType = this.lookupClassifier(type);
            if (eType != null && eType != this.getInvalidType()) {
                newVariable.getEAnnotations().remove((Object)eAnnotation);
            }
            newVariable.setType((Object)eType);
        }
    }

    public EClassifier addRecursivelyVariablesToScopeAndGetContextClassifierAt(Module oModule, int offset) {
        Variable eContext = null;
        for (ModuleElement oModuleElement : oModule.getOwnedModuleElement()) {
            Variable oContext;
            if (offset <= oModuleElement.getStartPosition() || offset >= oModuleElement.getEndPosition()) continue;
            if (oModuleElement instanceof Template) {
                Template oTemplate = (Template)oModuleElement;
                if (oTemplate.getParameter().size() > 0) {
                    eContext = (Variable)oTemplate.getParameter().get(0);
                }
                this.addVariablesToScope((List<Variable>)oTemplate.getParameter());
            } else if (oModuleElement instanceof Query) {
                Query oQuery = (Query)oModuleElement;
                if (oQuery.getParameter().size() > 0) {
                    eContext = (Variable)oQuery.getParameter().get(0);
                }
                this.addVariablesToScope((List<Variable>)oQuery.getParameter());
            } else if (oModuleElement instanceof Macro) {
                Macro oMacro = (Macro)oModuleElement;
                if (oMacro.getParameter().size() > 0) {
                    eContext = (Variable)oMacro.getParameter().get(0);
                }
                this.addVariablesToScope((List<Variable>)oMacro.getParameter());
            }
            if (!(oModuleElement instanceof Block) || (oContext = this.addVariablesToScope((Block)oModuleElement, offset)) == null) break;
            eContext = oContext;
            break;
        }
        if (eContext != null) {
            return (EClassifier)eContext.getType();
        }
        return null;
    }

    private void addVariablesToScope(List<Variable> newVariables) {
        Iterator<Variable> newVariablesIt = new ArrayList<Variable>(newVariables).iterator();
        while (newVariablesIt.hasNext()) {
            this.addVariableToScope(newVariablesIt.next());
        }
    }

    private Variable addVariablesToScope(Block block, int offset) {
        Variable eContext = null;
        if (offset > block.getStartPosition() && offset < block.getEndPosition()) {
            if (block instanceof ForBlock) {
                eContext = ((ForBlock)block).getLoopVariable();
                this.addVariableToScope(((ForBlock)block).getLoopVariable());
            }
            if (block instanceof LetBlock) {
                eContext = ((LetBlock)block).getLetVariable();
                this.addVariableToScope(((LetBlock)block).getLetVariable());
            }
            if (block.getInit() != null) {
                this.addVariablesToScope((List<Variable>)block.getInit().getVariable());
            }
            for (EObject eContent : block.eContents()) {
                Variable oContext;
                if (!(eContent instanceof Block) || (oContext = this.addVariablesToScope((Block)eContent, offset)) == null) continue;
                eContext = oContext;
                break;
            }
        }
        return eContext;
    }

    public void addRecursivelyBehavioralFeaturesToScope(Module oModule) {
        this.addRecursivelyBehavioralFeaturesToScope(oModule, true, true, null);
    }

    public void addRecursivelyBehavioralFeaturesToScope(Module oModule, boolean operationWithReceiver, boolean operationWithoutReceiver, String startsWith) {
        this.addBehavioralFeaturesToScope(oModule, VisibilityKind.PRIVATE, operationWithReceiver, operationWithoutReceiver, startsWith);
        for (Module oOtherModule : oModule.getImports()) {
            this.addBehavioralFeaturesToScope(oOtherModule, VisibilityKind.PUBLIC, operationWithReceiver, operationWithoutReceiver, startsWith);
        }
        ArrayList<Module> allExtends = new ArrayList<Module>();
        this.computeAllExtends(allExtends, oModule);
        for (Module oOtherModule : allExtends) {
            this.addBehavioralFeaturesToScope(oOtherModule, VisibilityKind.PROTECTED, operationWithReceiver, operationWithoutReceiver, startsWith);
        }
    }

    private void computeAllExtends(List<Module> allExtends, Module oModule) {
        ArrayList<Module> toBrowse = new ArrayList<Module>();
        for (Module oOtherModule : oModule.getExtends()) {
            if (allExtends.contains(oOtherModule)) continue;
            allExtends.add(oOtherModule);
            toBrowse.add(oOtherModule);
        }
        for (Module oOtherModule : toBrowse) {
            this.computeAllExtends(allExtends, oOtherModule);
        }
    }

    private void addBehavioralFeaturesToScope(Module oModule, VisibilityKind lowestVisibilityKind, boolean operationWithReceiver, boolean operationWithoutReceiver, String startsWith) {
        TreeIterator itObjects = oModule.eAllContents();
        while (itObjects.hasNext()) {
            ModuleElement eModuleElement;
            EObject eObject = (EObject)itObjects.next();
            if (!(eObject instanceof ModuleElement) || (eModuleElement = (ModuleElement)eObject).getVisibility().getValue() < lowestVisibilityKind.getValue() || startsWith != null && (eModuleElement.getName() == null || !eModuleElement.getName().toLowerCase().startsWith(startsWith.toLowerCase()))) continue;
            if (eObject instanceof Template) {
                Template eTemplate = (Template)eObject;
                this.addTemplateToScope(eTemplate, operationWithReceiver, operationWithoutReceiver);
                continue;
            }
            if (eObject instanceof Query) {
                Query eQuery = (Query)eObject;
                this.addQueryToScope(eQuery, operationWithReceiver, operationWithoutReceiver);
                continue;
            }
            if (!(eObject instanceof Macro)) continue;
            Macro eMacro = (Macro)eObject;
            this.addMacroToScope(eMacro, operationWithReceiver, operationWithoutReceiver);
        }
    }

    private void addTemplateToScope(Template newTemplate, boolean operationWithReceiver, boolean operationWithoutReceiver) {
        EClass owner = EcorePackage.eINSTANCE.getEObject();
        if (newTemplate != null && newTemplate.getName() != null && newTemplate.getName().length() > 0) {
            EAnnotation eAnnotation;
            EOperation eOperation;
            Constraint constraint;
            EClassifier type = (EClassifier)this.environment.getOCLStandardLibrary().getString();
            EList params = newTemplate.getParameter();
            Iterator paramsIt = params.iterator();
            while (paramsIt.hasNext()) {
                this.resolveType((Variable)paramsIt.next());
            }
            if (operationWithoutReceiver) {
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newTemplate.getName(), type, (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newTemplate);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newTemplate);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
            if (operationWithReceiver && params.size() > 0 && ((Variable)params.get(0)).getType() != null) {
                owner = (EClassifier)((Variable)params.get(0)).getType();
                params = new BasicEList((Collection)params);
                params.remove(0);
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newTemplate.getName(), type, (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newTemplate);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newTemplate);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
        }
    }

    private void addQueryToScope(Query newQuery, boolean operationWithReceiver, boolean operationWithoutReceiver) {
        EClass owner = EcorePackage.eINSTANCE.getEObject();
        if (newQuery != null && newQuery.getName() != null && newQuery.getName().length() > 0) {
            EAnnotation eAnnotation;
            EOperation eOperation;
            Constraint constraint;
            this.resolveType(newQuery);
            EList params = newQuery.getParameter();
            Iterator paramsIt = params.iterator();
            while (paramsIt.hasNext()) {
                this.resolveType((Variable)paramsIt.next());
            }
            if (operationWithoutReceiver) {
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newQuery.getName(), newQuery.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newQuery);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newQuery);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
            if (operationWithReceiver && params.size() > 0 && ((Variable)params.get(0)).getType() != null) {
                owner = (EClassifier)((Variable)params.get(0)).getType();
                params = new BasicEList((Collection)params);
                params.remove(0);
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newQuery.getName(), newQuery.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newQuery);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newQuery);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
        }
    }

    private void resolveType(Query newQuery) {
        String type;
        EAnnotation eAnnotation = newQuery.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)ANNOTATION_KEY_TYPE)) != null) {
            EClassifier eType = this.lookupClassifier(type);
            if (eType != null && eType != this.getInvalidType()) {
                newQuery.getEAnnotations().remove((Object)eAnnotation);
            }
            newQuery.setType(eType);
        }
    }

    private void addMacroToScope(Macro newMacro, boolean operationWithReceiver, boolean operationWithoutReceiver) {
        EClass owner = EcorePackage.eINSTANCE.getEObject();
        if (newMacro != null && newMacro.getName() != null && newMacro.getName().length() > 0) {
            EAnnotation eAnnotation;
            EOperation eOperation;
            Constraint constraint;
            this.resolveType(newMacro);
            EList params = newMacro.getParameter();
            Iterator paramsIt = params.iterator();
            while (paramsIt.hasNext()) {
                this.resolveType((Variable)paramsIt.next());
            }
            if (operationWithoutReceiver) {
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newMacro.getName(), newMacro.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newMacro);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newMacro);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
            if (operationWithReceiver && params.size() > 0 && ((Variable)params.get(0)).getType() != null) {
                owner = (EClassifier)((Variable)params.get(0)).getType();
                params = new BasicEList((Collection)params);
                params.remove(0);
                constraint = EcoreFactory.eINSTANCE.createConstraint();
                eOperation = this.environment.defineOperation((EClassifier)owner, newMacro.getName(), newMacro.getType(), (List)params, constraint);
                if (eOperation != null) {
                    this.eOperation2ModuleElement.put(eOperation, (ModuleElement)newMacro);
                    eAnnotation = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                    eAnnotation.setSource(ANNOTATION_SOURCE);
                    eAnnotation.getReferences().add((Object)newMacro);
                    eOperation.getEAnnotations().add((Object)eAnnotation);
                }
            }
        }
    }

    private void resolveType(Macro newMacro) {
        String type;
        EAnnotation eAnnotation = newMacro.getEAnnotation(ANNOTATION_SOURCE);
        if (eAnnotation != null && (type = (String)eAnnotation.getDetails().get((Object)ANNOTATION_KEY_TYPE)) != null) {
            EClassifier eType = this.lookupClassifier(type);
            if (eType != null && eType != this.getInvalidType()) {
                newMacro.getEAnnotations().remove((Object)eAnnotation);
            }
            newMacro.setType(eType);
        }
    }

    public void removeRecursivelyBehavioralFeaturesToScope(Module oModule) {
    }

    public void addRecursivelyMetamodelsToScope(Module oModule) {
        for (TypedModel typedModel : oModule.getInput()) {
            Iterator takesTypesFromIt = typedModel.getTakesTypesFrom().iterator();
            while (takesTypesFromIt.hasNext()) {
                this.addMetamodel((EPackage)takesTypesFromIt.next());
            }
        }
    }

    public void addMetamodel(EPackage metamodel) {
        this.environment.addMetamodel(metamodel);
    }

    public void removeMetamodel(EPackage metamodel) {
        this.environment.removeMetamodel(metamodel);
    }

    public EClassifier lookupClassifier(String name) {
        return this.environment.lookupClassifier(name);
    }

    public Environment<?, EClassifier, EOperation, EStructuralFeature, ?, ?, ?, ?, ?, ?, ?, ?> getOCLEnvironment() {
        return this.helper.getEnvironment();
    }

    public List<EClassifier> getTypes() {
        return this.environment.getTypes();
    }

    public EClassifier getInvalidType() {
        return this.environment.getOCLStandardLibraryReflection().getOCLInvalid();
    }

    public EClassifier getIntegerType() {
        return (EClassifier)this.environment.getOCLStandardLibrary().getInteger();
    }

    public EClassifier getStringType() {
        return (EClassifier)this.environment.getOCLStandardLibrary().getString();
    }

    public OCLExpression parseOCLExpression(String text, int realOffsetInTheBuffer) throws ParserException {
        if (text.trim().equals("super")) {
            TemplateInvocation eTemplateInvocation = MtlFactory.eINSTANCE.createTemplateInvocation();
            eTemplateInvocation.setDefinition(null);
            eTemplateInvocation.setSuper(true);
            eTemplateInvocation.setStartPosition(realOffsetInTheBuffer);
            eTemplateInvocation.setEndPosition(realOffsetInTheBuffer + text.length());
            return eTemplateInvocation;
        }
        OCLExpression eOCLExpression = this.createQuery(text);
        this.shiftOCLExpressionPositions(realOffsetInTheBuffer, (EObject)eOCLExpression);
        TreeIterator eAllContents = eOCLExpression.eAllContents();
        while (eAllContents.hasNext()) {
            EObject eContent = (EObject)eAllContents.next();
            this.shiftOCLExpressionPositions(realOffsetInTheBuffer, eContent);
        }
        OCLExpression newOCLExpression = this.createAcceleoInvocation((EObject)eOCLExpression);
        if (newOCLExpression == null) {
            TreeIterator eAllContentsIt = eOCLExpression.eAllContents();
            while (eAllContentsIt.hasNext()) {
                this.createAcceleoInvocation((EObject)eAllContentsIt.next());
            }
            newOCLExpression = eOCLExpression;
        }
        return newOCLExpression;
    }

    private OCLExpression createQuery(String text) throws ParserException {
        this.environment.deleteFirstProblemObject();
        try {
            OCLExpression eOCLExpression = this.helper.createQuery(text);
            return eOCLExpression;
        }
        catch (ParserException e1) {
            Object firstProblemObject = this.environment.getFirstProblemObject();
            this.pushContext((EClassifier)EcorePackage.eINSTANCE.getEObject());
            try {
                OCLExpression eOCLExpression;
                OCLExpression oCLExpression = eOCLExpression = this.helper.createQuery(text);
                return oCLExpression;
            }
            catch (ParserException parserException) {
                if (firstProblemObject != null) {
                    throw new WrappedOCLException(e1, firstProblemObject);
                }
                throw e1;
            }
            finally {
                this.popContext();
            }
        }
    }

    private OCLExpression createAcceleoInvocation(EObject eObject) {
        Iterator referencesIt;
        OperationCallExp eCall;
        if (eObject instanceof CallExp) {
            this.createAcceleoInvocation((EObject)((CallExp)eObject).getSource());
        }
        if (eObject instanceof OperationCallExp && (eCall = (OperationCallExp)eObject).getReferredOperation() != null && ((EOperation)eCall.getReferredOperation()).getEAnnotation(ANNOTATION_SOURCE) != null && (referencesIt = ((EOperation)eCall.getReferredOperation()).getEAnnotation(ANNOTATION_SOURCE).getReferences().iterator()).hasNext()) {
            EObject eModuleElement = (EObject)referencesIt.next();
            return this.createAcceleoInvocation(eCall, eModuleElement);
        }
        return null;
    }

    private OCLExpression createAcceleoInvocation(OperationCallExp eCall, EObject eModuleElement) {
        TemplateInvocation eOCLExpression;
        if (eModuleElement instanceof Template) {
            TemplateInvocation eTemplateInvocation;
            Template eTemplate = (Template)eModuleElement;
            eOCLExpression = eTemplateInvocation = MtlFactory.eINSTANCE.createTemplateInvocation();
            eTemplateInvocation.setDefinition(eTemplate);
            eTemplateInvocation.setStartPosition(eCall.getStartPosition());
            eTemplateInvocation.setEndPosition(eCall.getEndPosition());
            if (this.receiverIsArgument(eCall, (List<Variable>)eTemplate.getParameter())) {
                eTemplateInvocation.getArgument().add((Object)((OCLExpression)eCall.getSource()));
            }
            eTemplateInvocation.setType((Object)((EClassifier)eCall.getType()));
            this.move((List)eCall.getArgument(), (List)eTemplateInvocation.getArgument());
            this.checkArgumentInvocations((List<OCLExpression>)eTemplateInvocation.getArgument());
            EcoreUtil.replace((EObject)eCall, (EObject)eTemplateInvocation);
        } else if (eModuleElement instanceof Query) {
            Query eQuery = (Query)eModuleElement;
            QueryInvocation eQueryInvocation = MtlFactory.eINSTANCE.createQueryInvocation();
            eOCLExpression = eQueryInvocation;
            eQueryInvocation.setDefinition(eQuery);
            eQueryInvocation.setStartPosition(eCall.getStartPosition());
            eQueryInvocation.setEndPosition(eCall.getEndPosition());
            if (this.receiverIsArgument(eCall, (List<Variable>)eQuery.getParameter())) {
                eQueryInvocation.getArgument().add((Object)((OCLExpression)eCall.getSource()));
            }
            eQueryInvocation.setType((Object)((EClassifier)eCall.getType()));
            this.move((List)eCall.getArgument(), (List)eQueryInvocation.getArgument());
            this.checkArgumentInvocations((List<OCLExpression>)eQueryInvocation.getArgument());
            EcoreUtil.replace((EObject)eCall, (EObject)eQueryInvocation);
        } else if (eModuleElement instanceof Macro) {
            Macro eMacro = (Macro)eModuleElement;
            MacroInvocation eMacroInvocation = MtlFactory.eINSTANCE.createMacroInvocation();
            eOCLExpression = eMacroInvocation;
            eMacroInvocation.setDefinition(eMacro);
            eMacroInvocation.setStartPosition(eCall.getStartPosition());
            eMacroInvocation.setEndPosition(eCall.getEndPosition());
            if (this.receiverIsArgument(eCall, (List<Variable>)eMacro.getParameter())) {
                eMacroInvocation.getArgument().add((Object)((OCLExpression)eCall.getSource()));
            }
            eMacroInvocation.setType((Object)((EClassifier)eCall.getType()));
            this.move((List)eCall.getArgument(), (List)eMacroInvocation.getArgument());
            this.checkArgumentInvocations((List<OCLExpression>)eMacroInvocation.getArgument());
            EcoreUtil.replace((EObject)eCall, (EObject)eMacroInvocation);
        } else {
            eOCLExpression = null;
        }
        return eOCLExpression;
    }

    private boolean receiverIsArgument(OperationCallExp eCall, List<Variable> variables) {
        boolean result;
        if (eCall.getSource() != null) {
            if (eCall.getSource() instanceof VariableExp && ((VariableExp)eCall.getSource()).getReferredVariable() != null) {
                if (eCall.getArgument().size() == 0) {
                    result = true;
                } else {
                    result = eCall.getArgument().size() < variables.size();
                    result = result && variables.size() != 0;
                }
            } else {
                result = true;
            }
        } else {
            result = false;
        }
        return result;
    }

    private void move(List in, List out) {
        out.addAll(in);
    }

    private void checkArgumentInvocations(List<OCLExpression> arguments) {
        ListIterator<OCLExpression> it = arguments.listIterator();
        while (it.hasNext()) {
            OCLExpression next = it.next();
            OCLExpression newArgument = this.createAcceleoInvocation((EObject)next);
            if (newArgument == null) continue;
            it.set(newArgument);
        }
    }

    private void shiftOCLExpressionPositions(int posBegin, EObject eContent) {
        if (eContent instanceof ASTNode && ((ASTNode)eContent).getStartPosition() >= 0) {
            ((ASTNode)eContent).setStartPosition(posBegin + ((ASTNode)eContent).getStartPosition());
            ((ASTNode)eContent).setEndPosition(posBegin + ((ASTNode)eContent).getEndPosition());
        }
        if (eContent instanceof CallingASTNode && ((CallingASTNode)eContent).getPropertyStartPosition() >= 0) {
            ((CallingASTNode)eContent).setPropertyStartPosition(posBegin + ((CallingASTNode)eContent).getPropertyStartPosition());
            ((CallingASTNode)eContent).setPropertyEndPosition(posBegin + ((CallingASTNode)eContent).getPropertyEndPosition());
        }
        if (eContent instanceof TypedASTNode && ((TypedASTNode)eContent).getTypeStartPosition() >= 0) {
            ((TypedASTNode)eContent).setTypeStartPosition(posBegin + ((TypedASTNode)eContent).getTypeStartPosition());
            ((TypedASTNode)eContent).setTypeEndPosition(posBegin + ((TypedASTNode)eContent).getTypeEndPosition());
        }
    }

    public void dispose() {
        this.saveVariableContainer.clear();
        this.saveVariableContainingFeature.clear();
    }

    public void removeVariableFromScope(Variable oldVariable) {
        if (oldVariable == null) {
            return;
        }
        EObject eContainer = this.saveVariableContainer.get(oldVariable);
        EStructuralFeature eContainingFeature = this.saveVariableContainingFeature.get(oldVariable);
        if (oldVariable.getName() != null && eContainer != null && eContainingFeature != null) {
            this.helper.getOCL().getEnvironment().deleteElement(oldVariable.getName());
            if (eContainingFeature.getUpperBound() == 1) {
                eContainer.eSet(eContainingFeature, (Object)oldVariable);
            } else {
                Object eGet = eContainer.eGet(eContainingFeature);
                if (eGet instanceof Collection) {
                    Collection list = (Collection)eGet;
                    list.add(oldVariable);
                }
            }
        }
        this.saveVariableContainer.remove(oldVariable);
        this.saveVariableContainingFeature.remove(oldVariable);
    }

    public List<Choice> getSyntaxHelp(String text) {
        ArrayList<Choice> result = new ArrayList<Choice>();
        result.addAll(this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, text));
        this.pushContext((EClassifier)EcorePackage.eINSTANCE.getEObject());
        try {
            result.addAll(this.helper.getSyntaxHelp(ConstraintKind.INVARIANT, text));
        }
        finally {
            this.popContext();
        }
        return result;
    }

    public ModuleElement getModuleElement(EOperation eOperation) {
        ModuleElement result = this.eOperation2ModuleElement.get(eOperation);
        if (result == null && eOperation != null) {
            for (Map.Entry<EOperation, ModuleElement> entry : this.eOperation2ModuleElement.entrySet()) {
                EOperation operation = entry.getKey();
                if (!this.equals(eOperation, operation)) continue;
                return entry.getValue();
            }
        }
        return result;
    }

    private boolean equals(EOperation o1, EOperation o2) {
        boolean result;
        if (o1 == o2) {
            result = true;
        } else if (o1 == null || o2 == null) {
            result = false;
        } else if (o1.getName() != null && o1.getName().equals(o2.getName()) && o1.getEParameters().size() == o2.getEParameters().size()) {
            Iterator params1 = o1.getEParameters().iterator();
            Iterator params2 = o2.getEParameters().iterator();
            while (params1.hasNext() && params2.hasNext()) {
                EParameter param1 = (EParameter)params1.next();
                EParameter param2 = (EParameter)params2.next();
                if (param1.getEType() == null || param2.getEType() == null || param1.getEType().getName() == null || param1.getEType().getName().equals(param2.getEType().getName())) continue;
                return false;
            }
            result = true;
        } else {
            result = false;
        }
        return result;
    }
}

