/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xpand.ui.refactoring.renamedefine;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.xpand.ui.Messages;
import org.eclipse.xpand.ui.editor.XpandEditor;
import org.eclipse.xtend.shared.ui.Activator;
import org.eclipse.xtend.shared.ui.core.IXtendXpandProject;
import org.eclipse.xtend.shared.ui.core.search.SearchMatch;
import org.eclipse.xtend.shared.ui.core.search.XtendXpandSearchEngine;

public class RenameDefineProcessor
extends RefactoringProcessor {
    private final XpandEditor editor;
    private final ITextSelection selection;
    private String newName;

    public RenameDefineProcessor(XpandEditor editor, ITextSelection selection) {
        this.editor = editor;
        this.selection = selection;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException, OperationCanceledException {
        return new RefactoringStatus();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        IFile sourceFile = this.getSourceFile();
        RefactoringStatus result = new RefactoringStatus();
        if (sourceFile == null || !sourceFile.exists()) {
            result.addFatalError(Messages.RenameDefineProcessor_NoSuchFile);
        } else if (sourceFile.isReadOnly()) {
            result.addFatalError(Messages.RenameDefineProcessor_FileReadonly);
        } else if (this.findXtendXpandProject() == null) {
            result.addFatalError(Messages.RenameDefineProcessor_NotXpandXtendProject);
        }
        return result;
    }

    private IFile getSourceFile() {
        IFile sourceFile = (IFile)this.editor.getEditorInput().getAdapter(IFile.class);
        return sourceFile;
    }

    private IXtendXpandProject findXtendXpandProject() {
        return Activator.getExtXptModelManager().findProject((IResource)this.getSourceFile());
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange result = new CompositeChange(Messages.RenameDefineProcessor_CompositeChangeName);
        IXtendXpandProject project = this.findXtendXpandProject();
        String selectedText = this.selection.getText();
        List references = XtendXpandSearchEngine.findAllOccurrences((IXtendXpandProject)project, (String)selectedText);
        HashMap<IFile, TextFileChange> fileChanges = new HashMap<IFile, TextFileChange>();
        for (SearchMatch match : references) {
            TextFileChange fileChange = null;
            if (fileChanges.containsKey(match.getFile())) {
                fileChange = (TextFileChange)fileChanges.get(match.getFile());
            } else {
                fileChange = new TextFileChange(Messages.RenameDefineProcessor_TextFileChangeName, match.getFile());
                MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
                fileChange.setEdit((TextEdit)fileChangeRootEdit);
                fileChanges.put(match.getFile(), fileChange);
                result.add((Change)fileChange);
            }
            ReplaceEdit replaceSelectionEdit = new ReplaceEdit(match.getOffSet() + 1, match.getLength(), this.newName);
            fileChange.addEdit((TextEdit)replaceSelectionEdit);
            TextEditGroup teg2 = new TextEditGroup(Messages.RenameDefineProcessor_GroupDescription);
            fileChange.addTextEditGroup(teg2);
            teg2.addTextEdit((TextEdit)replaceSelectionEdit);
        }
        return result;
    }

    public static boolean isLineDelimiterChar(char ch) {
        return ch == '\n' || ch == '\r';
    }

    public Object[] getElements() {
        return new Object[]{this.getSourceFile()};
    }

    public String getIdentifier() {
        return Messages.RenameDefineProcessor_ID;
    }

    public String getProcessorName() {
        return Messages.RenameDefineProcessor_ProcessorName;
    }

    public boolean isApplicable() throws CoreException {
        return true;
    }

    public boolean validateNewName() {
        return this.newName != null && !this.newName.trim().equals("") && !this.selection.getText().equals(this.newName);
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        return new RefactoringParticipant[0];
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public ITextSelection getSelection() {
        return this.selection;
    }
}

