/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jet.BufferedJET2Writer;
import org.eclipse.jet.IWriterListener;
import org.eclipse.jet.JET2Writer;
import org.eclipse.jet.internal.l10n.JET2Messages;
import org.eclipse.jet.internal.taglib.DocumentHelper;
import org.eclipse.jet.taglib.JET2TagException;
import org.eclipse.jet.taglib.TagInfo;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;

public class MarkerHelper
implements IWriterListener {
    private static final String TASKMARKER_ID = "org.eclipse.jet.taskmarker";
    private static final String MARKER_CATEGORY;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jet.taglib.MarkerHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        MARKER_CATEGORY = clazz.getName();
    }

    private MarkerHelper() {
    }

    public void finalizeContent(JET2Writer writer, Object file) throws JET2TagException {
    }

    public void postCommitContent(JET2Writer writer, Object file) throws JET2TagException {
        if (!(writer instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        BufferedJET2Writer bufferedWriter = (BufferedJET2Writer)writer;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IDocument document = (IDocument)bufferedWriter.getAdapter((Class)clazz);
        if (file instanceof IFile) {
            IFile iFile = (IFile)file;
            try {
                iFile.deleteMarkers(TASKMARKER_ID, false, 0);
                Position[] positions = document.getPositions(MARKER_CATEGORY);
                int i = 0;
                while (i < positions.length) {
                    String msg;
                    MarkerPosition markerPos = (MarkerPosition)positions[i];
                    IMarker marker = iFile.createMarker(TASKMARKER_ID);
                    int line = document.getLineOfOffset(markerPos.offset);
                    int start = markerPos.offset;
                    int end = markerPos.offset + markerPos.length;
                    if (start == end) {
                        IRegion lineInformation = document.getLineInformation(line);
                        start = lineInformation.getOffset();
                        end = start + lineInformation.getLength();
                    }
                    if ((msg = markerPos.description) == null || msg.length() == 0) {
                        msg = bufferedWriter.getContent(start, end - start);
                    }
                    marker.setAttribute("lineNumber", line);
                    marker.setAttribute("charStart", start);
                    marker.setAttribute("charEnd", end);
                    marker.setAttribute("message", (Object)msg);
                    ++i;
                }
            }
            catch (CoreException e) {
                String msg = JET2Messages.MarkerHelper_CouldNotCreateMarker;
                throw new JET2TagException(MessageFormat.format(msg, iFile.getFullPath().toString()), (Throwable)e);
            }
            catch (BadLocationException e) {
                throw new JET2TagException((Throwable)e);
            }
            catch (BadPositionCategoryException e) {
                throw new JET2TagException((Throwable)e);
            }
        }
    }

    public static void createMarkerOnWriter(JET2Writer writer, int start, int end, String description, TagInfo tagInfo, String templatePath) {
        if (!(writer instanceof BufferedJET2Writer)) {
            throw new IllegalArgumentException();
        }
        try {
            IDocument document;
            BufferedJET2Writer bufferedJET2Writer = (BufferedJET2Writer)writer;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jface.text.IDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((document = (IDocument)bufferedJET2Writer.getAdapter((Class)clazz)) == null) {
                throw new UnsupportedOperationException();
            }
            DocumentHelper.installPositionCategory(document, MARKER_CATEGORY);
            MarkerPosition markerPosition = new MarkerPosition(start, end - start, description, tagInfo, templatePath);
            document.addPosition(MARKER_CATEGORY, (Position)markerPosition);
            writer.addEventListener(MARKER_CATEGORY, (IWriterListener)new MarkerHelper());
        }
        catch (BadLocationException badLocationException) {
            throw new IllegalArgumentException();
        }
        catch (BadPositionCategoryException badPositionCategoryException) {
            throw new RuntimeException();
        }
    }

    private static final class MarkerPosition
    extends Position {
        public final String description;
        public final TagInfo tagInfo;
        public final String templatePath;

        public MarkerPosition(int start, int length, String description, TagInfo tagInfo, String templatePath) {
            super(start, length);
            this.description = description;
            this.tagInfo = tagInfo;
            this.templatePath = templatePath;
        }
    }
}

