/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.internal.core.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;

public class URLUtility {
    private URLUtility() {
    }

    public static URL jarEntryURL(URL jarFile, String unEncodedPath) {
        if (jarFile == null || unEncodedPath == null) {
            throw new NullPointerException();
        }
        try {
            return new URL(URLUtility.jarRootEntryURL(jarFile), unEncodedPath);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public static URL jarRootEntryURL(URL jarFile) {
        if (jarFile == null) {
            throw new NullPointerException();
        }
        try {
            return new URL("jar", null, String.valueOf(jarFile.toExternalForm()) + "!/");
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    public static URL toURL(URI uri) throws MalformedURLException {
        if (uri == null) {
            throw new NullPointerException();
        }
        return new URL(uri.getScheme(), uri.getHost(), uri.getPort(), uri.getPath());
    }

    public static URL relativeURL(URL baseLocation, String location) throws MalformedURLException {
        if (baseLocation == null || location == null) {
            throw new NullPointerException();
        }
        if ("platform".equals(baseLocation.getProtocol())) {
            String basePath = baseLocation.getPath();
            if (location.startsWith("/") && !basePath.endsWith("/")) {
                String firstSegment = basePath.substring(0, basePath.indexOf(47));
                URL adjustedBase = new URL(baseLocation.getProtocol(), null, firstSegment);
                return new URL(adjustedBase, location);
            }
        }
        return new URL(baseLocation, location);
    }
}

