/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jet.taglib;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TagInfo {
    private final Map attrMap;
    private final String tagName;
    private final boolean expression;
    protected final int line;
    protected final int col;

    public TagInfo(String tagName, int line, int col, String[] attrNames, String[] attrValues) {
        this.line = line;
        this.col = col;
        this.expression = tagName.startsWith("${");
        this.tagName = tagName;
        if (attrNames == null || attrValues == null) {
            throw new NullPointerException();
        }
        if (attrNames.length != attrValues.length) {
            throw new IllegalArgumentException();
        }
        this.attrMap = new LinkedHashMap(attrNames.length);
        int i = 0;
        while (i < attrNames.length) {
            this.attrMap.put(attrNames[i], attrValues[i]);
            ++i;
        }
    }

    public TagInfo(String tagName, int line, int start, int end, String[] attrNames, String[] attrValues) {
        this(tagName, line, 1, attrNames, attrValues);
    }

    public final String getAttribute(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return (String)this.attrMap.get(name);
    }

    public final boolean hasAttribute(String name) {
        return this.attrMap.containsKey(name);
    }

    public String toString() {
        return "[" + this.line + ":" + this.col + " " + this.tagName + " " + this.attrMap + "]";
    }

    public final String getTagName() {
        return this.tagName;
    }

    public final String[] getAttributeNames() {
        return this.attrMap.keySet().toArray(new String[this.attrMap.size()]);
    }

    public final String displayString() {
        if (this.expression) {
            return this.tagName;
        }
        StringBuffer displayString = new StringBuffer();
        displayString.append('<').append(this.tagName);
        Iterator i = this.attrMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            displayString.append(' ').append((String)entry.getKey()).append('=').append('\'').append(((String)entry.getValue()).replaceAll("'", "''")).append('\'');
        }
        displayString.append('>');
        return displayString.toString();
    }

    public final int getCol() {
        return this.col;
    }

    public final int getLine() {
        return this.line;
    }
}

