/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.newfile;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AbstractAcceleoNewTemplatesMasterComposite;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesDetailsComposite;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardController;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.AcceleoNewTemplatesWizardPage;
import org.eclipse.acceleo.internal.ide.ui.wizards.newfile.CreateTemplateData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AcceleoNewTemplatesGlobalController {
    protected List<AcceleoNewTemplatesWizardController> controllers = new ArrayList<AcceleoNewTemplatesWizardController>(10);
    protected AcceleoNewTemplatesWizardController currentController;
    protected AbstractAcceleoNewTemplatesMasterComposite viewMasterComposite;
    protected AcceleoNewTemplatesDetailsComposite viewDetailsComposite;
    private AcceleoNewTemplatesWizardPage page;
    private String selectedContainer = "";

    public List<AcceleoNewTemplatesWizardController> getControllers() {
        return this.controllers;
    }

    public void setWizardPage(AcceleoNewTemplatesWizardPage newTemplateWizardPage) {
        this.page = newTemplateWizardPage;
    }

    public void setSelectedContainer(String selectedContainer) {
        this.selectedContainer = selectedContainer;
        this.viewDetailsComposite.setContainer(selectedContainer);
    }

    public void createView(Composite parent, boolean showTemplates) {
        if (this.viewMasterComposite == null) {
            this.viewMasterComposite = new AcceleoNewTemplatesMasterComposite(parent, this, showTemplates);
            this.viewMasterComposite.addController(null);
            this.viewMasterComposite.getTreeViewer().refresh();
        }
    }

    public Composite getView() {
        return this.viewMasterComposite;
    }

    protected void addNewTemplate(CreateTemplateData other) {
        CreateTemplateData templateData = other == null ? this.initializeTemplateData() : this.copyTemplateData(other);
        AcceleoNewTemplatesWizardController controller = new AcceleoNewTemplatesWizardController(templateData);
        controller.setGlobalController(this);
        if (this.currentController == null || controller.getClass() != this.currentController.getClass()) {
            controller.createView(this.viewMasterComposite);
            if (controller.getView() instanceof AcceleoNewTemplatesDetailsComposite) {
                this.viewDetailsComposite = (AcceleoNewTemplatesDetailsComposite)controller.getView();
            }
            this.viewMasterComposite.pack();
        } else {
            controller.setViewDetailsComposite(this.viewDetailsComposite);
            controller.setViewMasterComposite(this.viewMasterComposite);
        }
        this.viewDetailsComposite.setController(controller);
        this.viewDetailsComposite.setContainer(this.selectedContainer);
        this.viewDetailsComposite.initializeContainer();
        this.controllers.add(controller);
        this.currentController = controller;
        this.viewMasterComposite.getTreeViewer().refresh();
        this.viewMasterComposite.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)controller));
    }

    private CreateTemplateData initializeTemplateData() {
        CreateTemplateData data = new CreateTemplateData();
        if (this.controllers.size() == 0) {
            data.setTemplateShortName("generate");
        } else {
            data.setTemplateShortName("generate" + (this.controllers.size() + 1));
        }
        data.setTemplateMetamodel("http://www.eclipse.org/uml2/2.1.0/UML");
        data.setTemplateFileType("Class");
        data.setTemplateHasFileBlock(true);
        data.setTemplateIsMain(true);
        return data;
    }

    private CreateTemplateData copyTemplateData(CreateTemplateData other) {
        CreateTemplateData data = new CreateTemplateData();
        data.setTemplateContainer(other.getTemplateContainer());
        data.setTemplateShortName(String.valueOf(other.getTemplateShortName()) + "Copy");
        data.setTemplateMetamodel(other.getTemplateMetamodel());
        data.setTemplateFileType(other.getTemplateFileType());
        data.setTemplateHasFileBlock(other.getTemplateHasFileBlock());
        data.setTemplateIsMain(other.getTemplateIsMain());
        data.setTemplateIsInitialized(other.getTemplateIsInitialized());
        data.setTemplateExampleStrategy(other.getTemplateExampleStrategy());
        return data;
    }

    public void updateStatus(String message) {
        this.page.setErrorMessage(message);
        this.page.setPageComplete(message == null);
    }

    private class AcceleoNewTemplatesMasterComposite
    extends AbstractAcceleoNewTemplatesMasterComposite {
        public AcceleoNewTemplatesMasterComposite(Composite parent, AcceleoNewTemplatesGlobalController controller, boolean showTemplates) {
            super(parent, controller, showTemplates);
        }

        public void addController(ISelection selection) {
            CreateTemplateData data;
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof AcceleoNewTemplatesWizardController) {
                AcceleoNewTemplatesWizardController controller = (AcceleoNewTemplatesWizardController)((IStructuredSelection)selection).getFirstElement();
                data = controller.getModel();
            } else {
                data = null;
            }
            AcceleoNewTemplatesGlobalController.this.addNewTemplate(data);
        }

        public void removeController(ISelection selection) {
            if (selection instanceof StructuredSelection) {
                AcceleoNewTemplatesGlobalController.this.controllers.removeAll(((StructuredSelection)selection).toList());
            }
        }

        protected void acceleoSelectionChanged(ISelection selection) {
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof AcceleoNewTemplatesWizardController) {
                AcceleoNewTemplatesGlobalController.this.currentController = (AcceleoNewTemplatesWizardController)((IStructuredSelection)selection).getFirstElement();
                AcceleoNewTemplatesGlobalController.this.currentController.setViewDetailsComposite(AcceleoNewTemplatesGlobalController.this.viewDetailsComposite);
                AcceleoNewTemplatesGlobalController.this.currentController.setViewMasterComposite(AcceleoNewTemplatesGlobalController.this.viewMasterComposite);
                AcceleoNewTemplatesGlobalController.this.viewDetailsComposite.setController(AcceleoNewTemplatesGlobalController.this.currentController);
                AcceleoNewTemplatesGlobalController.this.currentController.initView();
            }
        }
    }
}

