/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.Bag;
import org.eclipse.m2m.atl.engine.emfvm.lib.EnumLiteral;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclParametrizedType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclSimpleType;
import org.eclipse.m2m.atl.engine.emfvm.lib.OclUndefined;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLink;
import org.eclipse.m2m.atl.engine.emfvm.lib.TransientLinkSet;
import org.eclipse.m2m.atl.engine.emfvm.lib.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OclType {
    private static final OclType OCL_ANY = new OclSimpleType("OclAny");
    private static final OclType SEQUENCE = new OclParametrizedType("Sequence", OCL_ANY);
    private static final OclType SET = new OclParametrizedType("Set", OCL_ANY);
    private static final OclType BAG = new OclParametrizedType("Bag", OCL_ANY);
    private static Map<Class<?>, OclType> oclTypes = new HashMap();
    private static Map<String, Class<?>> nativeClasses;
    private static Map<Class<?>, List<Class<?>>> supertypes;
    private String name;

    static {
        oclTypes.put(Collection.class, new OclParametrizedType("Collection", OCL_ANY));
        oclTypes.put(ArrayList.class, SEQUENCE);
        oclTypes.put(HashSet.class, SET);
        oclTypes.put(LinkedHashSet.class, new OclParametrizedType("OrderedSet", OCL_ANY));
        oclTypes.put(Bag.class, BAG);
        oclTypes.put(Tuple.class, new OclSimpleType("Tuple"));
        oclTypes.put(EnumLiteral.class, new OclSimpleType("EnumLiteral"));
        oclTypes.put(TransientLinkSet.class, new OclSimpleType("TransientLinkSet"));
        oclTypes.put(TransientLink.class, new OclSimpleType("TransientLink"));
        oclTypes.put(HashMap.class, new OclSimpleType("Map"));
        oclTypes.put(String.class, new OclSimpleType("String"));
        oclTypes.put(Integer.class, new OclSimpleType("Integer"));
        oclTypes.put(Object.class, OCL_ANY);
        oclTypes.put(Boolean.class, new OclSimpleType("Boolean"));
        oclTypes.put(Double.class, new OclSimpleType("Real"));
        oclTypes.put(ASMModule.class, new OclSimpleType("Module"));
        oclTypes.put(OclSimpleType.class, new OclSimpleType("OclSimpleType"));
        oclTypes.put(OclParametrizedType.class, new OclSimpleType("OclParametrizedType"));
        nativeClasses = new HashMap();
        nativeClasses.put("Collection", Collection.class);
        nativeClasses.put("Sequence", ArrayList.class);
        nativeClasses.put("Set", HashSet.class);
        nativeClasses.put("Bag", Bag.class);
        nativeClasses.put("OrderedSet", LinkedHashSet.class);
        nativeClasses.put("Tuple", Tuple.class);
        nativeClasses.put("EnumLiteral", EnumLiteral.class);
        nativeClasses.put("OclSimpleType", OclSimpleType.class);
        nativeClasses.put("OclParametrizedType", OclParametrizedType.class);
        nativeClasses.put("TransientLinkSet", TransientLinkSet.class);
        nativeClasses.put("TransientLink", TransientLink.class);
        nativeClasses.put("Map", HashMap.class);
        nativeClasses.put("Module", ASMModule.class);
        nativeClasses.put("String", String.class);
        nativeClasses.put("Integer", Integer.class);
        nativeClasses.put("OclAny", Object.class);
        nativeClasses.put("Boolean", Boolean.class);
        nativeClasses.put("Real", Double.class);
        supertypes = new HashMap();
        supertypes.put(Integer.class, Arrays.asList(Double.class));
        supertypes.put(Boolean.class, Arrays.asList(Object.class));
        supertypes.put(String.class, Arrays.asList(Object.class));
        supertypes.put(Bag.class, Arrays.asList(Collection.class));
        supertypes.put(ArrayList.class, Arrays.asList(Collection.class));
        supertypes.put(LinkedHashSet.class, Arrays.asList(Collection.class));
        supertypes.put(HashSet.class, Arrays.asList(Collection.class));
        supertypes.put(Collection.class, Arrays.asList(Object.class));
        supertypes.put(Double.class, Arrays.asList(Object.class));
        supertypes.put(OclParametrizedType.class, Arrays.asList(OclType.class));
        supertypes.put(OclSimpleType.class, Arrays.asList(OclType.class));
        supertypes.put(OclUndefined.class, Arrays.asList(Object.class));
        supertypes.put(TransientLink.class, Arrays.asList(Object.class));
        supertypes.put(HashMap.class, Arrays.asList(Object.class));
        supertypes.put(ASMModule.class, Arrays.asList(Object.class));
        supertypes.put(Tuple.class, Arrays.asList(Object.class));
        supertypes.put(EnumLiteral.class, Arrays.asList(Object.class));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.name == null ? "<unnamed>" : this.name;
    }

    public abstract boolean conformsTo(OclType var1);

    public static Map<Class<?>, List<Class<?>>> getSupertypes() {
        return supertypes;
    }

    public static OclType getOclTypeFromObject(Object cl) {
        OclType res = null;
        if (cl instanceof Collection) {
            if (cl instanceof List) {
                return SEQUENCE;
            }
            if (cl instanceof Set) {
                return SET;
            }
            return BAG;
        }
        res = oclTypes.get(cl.getClass());
        if (res == null) {
            res = OCL_ANY;
        }
        return res;
    }

    public static Class<? extends Object> getNativeClassfromOclTypeName(String typeName) {
        return nativeClasses.get(typeName);
    }

    public static void addSimpleType(String typeName, Class<?> typeClass) {
        oclTypes.put(typeClass, new OclSimpleType(typeName));
        nativeClasses.put(typeName, typeClass);
        supertypes.put(typeClass, Arrays.asList(Object.class));
    }
}

