/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;
import org.eclipse.gmf.internal.validate.expressions.IParseEnvironment;

public abstract class ExpressionCache {
    private Map<String, Object> body2Entries = new HashMap<String, Object>();

    protected ExpressionCache() {
    }

    protected abstract IModelExpression createExpressionEntry(String var1, EClassifier var2, IParseEnvironment var3);

    public IModelExpression getExpression(String body, EClassifier context) {
        return this.getExpression(body, context, null);
    }

    public IModelExpression getExpression(String body, EClassifier context, IParseEnvironment env) {
        if (body == null || context == null) {
            throw new IllegalArgumentException("Null expression body or context");
        }
        IModelExpression resultEntry = null;
        if (this.body2Entries.containsKey(body)) {
            List cachedEntries;
            AbstractExpression prevEntry;
            Object prev = this.body2Entries.get(body);
            if (prev instanceof AbstractExpression && (prevEntry = (AbstractExpression)prev).getContext() == context) {
                return prevEntry;
            }
            List list = cachedEntries = prev instanceof List ? (List)prev : new LinkedList();
            if (cachedEntries.isEmpty()) {
                cachedEntries.add(prev);
                this.body2Entries.put(body, cachedEntries);
            } else {
                for (AbstractExpression nextConstraint : cachedEntries) {
                    if (nextConstraint.getContext() != context) continue;
                    return nextConstraint;
                }
            }
            resultEntry = this.createExpressionEntry(body, context, env);
            cachedEntries.add(resultEntry);
            assert (resultEntry != null);
            return resultEntry;
        }
        resultEntry = this.createExpressionEntry(body, context, env);
        this.body2Entries.put(body, resultEntry);
        return resultEntry;
    }
}

