/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class ImageConverter {
    private static final PaletteData PALETTE_DATA = new PaletteData(0xFF0000, 65280, 255);

    public static Image convert(BufferedImage srcImage) {
        ImageData swtImageData = new ImageData(srcImage.getWidth(), srcImage.getHeight(), 24, PALETTE_DATA);
        int scansize = (srcImage.getWidth() * 3 + 3) * 4 / 4;
        WritableRaster alphaRaster = srcImage.getAlphaRaster();
        byte[] alphaBytes = new byte[srcImage.getWidth()];
        int y = 0;
        while (y < srcImage.getHeight()) {
            int[] buff = srcImage.getRGB(0, y, srcImage.getWidth(), 1, null, 0, scansize);
            swtImageData.setPixels(0, y, srcImage.getWidth(), buff, 0);
            if (alphaRaster != null) {
                int[] alpha = alphaRaster.getPixels(0, y, srcImage.getWidth(), 1, (int[])null);
                int i = 0;
                while (i < srcImage.getWidth()) {
                    alphaBytes[i] = (byte)alpha[i];
                    ++i;
                }
                swtImageData.setAlphas(0, y, srcImage.getWidth(), alphaBytes, 0);
            }
            ++y;
        }
        return new Image((Device)PlatformUI.getWorkbench().getDisplay(), swtImageData);
    }

    public static BufferedImage convert(Image srcImage) {
        ImageData imageData = srcImage.getImageData();
        int width = imageData.width;
        int height = imageData.height;
        ImageData maskData = null;
        int[] alpha = new int[1];
        if (imageData.alphaData == null) {
            maskData = imageData.getTransparencyMask();
        }
        BufferedImage image = new BufferedImage(imageData.width, imageData.height, 2);
        WritableRaster alphaRaster = image.getAlphaRaster();
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                RGB color = imageData.palette.getRGB(imageData.getPixel(x, y));
                image.setRGB(x, y, new Color(color.red, color.green, color.blue).getRGB());
                if (alphaRaster != null) {
                    if (imageData.alphaData != null) {
                        alpha[0] = imageData.getAlpha(x, y);
                        alphaRaster.setPixel(x, y, alpha);
                    } else if (maskData != null) {
                        alpha[0] = maskData.getPixel(x, y) == 0 ? 0 : 255;
                        alphaRaster.setPixel(x, y, alpha);
                    }
                }
                ++x;
            }
            ++y;
        }
        return image;
    }
}

