/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.graphdef.codegen.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.graphdef.codegen.StandaloneGenerator;
import org.eclipse.gmf.internal.graphdef.codegen.CanvasProcessor;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryMirrorProcessor;
import org.eclipse.gmf.internal.graphdef.codegen.GalleryProcessor;
import org.eclipse.gmf.internal.graphdef.codegen.ui.ConverterOptions;

class ConverterOutcome {
    private final ConverterOptions myOptions;
    private StandaloneGenerator.Processor myProcessor;
    private final Resource[] myInput;

    public ConverterOutcome(ConverterOptions options, Resource[] input) {
        this.myOptions = options;
        this.myInput = input;
    }

    public IStatus checkInputAgainstOptions() {
        FigureGallery[] figures;
        if (this.myOptions.needMirroredCanvas) {
            Canvas[] c = ConverterOutcome.findCanvases(this.myInput);
            if (c.length == 0) {
                return ConverterOutcome.newError("Need canvas instance", null);
            }
            if (c.length > 1) {
                return ConverterOutcome.newError("Need exactly one canvas instance", null);
            }
        } else if (this.myOptions.needMirroredGalleries && (figures = ConverterOutcome.findFigures(this.myInput)).length == 0) {
            return ConverterOutcome.newError("Need at least one figure gallery", null);
        }
        return Status.OK_STATUS;
    }

    public StandaloneGenerator.Processor getProcessor() {
        if (this.myProcessor == null) {
            this.myProcessor = this.createProcessor();
        }
        return this.myProcessor;
    }

    private StandaloneGenerator.Processor createProcessor() {
        if (this.myOptions.needMirroredCanvas) {
            return new CanvasProcessor(this.inputAsCanvas());
        }
        if (this.myOptions.needMirroredGalleries) {
            return new GalleryMirrorProcessor(this.inputAsGalleries());
        }
        return new GalleryProcessor(this.inputAsGalleries());
    }

    private FigureGallery[] inputAsGalleries() {
        return ConverterOutcome.findFigures(this.myInput);
    }

    private Canvas inputAsCanvas() {
        return ConverterOutcome.findCanvases(this.myInput)[0];
    }

    public IStatus createResources(ResourceSet rs, URI galleryResourceURI, URI mirroredCanvasURI) {
        assert (rs != null && galleryResourceURI != null && mirroredCanvasURI != null);
        Resource canvasResource = null;
        Resource galleryResource = null;
        if (this.myOptions.needMirroredCanvas) {
            Canvas mirror = ((CanvasProcessor)this.getProcessor()).getOutcome();
            canvasResource = rs.createResource(mirroredCanvasURI, "");
            canvasResource.getContents().add((Object)mirror);
            if (this.myOptions.needMirroredGalleries && this.myOptions.separateMirrorFiles) {
                galleryResource = rs.createResource(galleryResourceURI, "");
                galleryResource.getContents().addAll((Collection)mirror.getFigures());
            }
        } else if (this.myOptions.needMirroredGalleries) {
            galleryResource = rs.createResource(galleryResourceURI, "");
            GalleryMirrorProcessor processor = (GalleryMirrorProcessor)this.getProcessor();
            galleryResource.getContents().add((Object)processor.convertFigureGallery());
        }
        try {
            if (galleryResource != null) {
                galleryResource.save(null);
            }
            if (canvasResource != null) {
                canvasResource.save(null);
            }
        }
        catch (IOException ex) {
            return ConverterOutcome.newError(ex.getMessage(), ex);
        }
        return Status.OK_STATUS;
    }

    private static Status newError(String message, Exception ex) {
        return new Status(4, "org.eclipse.gmf.graphdef.codegen.ui", 0, message, (Throwable)ex);
    }

    private static FigureGallery[] findFigures(Resource[] resources) {
        ArrayList<FigureGallery> rv = new ArrayList<FigureGallery>();
        int i = 0;
        while (i < resources.length) {
            TreeIterator it = resources[i].getAllContents();
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (next.eClass().getClassifierID() == 1) {
                    rv.add((FigureGallery)next);
                    it.prune();
                    continue;
                }
                if (next.eClass().getClassifierID() == 0) continue;
                it.prune();
            }
            ++i;
        }
        return rv.toArray(new FigureGallery[rv.size()]);
    }

    private static Canvas[] findCanvases(Resource[] resources) {
        ArrayList<Canvas> rv = new ArrayList<Canvas>();
        int i = 0;
        while (i < resources.length) {
            for (EObject next : resources[i].getContents()) {
                if (next.eClass().getClassifierID() != 0) continue;
                rv.add((Canvas)next);
            }
            ++i;
        }
        return rv.toArray(new Canvas[rv.size()]);
    }
}

