/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.validate;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.gmf.internal.validate.GMFValidationPlugin;
import org.eclipse.gmf.internal.validate.Messages;
import org.eclipse.gmf.internal.validate.StatusCodes;
import org.eclipse.gmf.internal.validate.expressions.AbstractExpression;
import org.eclipse.gmf.internal.validate.expressions.IEvaluationEnvironment;
import org.eclipse.gmf.internal.validate.expressions.IModelExpression;

public class ConstraintAdapter
extends AbstractExpression {
    private IModelExpression expression;
    private EClassifier resultType;
    private int severity;
    private String description;

    public ConstraintAdapter(IModelExpression expression, int severity, String description) {
        super(expression.getBody(), expression.getContext(), null);
        this.expression = expression;
        this.severity = severity;
        this.description = description;
        if (this.getStatus().isOK()) {
            this.resultType = expression.getResultType();
            if (this.resultType != null && !expression.isLooselyTyped() && !this.resultType.isInstance((Object)Boolean.TRUE)) {
                String msg = MessageFormat.format(Messages.invalidConstraintExprType, this.resultType.getName(), this.getBody());
                this.setStatus((IStatus)new Status(4, GMFValidationPlugin.getPluginId(), StatusCodes.INVALID_EXPRESSION_TYPE, msg, null));
            }
        }
    }

    public int getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public IStatus getStatus() {
        if (this.expression.getStatus().isOK()) {
            return super.getStatus();
        }
        return this.expression.getStatus();
    }

    public String getLanguage() {
        return this.expression.getLanguage();
    }

    public boolean isLooselyTyped() {
        return this.expression.isLooselyTyped();
    }

    public boolean isAssignableToElement(ETypedElement typedElement) {
        return this.expression.isAssignableToElement(typedElement);
    }

    public boolean isAssignableTo(EClassifier ecoreType) {
        return this.expression.isAssignableTo(ecoreType);
    }

    public EClassifier getResultType() {
        return this.resultType;
    }

    protected Object doEvaluate(Object context) {
        return this.expression.evaluate(context);
    }

    protected Object doEvaluate(Object context, IEvaluationEnvironment extEnvironment) {
        return this.expression.evaluate(context, extEnvironment);
    }

    public boolean isSatisfied(EObject context) {
        Object value = this.evaluate(context);
        return value instanceof Boolean ? (Boolean)value : false;
    }
}

