/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.lite.gen;

import java.lang.reflect.Field;
import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.internal.codegen.lite.Generator;
import org.eclipse.gmf.internal.common.codegen.GeneratorBase;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.lite.commands.WrappingCommand;
import org.eclipse.gmf.runtime.lite.edit.parts.update.TransactionalUpdateManager;
import org.eclipse.gmf.runtime.lite.requests.CreateConnectionRequestEx;
import org.eclipse.gmf.runtime.lite.requests.CreateRequestEx;
import org.eclipse.gmf.runtime.lite.requests.ModelCreationFactory;
import org.eclipse.gmf.runtime.lite.services.IViewDecorator;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tests.setup.AbstractGeneratorConfiguration;
import org.eclipse.gmf.tests.setup.GeneratorConfiguration;
import org.eclipse.gmf.tests.setup.SessionSetup;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class LiteGeneratorConfiguration
extends AbstractGeneratorConfiguration {
    public GeneratorBase createGenerator(GenDiagram diagram) {
        return new Generator(diagram.getEditorGen());
    }

    public GeneratorConfiguration.ViewerConfiguration createViewerConfiguration(SessionSetup sessionSetup, EditPartViewer viewer) throws Exception {
        return new LiteViewerConfiguration(sessionSetup, viewer);
    }

    protected EditPartViewer createViewerInstance() {
        return new FakeLiteViewer();
    }

    public Diagram createDiagram(EObject domainElement, SessionSetup sessionSetup) throws Exception {
        Diagram result = NotationFactory.eINSTANCE.createDiagram();
        result.setElement(domainElement);
        String diagramDecoratorClass = sessionSetup.getGenModel().getGenDiagram().getNotationViewFactoryQualifiedClassName();
        Class pluginClass = sessionSetup.getGenProject().getBundle().loadClass(diagramDecoratorClass);
        Field field = pluginClass.getField("INSTANCE");
        IViewDecorator decorator = (IViewDecorator)field.get(null);
        decorator.decorateView((View)result);
        return result;
    }

    private static class FakeLiteViewer
    extends AbstractGeneratorConfiguration.AbstractFakeViewer {
        private FakeLiteViewer() {
        }

        public Control createControl(Composite composite) {
            Control result = super.createControl(composite);
            final TransactionalUpdateManager updateManager = new TransactionalUpdateManager((EditPartViewer)this);
            this.setProperty(TransactionalUpdateManager.class.getName(), updateManager);
            result.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    updateManager.dispose();
                }
            });
            return result;
        }
    }

    private static class LiteViewerConfiguration
    extends AbstractGeneratorConfiguration.AbstractViewerConfiguration {
        private IPreferenceStore myPreferenceStore;

        public LiteViewerConfiguration(SessionSetup sessionSetup, EditPartViewer viewer) throws Exception {
            super(sessionSetup, viewer);
        }

        public org.eclipse.gef.commands.Command getCreateNodeCommand(View parentView, GenCommonBase nodeType) {
            CreateRequestEx req = new CreateRequestEx(nodeType.getDiagram().getEditorGen().getModelID(), new int[]{nodeType.getVisualID()});
            req.setLocation(new Point(0, 0));
            req.setSize(new Dimension(100, 100));
            ModelCreationFactory factory = new ModelCreationFactory(Node.class);
            req.setFactory((CreationFactory)factory);
            return this.findEditPart(parentView).getCommand((Request)req);
        }

        public org.eclipse.gef.commands.Command getCreateLinkCommand(View source, View target, GenCommonBase linkType) {
            CreateConnectionRequestEx req = new CreateConnectionRequestEx(linkType.getDiagram().getEditorGen().getModelID(), new int[]{linkType.getVisualID()});
            req.setType((Object)"connection end");
            EditPart sourceEditPart = this.findEditPart(source);
            Assert.assertNotNull((Object)sourceEditPart);
            req.setSourceEditPart(sourceEditPart);
            EditPart targetEditPart = this.findEditPart(target);
            Assert.assertNotNull((Object)targetEditPart);
            req.setTargetEditPart(targetEditPart);
            req.setStartCommand(this.getStartLinkCommand(source, linkType));
            return targetEditPart.getCommand((Request)req);
        }

        public org.eclipse.gef.commands.Command getStartLinkCommand(View source, GenCommonBase linkType) {
            CreateConnectionRequestEx req = new CreateConnectionRequestEx(linkType.getDiagram().getEditorGen().getModelID(), new int[]{linkType.getVisualID()});
            req.setType((Object)"connection start");
            EditPart sourceEditPart = this.findEditPart(source);
            Assert.assertNotNull((Object)sourceEditPart);
            req.setTargetEditPart(sourceEditPart);
            return sourceEditPart.getCommand((Request)req);
        }

        public org.eclipse.gef.commands.Command getSetBusinessElementStructuralFeatureCommand(View view, String featureName, final Object value) {
            final EObject instance = view.getElement();
            Assert.assertNotNull((String)"No business element bound to notation element", (Object)instance);
            final EStructuralFeature feature = instance.eClass().getEStructuralFeature(featureName);
            if (feature == null) {
                throw new IllegalArgumentException("Not existing feature: " + featureName);
            }
            TransactionalEditingDomain txEditDomain = this.getEditDomain(instance);
            return new WrappingCommand(txEditDomain, (Command)new AbstractCommand(){
                private Object oldValue;
                private boolean wasSet;

                public boolean canExecute() {
                    return true;
                }

                public boolean canUndo() {
                    return true;
                }

                public void undo() {
                    if (!this.wasSet) {
                        instance.eUnset(feature);
                        return;
                    }
                    if (FeatureMapUtil.isMany((EObject)instance, (EStructuralFeature)feature)) {
                        Collection coll = (Collection)instance.eGet(feature);
                        coll.remove(value);
                    } else {
                        instance.eSet(feature, this.oldValue);
                    }
                }

                public void redo() {
                    this.execute();
                }

                public void execute() {
                    this.wasSet = instance.eIsSet(feature);
                    if (FeatureMapUtil.isMany((EObject)instance, (EStructuralFeature)feature)) {
                        Collection coll = (Collection)instance.eGet(feature);
                        coll.add(value);
                    } else {
                        this.oldValue = instance.eGet(feature);
                        instance.eSet(feature, value);
                    }
                }
            });
        }

        public org.eclipse.gef.commands.Command getSetNotationalElementStructuralFeature(final View view, final EStructuralFeature feature, final Object value) {
            TransactionalEditingDomain txEditDomain = this.getEditDomain((EObject)view);
            return new WrappingCommand(txEditDomain, (Command)new AbstractCommand(){
                private Object oldValue;

                public boolean canExecute() {
                    return true;
                }

                public boolean canUndo() {
                    return true;
                }

                public void undo() {
                    ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)feature, (Object)this.oldValue);
                }

                public void redo() {
                    this.execute();
                }

                public void execute() {
                    this.oldValue = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)feature);
                    ViewUtil.setStructuralFeatureValue((View)view, (EStructuralFeature)feature, (Object)value);
                }
            });
        }

        public RGB getDefaultLinkColor() {
            return PreferenceConverter.getColor((IPreferenceStore)this.getDefaultPreferences(), (String)"Appearance.lineColor");
        }

        protected IPreferenceStore getDefaultPreferences() {
            if (this.myPreferenceStore == null) {
                try {
                    Class activatorClazz = this.loadGeneratedClass(this.getGenModel().getGenDiagram().getEditorGen().getPlugin().getActivatorQualifiedClassName());
                    AbstractUIPlugin pluginInstance = (AbstractUIPlugin)activatorClazz.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
                    this.myPreferenceStore = pluginInstance.getPreferenceStore();
                }
                catch (Throwable throwable) {
                    Assert.fail((String)"Failed to obtain default preferences");
                }
            }
            return this.myPreferenceStore;
        }

        protected TransactionalEditingDomain getEditDomain(EditPart editPart) {
            return TransactionUtil.getEditingDomain((Object)editPart.getModel());
        }

        protected TransactionalEditingDomain getEditDomain(EObject object) {
            return TransactionUtil.getEditingDomain((EObject)object);
        }
    }
}

