/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.tr;

import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.eclipse.gmf.internal.common.codegen.PluginXMLTextMerger;

public class PluginXMLTextMergerTest
extends TestCase {
    private static final String NL = System.getProperties().getProperty("line.separator");
    private static final String PI_TARGET_GMFGEN = "gmfgen";
    private static final String PI_DATA_GENERATED = "generated";
    private static final String PI_GENERATED_VALUE = "true";
    private static final String PI = MessageFormat.format("      <?{0} {1}=\"{2}\"?>", "gmfgen", "generated", "true");
    private static final String T_00 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + NL;
    private static final String T_01 = "<?eclipse version=\"3.0\"?>" + NL + NL;
    private static final String T_02 = "<plugin>" + NL + NL;
    private static final String T_10 = "   <extension point=\"org.eclipse.core.runtime.preferences\">" + NL;
    private static final String T_11 = String.valueOf(PI) + NL;
    private static final String T_12 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer\"/>" + NL;
    private static final String T_13 = "   </extension>" + NL + NL;
    private static final String T_20 = "   <extension point=\"org.eclipse.core.runtime.preferences\">" + NL;
    private static final String T_21 = String.valueOf(PI) + NL;
    private static final String T_22 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer2\"/>" + NL;
    private static final String T_23 = "   </extension>" + NL + NL;
    private static final String T_30 = "   <extension point=\"org.eclipse.core.runtime.preferences\">" + NL;
    private static final String T_31 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer3\"/>" + NL;
    private static final String T_32 = "   </extension>" + NL + NL;
    private static final String T_33 = "   <extension point='org.eclipse.core.runtime.preferences'>" + NL;
    private static final String T_34 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer3\"/>" + NL;
    private static final String T_35 = "   </extension>" + NL + NL;
    private static final String T_36 = "   <extension point = \"org.eclipse.core.runtime.preferences\">" + NL;
    private static final String T_37 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer3\"/>" + NL;
    private static final String T_38 = "   </extension>" + NL + NL;
    private static final String T_40 = "   <extension" + NL;
    private static final String T_41 = "         point=\"org.eclipse.ui.views\">" + NL;
    private static final String T_42 = "      <category" + NL;
    private static final String T_43 = "            id=\"org.eclipse.gmf.examples.mindmap.diagram.categoryMindmap\"" + NL;
    private static final String T_44 = "            name=\"%diagram.category.mindmap\"/>" + NL;
    private static final String T_45 = "   </extension>" + NL + NL;
    private static final String T_50 = "   <extension point=\"org.eclipse.gmf.runtime.common.ui.services.properties.propertiesProviders\">" + NL;
    private static final String T_51 = String.valueOf(PI) + NL;
    private static final String T_52 = "      <PropertiesProvider" + NL;
    private static final String T_53 = "            verifyPluginLoaded=\"false\"" + NL;
    private static final String T_54 = "            class=\"org.example.mindmap.diagram.providers.MindmapPropertyProvider\">" + NL;
    private static final String T_55 = "         <Priority name=\"Lowest\"/>" + NL;
    private static final String T_56 = "      </PropertiesProvider>" + NL;
    private static final String T_57 = "   </extension>" + NL + NL;
    private static final String T_60 = "   <extension point=\"org.eclipse.gmf.runtime.common.ui.services.parserProviders\">" + NL;
    private static final String T_61 = String.valueOf(PI) + NL;
    private static final String T_62 = "      <ParserProvider class=\"org.example.mindmap.diagram.providers.MindmapParserProvider\">" + NL;
    private static final String T_63 = "         <Priority name=\"Lowest\"/>" + NL;
    private static final String T_64 = "      </ParserProvider>" + NL;
    private static final String T_65 = "   </extension>" + NL + NL;
    private static final String T_70 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String T_71 = "<?eclipse version=\"3.0\"?>";
    private static final String T_72 = "<plugin>";
    private static final String T_73 = "   <extension point=\"org.eclipse.core.runtime.preferences\">";
    private static final String T_74 = PI;
    private static final String T_75 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer\"/>";
    private static final String T_76 = "   </extension>";
    private static final String T_77 = "   <extension point=\"org.eclipse.core.runtime.preferences\">";
    private static final String T_78 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer3\"/>";
    private static final String T_79 = "   </extension>";
    private static final String T_80 = "   <extension point=\"org.eclipse.gmf.runtime.common.ui.services.parserProviders\">" + NL;
    private static final String T_81 = "      <!-- " + PI + " -->" + NL;
    private static final String T_82 = "   <!--<extension point=\"org.eclipse.core.runtime.preferences\">" + NL;
    private static final String T_83 = "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer3\"/>" + NL;
    private static final String T_84 = "   </extension>-->" + NL + NL;
    private static final String T_85 = "      <ParserProvider class=\"org.example.mindmap.diagram.providers.MindmapParserProvider\">" + NL;
    private static final String T_86 = "         <Priority name=\"Lowest\"/>" + NL;
    private static final String T_87 = "      </ParserProvider>" + NL;
    private static final String T_88 = "   </extension>" + NL + NL;
    private static final String T_99 = "</plugin>";
    private static final String T_0 = String.valueOf(T_00) + T_01 + T_02;
    private static final String T_1 = String.valueOf(T_10) + T_11 + T_12 + T_13;
    private static final String T_2 = String.valueOf(T_20) + T_21 + T_22 + T_23;
    private static final String T_3 = String.valueOf(T_30) + T_31 + T_32;
    private static final String T_3_A = String.valueOf(T_33) + T_34 + T_35;
    private static final String T_3_S = String.valueOf(T_36) + T_37 + T_38;
    private static final String T_4 = String.valueOf(T_40) + T_41 + T_42 + T_43 + T_44 + T_45;
    private static final String T_5 = String.valueOf(T_50) + T_51 + T_52 + T_53 + T_54 + T_55 + T_56 + T_57;
    private static final String T_6 = String.valueOf(T_60) + T_61 + T_62 + T_63 + T_64 + T_65;
    private static final String T_7 = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?eclipse version=\"3.0\"?><plugin>   <extension point=\"org.eclipse.core.runtime.preferences\">" + T_74 + "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer\"/>" + "   </extension>" + "   <extension point=\"org.eclipse.core.runtime.preferences\">" + "      <initializer class=\"org.example.mindmap.diagram.part.MindmapDiagramPreferenceInitializer3\"/>" + "   </extension>";
    private static final String T_8 = String.valueOf(T_80) + T_81 + T_82 + T_83 + T_84 + T_85 + T_86 + T_87 + T_88;
    private PluginXMLTextMerger myMerger;
    private boolean shouldFailOnException = true;
    private Pattern myNewLinePattern = Pattern.compile("\r\n");
    private static final String file = String.valueOf(T_0) + NL + "%s" + NL + "</plugin>";
    private static final String extensionNoId = "<extension point=\"oeg.extpoint\">%s</extension>" + NL;
    private static final String extensionWithId = "<extension point=\"oeg.extpoint\" id=\"%s\">%s</extension>" + NL;

    public PluginXMLTextMergerTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.myMerger = new PluginXMLTextMerger(PI_TARGET_GMFGEN, PI_DATA_GENERATED, PI_GENERATED_VALUE){

            protected void logException(String message, Exception e) {
                if (PluginXMLTextMergerTest.this.shouldFailOnException) {
                    PluginXMLTextMergerTest.fail((String)message);
                }
            }
        };
    }

    public void testInvalidOld() {
        String newXML;
        String oldXML = NL;
        String expectedResult = newXML = String.valueOf(T_0) + T_2 + T_99;
        this.shouldFailOnException = false;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testInvalidNew() {
        String oldXML = String.valueOf(T_0) + T_1 + T_99;
        String newXML = NL;
        String expectedResult = oldXML;
        this.shouldFailOnException = false;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testAddEmptyOld() {
        String oldXML = String.valueOf(T_0) + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = String.valueOf(T_0) + T_2.trim() + NL + NL + T_99;
        this.internalTestIgnoreNewlines(oldXML, newXML, expectedResult);
    }

    public void testAddNonEmptyOld() {
        String oldContent = "<extension-point id='zzz'/>" + NL;
        String oldXML = String.valueOf(T_0) + oldContent + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = String.valueOf(T_0) + oldContent + T_2.trim() + NL + NL + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testWithEntities() {
        String oldXML = String.valueOf(T_0) + "&#x0A;&#x0D;&#10;&#13;" + T_1 + "&lt;&gt;" + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = String.valueOf(T_0) + "&#x0A;&#x0D;&#10;&#13;" + T_2 + "&lt;&gt;" + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testDifferentNewLines() {
        String oldXML = String.valueOf(T_0) + T_1 + T_3 + T_4 + T_5 + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_6 + T_99;
        String expectedResult = String.valueOf(T_0) + T_2 + T_3 + T_4 + T_6 + NL + T_99;
        this.internalTestIgnoreNewlines(oldXML, PluginXMLTextMergerTest.switchNewlines(newXML), expectedResult);
        this.internalTestIgnoreNewlines(PluginXMLTextMergerTest.switchNewlines(oldXML), newXML, expectedResult);
        this.internalTestIgnoreNewlines(PluginXMLTextMergerTest.switchNewlines(oldXML), PluginXMLTextMergerTest.switchNewlines(newXML), expectedResult);
        this.internalTestIgnoreNewlines(oldXML, newXML, PluginXMLTextMergerTest.switchNewlines(expectedResult));
    }

    private static String switchNewlines(String testString) {
        String replacement = NL.length() == 2 ? "\n" : "\r\n";
        Matcher matcher = Pattern.compile(NL).matcher(testString);
        PluginXMLTextMergerTest.assertTrue((boolean)matcher.find());
        return matcher.replaceAll(replacement);
    }

    public void testRemove() {
        String oldXML = String.valueOf(T_0) + T_1 + T_99;
        String newXML = String.valueOf(T_0) + T_99;
        String expectedResult = String.valueOf(T_0) + "   " + NL + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testKeep() {
        String oldXML = String.valueOf(T_0) + T_4 + T_99;
        String newXML = String.valueOf(T_0) + T_99;
        String expectedResult = String.valueOf(T_0) + T_4 + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testReplace() {
        String newXML;
        String oldXML = String.valueOf(T_0) + T_1 + T_99;
        String expectedResult = newXML = String.valueOf(T_0) + T_2 + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testGeneratedNot() {
        String oldXML = (String.valueOf(T_0) + T_1 + T_99).replace("generated=\"true\"", "generated=\"false\"");
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = oldXML;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testComplex() {
        String oldXML = String.valueOf(T_0) + T_1 + T_3 + T_4 + T_5 + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_6 + T_99;
        String expectedResult = String.valueOf(T_0) + T_2 + T_3 + T_4 + T_6 + NL + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testUnformatted() {
        String oldXML = String.valueOf(T_7) + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><?eclipse version=\"3.0\"?><plugin>" + T_20 + T_21 + T_22 + "   </extension>" + NL + "   <extension point=\"org.eclipse.core.runtime.preferences\">" + T_78 + "   </extension>" + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testWithComments() {
        String oldXML = String.valueOf(T_0) + T_1 + T_8 + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = String.valueOf(T_0) + T_2 + T_8 + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testApostrophe() {
        String oldXML = String.valueOf(T_0) + T_3_A + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = String.valueOf(T_0) + T_3_A + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testSpace() {
        String oldXML = String.valueOf(T_0) + T_3_S + T_99;
        String newXML = String.valueOf(T_0) + T_2 + T_99;
        String expectedResult = String.valueOf(T_0) + T_3_S + T_99;
        this.internalTest(oldXML, newXML, expectedResult);
    }

    public void testSameExtensionPointConflictNoIdentities() {
        String oldXML = String.format(extensionNoId, "<user><manual/></user>");
        String newXML = String.format(extensionNoId, String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(oldXML, newXML, oldXML);
    }

    public void testConflictWithManuallyAddedIdentifiedExtension() {
        String oldXML = String.format(extensionWithId, "identity", "<user><manual/></user>");
        String newXML = String.format(extensionNoId, String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(oldXML, newXML, String.valueOf(oldXML) + newXML + NL);
    }

    public void testConflictWithManuallyAddedNoIdentityExtension() {
        String oldXML = String.format(extensionNoId, "<user><manual/></user>");
        String newXML = String.format(extensionWithId, "generated-identity", String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(oldXML, newXML, String.valueOf(oldXML) + newXML + NL);
    }

    public void testConflictWithManuallyAddedDistinctIdentities() {
        String oldXML = String.format(extensionWithId, "manual-identity", "<user><manual/></user>");
        String newXML = String.format(extensionWithId, "generated-identity", String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(oldXML, newXML, String.valueOf(oldXML) + newXML + NL);
    }

    public void testConflictBothGeneratedButDistinctIdentities() {
        String oldXML_withIdentity = String.format(extensionWithId, "generated-id1", String.valueOf(PI) + "<oldbody/>");
        String newXML = String.format(extensionWithId, "also-generated-id2", String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(oldXML_withIdentity, newXML, newXML);
        String oldXML_noIdentity = String.format(extensionNoId, String.valueOf(PI) + "<oldbody/>");
        this.internalTest_Bodies(oldXML_noIdentity, newXML, newXML);
    }

    public void testConflicTwoGeneratedTwistIdentities() {
        String oldXML_1 = String.format(extensionWithId, "generated-id1", String.valueOf(PI) + "<oldbody1/>");
        String oldXML_2 = String.format(extensionWithId, "generated-id2", String.valueOf(PI) + "<oldbody2/>");
        String newXML_1 = String.format(extensionWithId, "generated-id2", String.valueOf(PI) + "<newbody2/>");
        String newXML_2 = String.format(extensionWithId, "generated-id1", String.valueOf(PI) + "<newbody1/>");
        this.internalTest_Bodies(String.valueOf(oldXML_1) + oldXML_2, String.valueOf(newXML_1) + newXML_2, String.valueOf(newXML_2) + newXML_1);
    }

    public void testTwoExtensionsSamePointOneAddedManualWithID() {
        String oldXML_1 = String.format(extensionWithId, "manual", "<user><trash/></user>");
        String oldXML_2 = String.format(extensionNoId, String.valueOf(PI) + "<oldbody/>");
        String newXML = String.format(extensionNoId, String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(String.valueOf(oldXML_1) + oldXML_2, newXML, String.valueOf(oldXML_1) + newXML);
        this.internalTest_Bodies(String.valueOf(oldXML_2) + oldXML_1, newXML, String.valueOf(newXML) + oldXML_1);
    }

    public void testTwoExtensionsSamePointOneAddedManualNoID() {
        String oldXML_1 = String.format(extensionNoId, "<user><trash/></user>");
        String oldXML_2 = String.format(extensionWithId, "generated-identity", String.valueOf(PI) + "<oldbody/>");
        String newXML = String.format(extensionWithId, "generated-identity", String.valueOf(PI) + "<newbody/>");
        this.internalTest_Bodies(String.valueOf(oldXML_1) + oldXML_2, newXML, String.valueOf(oldXML_1) + newXML);
        this.internalTest_Bodies(String.valueOf(oldXML_2) + oldXML_1, newXML, String.valueOf(newXML) + oldXML_1);
    }

    public void testTwoGeneratedExtensionsSamePointReplacedByOne() {
        String oldXML_1 = String.format(extensionWithId, "generated-id1", String.valueOf(PI) + "<oldbody1/>");
        String oldXML_2 = "<extension point=\"different.point\"><bogus/></extension>\n";
        String oldXML_3 = String.format(extensionWithId, "generated-id3", String.valueOf(PI) + "<oldbody3/>");
        String newXML = String.format(extensionWithId, "generated-id3", String.valueOf(PI) + "<newbody3/>");
        this.internalTest_Bodies(String.valueOf(oldXML_1) + oldXML_2 + oldXML_3, newXML, String.valueOf(newXML) + oldXML_2);
        this.internalTest_Bodies(String.valueOf(oldXML_3) + oldXML_2 + oldXML_1, newXML, String.valueOf(newXML) + oldXML_2);
    }

    public void testTwoGeneratedExtensionsSamePointReplacedByTwoWithIDs() {
        String oldXML_1 = String.format(extensionNoId, String.valueOf(PI) + "<oldbody1/>");
        String oldXML_2 = String.format(extensionNoId, String.valueOf(PI) + "<oldbody2/>");
        String newXML_1 = String.format(extensionWithId, "generated-id1", String.valueOf(PI) + "<newbody1/>");
        String newXML_2 = String.format(extensionWithId, "generated-id2", String.valueOf(PI) + "<newbody2/>");
        this.internalTest_Bodies(String.valueOf(oldXML_1) + oldXML_2, String.valueOf(newXML_1) + newXML_2, String.valueOf(newXML_1) + newXML_2);
    }

    public void testNewExtensionIsInjected() {
        String oldXML = "<extension point=\"oeg.extpoint.one\" id=\"one\"><oldbody/></extension>";
        String newXML_1 = "<extension point=\"oeg.extpoint.two\" id=\"two\"><newbody/></extension>" + NL;
        this.internalTest_Bodies(oldXML, String.valueOf(newXML_1) + NL + oldXML, String.valueOf(oldXML) + NL + newXML_1);
    }

    private void internalTest_Bodies(String oldFileBody, String newFileBody, String expectedFileBody) {
        String result = this.myMerger.process(String.format(file, oldFileBody), String.format(file, newFileBody));
        PluginXMLTextMergerTest.assertNotNull((Object)result);
        String expectedResult = String.format(file, expectedFileBody);
        PluginXMLTextMergerTest.assertEquals((String)expectedResult, (String)result);
    }

    private void internalTest(String oldXML, String newXML, String expectedResult) {
        String result = this.myMerger.process(oldXML, newXML);
        PluginXMLTextMergerTest.assertNotNull((Object)result);
        PluginXMLTextMergerTest.assertEquals((String)expectedResult, (String)result);
    }

    private void internalTestIgnoreNewlines(String oldXML, String newXML, String expectedResult) {
        String result = this.myMerger.process(oldXML, newXML);
        PluginXMLTextMergerTest.assertNotNull((Object)result);
        String uniformResult = this.myNewLinePattern.matcher(result).replaceAll("\n");
        String uniformExpected = this.myNewLinePattern.matcher(expectedResult).replaceAll("\n");
        PluginXMLTextMergerTest.assertEquals((String)uniformExpected, (String)uniformResult);
    }
}

