/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.lite.properties;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySource2;

class SetValueCommand
extends Command {
    protected Object propertyValue;
    protected Object propertyName;
    protected Object undoValue;
    protected boolean resetOnUndo;
    protected IPropertySource target;

    public SetValueCommand() {
        super("");
    }

    public SetValueCommand(String propLabel) {
        super(MessageFormat.format("Set {0} property", propLabel).trim());
    }

    public boolean canExecute() {
        return true;
    }

    public void execute() {
        boolean wasPropertySet = this.getTarget().isPropertySet(this.propertyName);
        this.undoValue = this.getTarget().getPropertyValue(this.propertyName);
        if (this.undoValue instanceof IPropertySource) {
            this.undoValue = ((IPropertySource)this.undoValue).getEditableValue();
        } else if (this.undoValue instanceof IItemPropertySource) {
            this.undoValue = ((IItemPropertySource)this.undoValue).getEditableValue(this.propertyName);
            if (this.undoValue instanceof EList) {
                BasicEList theValue = new BasicEList();
                theValue.addAll((Collection)((EList)this.undoValue));
                this.undoValue = theValue;
            }
        }
        if (this.propertyValue instanceof IPropertySource) {
            this.propertyValue = ((IPropertySource)this.propertyValue).getEditableValue();
        }
        this.getTarget().setPropertyValue(this.propertyName, this.propertyValue);
        if (this.getTarget() instanceof IPropertySource2) {
            this.resetOnUndo = !wasPropertySet && ((IPropertySource2)this.getTarget()).isPropertyResettable(this.propertyName);
        } else {
            boolean bl = this.resetOnUndo = !wasPropertySet && this.getTarget().isPropertySet(this.propertyName);
        }
        if (this.resetOnUndo) {
            this.undoValue = null;
        }
    }

    public IPropertySource getTarget() {
        return this.target;
    }

    public void setTarget(IPropertySource aTarget) {
        this.target = aTarget;
    }

    public void redo() {
        this.execute();
    }

    public void setPropertyId(Object pName) {
        this.propertyName = pName;
    }

    public void setPropertyValue(Object val) {
        this.propertyValue = val;
    }

    public void undo() {
        if (this.resetOnUndo) {
            this.getTarget().resetPropertyValue(this.propertyName);
        } else {
            this.getTarget().setPropertyValue(this.propertyName, this.undoValue);
        }
    }
}

