/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.edit.policies;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.ecore.part.EcoreDiagramUpdater;
import org.eclipse.gmf.ecore.part.EcoreLinkDescriptor;
import org.eclipse.gmf.ecore.part.EcoreNodeDescriptor;
import org.eclipse.gmf.ecore.part.EcoreVisualIDRegistry;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.DeferredLayoutCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetViewMutabilityCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CanonicalEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EPackageCanonicalEditPolicy
extends CanonicalEditPolicy {
    Set<EStructuralFeature> myFeaturesToSynchronize;

    protected List getSemanticChildrenList() {
        View viewObject = (View)this.getHost().getModel();
        LinkedList<EObject> result = new LinkedList<EObject>();
        List<EcoreNodeDescriptor> childDescriptors = EcoreDiagramUpdater.getEPackage_1000SemanticChildren(viewObject);
        for (EcoreNodeDescriptor d : childDescriptors) {
            result.add(d.getModelElement());
        }
        return result;
    }

    protected boolean shouldDeleteView(View view) {
        return true;
    }

    protected boolean isOrphaned(Collection semanticChildren, View view) {
        if (view.getEAnnotation("Shortcut") != null) {
            return EcoreDiagramUpdater.isShortcutOrphaned(view);
        }
        int visualID = EcoreVisualIDRegistry.getVisualID(view);
        switch (visualID) {
            case 2001: 
            case 2002: 
            case 2003: 
            case 2004: 
            case 2005: {
                if (semanticChildren.contains(view.getElement())) break;
                return true;
            }
        }
        return false;
    }

    protected Set getFeaturesToSynchronize() {
        if (this.myFeaturesToSynchronize == null) {
            this.myFeaturesToSynchronize = new HashSet<EStructuralFeature>();
            this.myFeaturesToSynchronize.add((EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_EClassifiers());
            this.myFeaturesToSynchronize.add((EStructuralFeature)EcorePackage.eINSTANCE.getEPackage_ESubpackages());
            this.myFeaturesToSynchronize.add((EStructuralFeature)EcorePackage.eINSTANCE.getEModelElement_EAnnotations());
        }
        return this.myFeaturesToSynchronize;
    }

    protected void refreshSemantic() {
        if (this.resolveSemanticElement() == null) {
            return;
        }
        LinkedList<IAdaptable> createdViews = new LinkedList<IAdaptable>();
        List<EcoreNodeDescriptor> childDescriptors = EcoreDiagramUpdater.getEPackage_1000SemanticChildren((View)this.getHost().getModel());
        ArrayList<EObject> semanticChildren = new ArrayList<EObject>(childDescriptors.size());
        for (EcoreNodeDescriptor next : childDescriptors) {
            semanticChildren.add(next.getModelElement());
        }
        List orphaned = this.cleanCanonicalSemanticChildren(this.getViewChildren(), semanticChildren);
        boolean changed = this.deleteViews(orphaned.iterator());
        Iterator<EcoreNodeDescriptor> it = childDescriptors.iterator();
        while (it.hasNext()) {
            EcoreNodeDescriptor next = it.next();
            if (semanticChildren.contains(next.getModelElement())) continue;
            it.remove();
        }
        ArrayList<CreateViewRequest.ViewDescriptor> viewDescriptors = new ArrayList<CreateViewRequest.ViewDescriptor>(childDescriptors.size());
        for (EcoreNodeDescriptor next : childDescriptors) {
            String hint = EcoreVisualIDRegistry.getType(next.getVisualID());
            CanonicalEditPolicy.CanonicalElementAdapter elementAdapter = new CanonicalEditPolicy.CanonicalElementAdapter(next.getModelElement(), hint);
            viewDescriptors.add(new CreateViewRequest.ViewDescriptor((IAdaptable)elementAdapter, Node.class, hint, -1, false, this.host().getDiagramPreferencesHint()));
        }
        CreateViewRequest request = this.getCreateViewRequest(viewDescriptors);
        Command cmd = this.getCreateViewCommand((CreateRequest)request);
        if (cmd != null && cmd.canExecute()) {
            SetViewMutabilityCommand.makeMutable((IAdaptable)new EObjectAdapter((EObject)this.host().getNotationView())).execute();
            this.executeCommand(cmd);
            createdViews.addAll((List)request.getNewObject());
        }
        if (changed || createdViews.size() > 0) {
            this.postProcessRefreshSemantic(createdViews);
        }
        Collection<IAdaptable> createdConnectionViews = this.refreshConnections();
        if (createdViews.size() > 1) {
            DeferredLayoutCommand layoutCmd = new DeferredLayoutCommand(this.host().getEditingDomain(), createdViews, this.host());
            this.executeCommand((Command)new ICommandProxy((ICommand)layoutCmd));
        }
        createdViews.addAll(createdConnectionViews);
        this.makeViewsImmutable(createdViews);
    }

    private Diagram getDiagram() {
        return ((View)this.getHost().getModel()).getDiagram();
    }

    private Collection<IAdaptable> refreshConnections() {
        HashMap<EObject, View> domain2NotationMap = new HashMap<EObject, View>();
        Collection<EcoreLinkDescriptor> linkDescriptors = this.collectAllLinks((View)this.getDiagram(), domain2NotationMap);
        LinkedList existingLinks = new LinkedList(this.getDiagram().getEdges());
        Iterator linksIterator = existingLinks.iterator();
        block0: while (linksIterator.hasNext()) {
            Edge nextDiagramLink = (Edge)linksIterator.next();
            int diagramLinkVisualID = EcoreVisualIDRegistry.getVisualID((View)nextDiagramLink);
            if (diagramLinkVisualID == -1) {
                if (nextDiagramLink.getSource() == null || nextDiagramLink.getTarget() == null) continue;
                linksIterator.remove();
                continue;
            }
            EObject diagramLinkObject = nextDiagramLink.getElement();
            EObject diagramLinkSrc = nextDiagramLink.getSource().getElement();
            EObject diagramLinkDst = nextDiagramLink.getTarget().getElement();
            Iterator<EcoreLinkDescriptor> linkDescriptorsIterator = linkDescriptors.iterator();
            while (linkDescriptorsIterator.hasNext()) {
                EcoreLinkDescriptor nextLinkDescriptor = linkDescriptorsIterator.next();
                if (diagramLinkObject != nextLinkDescriptor.getModelElement() || diagramLinkSrc != nextLinkDescriptor.getSource() || diagramLinkDst != nextLinkDescriptor.getDestination() || diagramLinkVisualID != nextLinkDescriptor.getVisualID()) continue;
                linksIterator.remove();
                linkDescriptorsIterator.remove();
                continue block0;
            }
        }
        this.deleteViews(existingLinks.iterator());
        return this.createConnections(linkDescriptors, domain2NotationMap);
    }

    private Collection<EcoreLinkDescriptor> collectAllLinks(View view, Map<EObject, View> domain2NotationMap) {
        if (!"Ecore".equals(EcoreVisualIDRegistry.getModelID(view))) {
            return Collections.emptyList();
        }
        LinkedList<EcoreLinkDescriptor> result = new LinkedList<EcoreLinkDescriptor>();
        switch (EcoreVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEPackage_1000ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2001: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEClass_2001ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEPackage_2002ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEAnnotation_2003ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2004: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEDataType_2004ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 2005: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEEnum_2005ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4002: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEReference_4002ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
                break;
            }
            case 4003: {
                if (!domain2NotationMap.containsKey(view.getElement())) {
                    result.addAll(EcoreDiagramUpdater.getEReference_4003ContainedLinks(view));
                }
                if (domain2NotationMap.containsKey(view.getElement()) && view.getEAnnotation("Shortcut") != null) break;
                domain2NotationMap.put(view.getElement(), view);
            }
        }
        Iterator children = view.getChildren().iterator();
        while (children.hasNext()) {
            result.addAll(this.collectAllLinks((View)children.next(), domain2NotationMap));
        }
        Iterator edges = view.getSourceEdges().iterator();
        while (edges.hasNext()) {
            result.addAll(this.collectAllLinks((View)edges.next(), domain2NotationMap));
        }
        return result;
    }

    private Collection<IAdaptable> createConnections(Collection<EcoreLinkDescriptor> linkDescriptors, Map<EObject, View> domain2NotationMap) {
        LinkedList<IAdaptable> adapters = new LinkedList<IAdaptable>();
        for (EcoreLinkDescriptor nextLinkDescriptor : linkDescriptors) {
            EditPart sourceEditPart = this.getEditPart(nextLinkDescriptor.getSource(), domain2NotationMap);
            EditPart targetEditPart = this.getEditPart(nextLinkDescriptor.getDestination(), domain2NotationMap);
            if (sourceEditPart == null || targetEditPart == null) continue;
            CreateConnectionViewRequest.ConnectionViewDescriptor descriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(nextLinkDescriptor.getSemanticAdapter(), String.valueOf(nextLinkDescriptor.getVisualID()), -1, false, ((IGraphicalEditPart)this.getHost()).getDiagramPreferencesHint());
            CreateConnectionViewRequest ccr = new CreateConnectionViewRequest(descriptor);
            ccr.setType((Object)"connection start");
            ccr.setSourceEditPart(sourceEditPart);
            sourceEditPart.getCommand((Request)ccr);
            ccr.setTargetEditPart(targetEditPart);
            ccr.setType((Object)"connection end");
            Command cmd = targetEditPart.getCommand((Request)ccr);
            if (cmd == null || !cmd.canExecute()) continue;
            this.executeCommand(cmd);
            IAdaptable viewAdapter = (IAdaptable)ccr.getNewObject();
            if (viewAdapter == null) continue;
            adapters.add(viewAdapter);
        }
        return adapters;
    }

    private EditPart getEditPart(EObject domainModelElement, Map<EObject, View> domain2NotationMap) {
        View view = domain2NotationMap.get(domainModelElement);
        if (view != null) {
            return (EditPart)this.getHost().getViewer().getEditPartRegistry().get(view);
        }
        return null;
    }
}

