/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.transform;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.internal.bridge.transform.Messages;
import org.eclipse.gmf.internal.bridge.transform.TransformOptions;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelOperation;
import org.eclipse.gmf.internal.bridge.transform.TransformToGenModelWizard;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class ViewmapProducerWizardPage
extends WizardPage {
    private Button generateRCPButton;
    private Button useMapModeButton;
    private Button useRuntimeFiguresButton;
    private Text templatesPathText;
    private Text qvtoFileControl;
    private Text preReconcileTranfsormText;
    private Text postReconcileTranfsormText;
    private Button radioDGMT;
    private Button radioQVT;
    private Button preReconcileTransformBtn;
    private Button postReconcileTransformBtn;
    private ExpandItem myTemplatePathItem;
    private ExpandItem myTransformsItem;

    protected ViewmapProducerWizardPage(String pageName) {
        super(pageName);
        this.setTitle(Messages.TransformToGenModelWizard_title_options);
        this.setDescription(Messages.TransformToGenModelWizard_descr_options);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createControls(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initControls();
            this.validatePage();
        }
    }

    private void createControls(Composite result) {
        this.useMapModeButton = new Button(result, 32);
        this.useMapModeButton.setText(Messages.ViewmapProducerWizardPage_btn_mapmode);
        this.useMapModeButton.setLayoutData((Object)new GridData(36));
        this.useRuntimeFiguresButton = new Button(result, 32);
        this.useRuntimeFiguresButton.setText(Messages.ViewmapProducerWizardPage_btn_runtime);
        this.useRuntimeFiguresButton.setLayoutData((Object)new GridData(36));
        this.generateRCPButton = new Button(result, 32);
        this.generateRCPButton.setText(Messages.ViewmapProducerWizardPage_btn_rcp);
        this.generateRCPButton.setLayoutData((Object)new GridData(36));
        SelectionListener selectionListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (ViewmapProducerWizardPage.this.generateRCPButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setGenerateRCP(ViewmapProducerWizardPage.this.generateRCPButton.getSelection());
                } else if (ViewmapProducerWizardPage.this.useMapModeButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setUseMapMode(ViewmapProducerWizardPage.this.useMapModeButton.getSelection());
                } else if (ViewmapProducerWizardPage.this.useRuntimeFiguresButton == e.widget) {
                    ViewmapProducerWizardPage.this.getOperation().getOptions().setUseRuntimeFigures(ViewmapProducerWizardPage.this.useRuntimeFiguresButton.getSelection());
                }
                ViewmapProducerWizardPage.this.validatePage();
            }
        };
        this.useMapModeButton.addSelectionListener(selectionListener);
        this.useRuntimeFiguresButton.addSelectionListener(selectionListener);
        this.generateRCPButton.addSelectionListener(selectionListener);
        this.createAdvancedControls(result);
        Composite glue = new Composite(result, 0);
        glue.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    private void createAdvancedControls(Composite result) {
        Group parent = new Group(result, 16);
        parent.setText("Provisional");
        parent.setLayout((Layout)new FillLayout());
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        ExpandBar c = new ExpandBar((Composite)parent, 0);
        c.setBackground(parent.getBackground());
        this.templatesPathText = new Text((Composite)c, 2052);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                ViewmapProducerWizardPage.this.validatePage();
            }
        };
        this.templatesPathText.addListener(24, modifyListener);
        this.myTemplatePathItem = new ExpandItem(c, 0, 0);
        this.myTemplatePathItem.setText("GMFGraph dynamic templates");
        this.myTemplatePathItem.setHeight(this.templatesPathText.computeSize((int)-1, (int)-1).y);
        this.myTemplatePathItem.setControl((Control)this.templatesPathText);
        Composite map2genControls = new Composite((Composite)c, 0);
        map2genControls.setLayout((Layout)new FillLayout(512));
        this.radioDGMT = new Button(map2genControls, 16);
        this.radioDGMT.setText("Use Java transformation");
        this.radioQVT = new Button(map2genControls, 16);
        this.radioQVT.setText("Use QVTO transformation");
        this.qvtoFileControl = new Text(map2genControls, 2052);
        this.qvtoFileControl.addListener(24, modifyListener);
        class EnablementListener
        implements Listener {
            private final Button myControl;
            private final Control myTarget;

            public EnablementListener(Button control, Control target) {
                if (!($assertionsDisabled || control != null && target != null)) {
                    throw new AssertionError();
                }
                this.myControl = control;
                this.myTarget = target;
            }

            public void handleEvent(Event event) {
                this.myTarget.setEnabled(this.myControl.getSelection());
            }
        }
        EnablementListener l = new EnablementListener(this.radioQVT, (Control)this.qvtoFileControl);
        this.radioDGMT.addListener(13, (Listener)l);
        this.radioQVT.addListener(13, (Listener)l);
        this.preReconcileTransformBtn = new Button(map2genControls, 32);
        this.preReconcileTransformBtn.setText("Extra in-place gmfgen transformation before a reconcile step");
        this.preReconcileTranfsormText = new Text(map2genControls, 2052);
        this.postReconcileTransformBtn = new Button(map2genControls, 32);
        this.postReconcileTransformBtn.setText("Extra in-place gmfgen transformation after a reconcile step");
        this.postReconcileTranfsormText = new Text(map2genControls, 2052);
        this.preReconcileTransformBtn.addListener(13, (Listener)new EnablementListener(this.preReconcileTransformBtn, (Control)this.preReconcileTranfsormText));
        this.postReconcileTransformBtn.addListener(13, (Listener)new EnablementListener(this.postReconcileTransformBtn, (Control)this.postReconcileTranfsormText));
        this.preReconcileTranfsormText.addListener(24, modifyListener);
        this.postReconcileTranfsormText.addListener(24, modifyListener);
        String hint = "Transformation should take single inout parameter of GMFGen model type, e.g.\n\nmodeltype GMFGEN uses gmfgen('http://www.eclipse.org/gmf/2009/GenModel');\n\ntransformation %s(inout gmfgenModel : GMFGEN);\n\n main() {...}";
        this.preReconcileTranfsormText.setToolTipText(String.format(hint, "PreReconcile"));
        this.postReconcileTranfsormText.setToolTipText(String.format(hint, "PostReconcile"));
        this.myTransformsItem = new ExpandItem(c, 0, 1);
        this.myTransformsItem.setText("Map to Gen transformation");
        this.myTransformsItem.setHeight(map2genControls.computeSize((int)-1, (int)-1).y);
        this.myTransformsItem.setControl((Control)map2genControls);
    }

    void validatePage() {
        this.setStatus(Status.OK_STATUS);
        boolean hasLite = TransformOptions.checkLiteOptionPresent();
        if (hasLite && !this.useRuntimeFiguresButton.getSelection() && this.useMapModeButton.getSelection()) {
            this.setStatus(Plugin.createInfo(Messages.ViewmapProducerWizardPage_i_not_recommended));
        }
        TransformOptions options = this.getOperation().getOptions();
        options.setFigureTemplatesPath(this.checkTextFieldURI(this.templatesPathText, true));
        options.setTransformation(this.checkTextFieldURI(this.qvtoFileControl, false));
        options.setPreReconcileTransform(this.checkTextFieldURI(this.preReconcileTranfsormText, false));
        options.setPostReconcileTransform(this.checkTextFieldURI(this.postReconcileTranfsormText, false));
    }

    private URL checkTextFieldURI(Text widget, boolean resolve) {
        if (!widget.isEnabled()) {
            return null;
        }
        if (widget.getText().trim().length() > 0) {
            try {
                return new URL(ViewmapProducerWizardPage.guessAndResolvePathURL(widget.getText().trim(), resolve));
            }
            catch (MalformedURLException ex) {
                this.setStatus(Plugin.createWarning(ex.getMessage()));
            }
        }
        return null;
    }

    private void initControls() {
        TransformOptions options = this.getOperation().getOptions();
        this.generateRCPButton.setSelection(options.getGenerateRCP());
        this.useRuntimeFiguresButton.setSelection(options.getUseRuntimeFigures());
        this.useMapModeButton.setSelection(options.getUseMapMode());
        if (options.getFigureTemplatesPath() != null) {
            this.templatesPathText.setText(options.getFigureTemplatesPath().toString());
            this.myTemplatePathItem.setExpanded(true);
        }
        this.radioDGMT.setSelection(options.getMainTransformation() == null);
        this.radioQVT.setSelection(!this.radioDGMT.getSelection());
        this.qvtoFileControl.setEnabled(this.radioQVT.getSelection());
        this.qvtoFileControl.setText(options.getMainTransformation() != null ? options.getMainTransformation().toString() : "");
        this.preReconcileTransformBtn.setSelection(options.getPreReconcileTransform() != null);
        this.preReconcileTranfsormText.setEnabled(this.preReconcileTransformBtn.getSelection());
        this.preReconcileTranfsormText.setText(options.getPreReconcileTransform() != null ? options.getPreReconcileTransform().toString() : "");
        this.postReconcileTransformBtn.setSelection(options.getPostReconcileTransform() != null);
        this.postReconcileTranfsormText.setEnabled(this.postReconcileTransformBtn.getSelection());
        this.postReconcileTranfsormText.setText(options.getPostReconcileTransform() != null ? options.getPostReconcileTransform().toString() : "");
        if (this.radioQVT.getSelection() || this.preReconcileTransformBtn.getSelection() || this.postReconcileTransformBtn.getSelection()) {
            this.myTransformsItem.setExpanded(true);
        }
    }

    private TransformToGenModelOperation getOperation() {
        return ((TransformToGenModelWizard)this.getWizard()).getTransformOperation();
    }

    private void setStatus(IStatus s) {
        if (s.isOK()) {
            this.setMessage(null);
            this.setPageComplete(true);
        } else {
            this.setMessage(s.getMessage(), 1);
            this.setPageComplete(s.getSeverity() < 2);
        }
    }

    private static String guessAndResolvePathURL(String path, boolean resolve) {
        assert (path != null);
        try {
            URI templatesURI = path.indexOf(58) == -1 ? URI.createPlatformResourceURI((String)path, (boolean)true) : URI.createURI((String)path);
            return resolve ? CommonPlugin.resolve((URI)templatesURI).toString() : templatesURI.toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return path;
        }
    }
}

