/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.search.codegen.popup.actions;

import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.search.codegen.wizard.textual.ModelSearchTextualCodeGenWizard;
import org.eclipse.emf.search.ui.internal.replace.provisional.ModelSearchWizardDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class GenerateSearchAction
implements IObjectActionDelegate {
    private GenModel genModel = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        ModelSearchTextualCodeGenWizard wizard = new ModelSearchTextualCodeGenWizard(this.genModel);
        ModelSearchWizardDialog wizardDialog = new ModelSearchWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        wizardDialog.create();
        wizardDialog.getShell().setSize(Math.max(500, wizardDialog.getShell().getSize().x), 500);
        wizardDialog.getShell().setText("Textual Model Search Generation Wizard");
        wizardDialog.open();
    }

    public boolean visit(File file) {
        if (this.isParticipantCurrentSearchEngineValid(file)) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)file.getAbsolutePath());
            this.initResourceSet((ResourceSet)resourceSet, fileURI);
            try {
                EObject o;
                Resource resource = resourceSet.getResource(fileURI, true);
                if (!resource.getContents().isEmpty() && (o = (EObject)resource.getContents().get(0)) instanceof GenModel) {
                    this.genModel = (GenModel)o;
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    protected void initResourceSet(ResourceSet resourceSet, URI fileURI) {
        resourceSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
    }

    protected boolean isParticipantCurrentSearchEngineValid(File f) {
        if (f instanceof File && f.canRead() && f.exists() && !f.isHidden()) {
            return f.getName().endsWith(".genmodel");
        }
        return false;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.getFirstElement() instanceof IFile) {
            IFile file = (IFile)structuredSelection.getFirstElement();
            this.visit(new File(file.getLocationURI()));
        }
    }
}

