/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.properties.internal.sections;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecoretools.properties.internal.Messages;
import org.eclipse.emf.ecoretools.tabbedproperties.sections.AbstractTabbedPropertySection;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class GenModelDocumentationPropertySection
extends AbstractTabbedPropertySection {
    private static final String GENMODEL_SOURCE = "http://www.eclipse.org/emf/2002/GenModel";
    private static final String GENMODEL_DOC_KEY = "documentation";
    private Text commentsText;
    private FocusAdapter focusListener;

    protected String getLabelText() {
        return Messages.GenModelDocumentationPropertySection_GenModelDocumentation;
    }

    protected EStructuralFeature getFeature() {
        return EcorePackage.Literals.EANNOTATION__SOURCE;
    }

    protected void createWidgets(Composite composite) {
        this.commentsText = new Text(composite, 2626);
        this.focusListener = new FocusAdapter(){
            private String previousComment;

            public void focusGained(FocusEvent e) {
                this.previousComment = GenModelDocumentationPropertySection.this.commentsText.getText();
            }

            public void focusLost(FocusEvent e) {
                if (!GenModelDocumentationPropertySection.this.commentsText.getText().equals(this.previousComment)) {
                    GenModelDocumentationPropertySection.this.handleDocChanged();
                }
            }
        };
        this.commentsText.addFocusListener((FocusListener)this.focusListener);
    }

    protected void setSectionData(Composite composite) {
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.top = new FormAttachment(0, 4);
        data.bottom = new FormAttachment(100, 0);
        this.commentsText.setLayoutData((Object)data);
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    public void refresh() {
        String doc;
        EAnnotation annotation;
        this.commentsText.setText("");
        this.commentsText.setEnabled(this.getEObject() != null);
        if (this.getEObject() != null && (annotation = ((EModelElement)this.getEObject()).getEAnnotation(GENMODEL_SOURCE)) != null && (doc = (String)annotation.getDetails().get((Object)GENMODEL_DOC_KEY)) != null) {
            this.commentsText.setText(doc);
        }
    }

    private void handleDocChanged() {
        String newDoc = this.commentsText.getText();
        if (this.getEObject() != null) {
            ChangeComments cmd = new ChangeComments((EModelElement)this.getEObject(), newDoc);
            this.getEditingDomain().getCommandStack().execute((Command)cmd);
        }
    }

    private class ChangeComments
    extends AbstractCommand {
        private EModelElement element;
        private String newComments;
        private String oldComments;

        public ChangeComments(EModelElement element, String comments) {
            super(Messages.GenModelDocumentationPropertySection_ChangeComments);
            this.element = element;
            this.newComments = comments;
        }

        public boolean canExecute() {
            return true;
        }

        public boolean canUndo() {
            return true;
        }

        public void execute() {
            this.oldComments = null;
            EAnnotation annotation = this.element.getEAnnotation(GenModelDocumentationPropertySection.GENMODEL_SOURCE);
            if (annotation != null) {
                this.oldComments = (String)annotation.getDetails().get((Object)GenModelDocumentationPropertySection.GENMODEL_DOC_KEY);
            }
            this.redo();
        }

        protected void changeDocumentation(EModelElement elt, String newDoc) {
            EAnnotation annotation = elt.getEAnnotation(GenModelDocumentationPropertySection.GENMODEL_SOURCE);
            if (newDoc != null && !"".equals(newDoc)) {
                if (annotation == null) {
                    annotation = EcoreFactory.eINSTANCE.createEAnnotation();
                    annotation.setSource(GenModelDocumentationPropertySection.GENMODEL_SOURCE);
                    elt.getEAnnotations().add((Object)annotation);
                }
                annotation.getDetails().put((Object)GenModelDocumentationPropertySection.GENMODEL_DOC_KEY, (Object)newDoc);
            } else if (annotation != null) {
                annotation.getDetails().remove((Object)GenModelDocumentationPropertySection.GENMODEL_DOC_KEY);
                if (annotation.getDetails().size() == 0) {
                    elt.getEAnnotations().remove((Object)annotation);
                }
            }
        }

        public void redo() {
            this.changeDocumentation(this.element, this.newComments);
        }

        public void undo() {
            this.changeDocumentation(this.element, this.oldComments);
        }
    }
}

