/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.internal.filter;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.match.filter.IResourceFilter;
import org.eclipse.emf.compare.match.internal.statistic.ResourceSimilarity;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryIdenticalResourceFilter
implements IResourceFilter {
    /*
     * WARNING - void declaration
     */
    @Override
    public void filter(List<Resource> leftResources, List<Resource> rightResources) {
        void var6_7;
        ArrayList<Doublet<Resource>> matchedResources = new ArrayList<Doublet<Resource>>();
        ArrayList<Resource> leftRemaining = new ArrayList<Resource>(leftResources);
        ArrayList<Resource> rightRemaining = new ArrayList<Resource>(rightResources);
        boolean bl = false;
        while (var6_7 < 2) {
            for (Resource left : new ArrayList<Resource>(leftRemaining)) {
                Resource matchedResource = ResourceSimilarity.findMatchingResource(left, rightRemaining);
                if (matchedResource == null || ResourceSimilarity.findMatchingResource(matchedResource, leftRemaining) != left) continue;
                matchedResources.add(new Doublet<Resource>(left, matchedResource));
                leftRemaining.remove(left);
                rightRemaining.remove(matchedResource);
            }
            ++var6_7;
        }
        for (Doublet doublet : matchedResources) {
            byte[] rightContent;
            if (this.hasFragments((Resource)doublet.getFirst()) || this.hasFragments((Resource)doublet.getSecond())) continue;
            byte[] leftContent = this.getContent((Resource)doublet.getFirst());
            if (Arrays.equals(leftContent, rightContent = this.getContent((Resource)doublet.getSecond()))) {
                leftResources.remove(doublet.getFirst());
                rightResources.remove(doublet.getSecond());
            }
            doublet.clear();
        }
        leftRemaining.clear();
        rightRemaining.clear();
        matchedResources.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void filter(List<Resource> leftResources, List<Resource> rightResources, List<Resource> ancestorResources) {
        void var8_9;
        ArrayList<Triplet<Resource>> matchedResources = new ArrayList<Triplet<Resource>>();
        ArrayList<Resource> leftRemaining = new ArrayList<Resource>(leftResources);
        ArrayList<Resource> rightRemaining = new ArrayList<Resource>(rightResources);
        ArrayList<Resource> ancestorRemaining = new ArrayList<Resource>(ancestorResources);
        boolean bl = false;
        while (var8_9 < 2) {
            for (Resource left : new ArrayList<Resource>(leftRemaining)) {
                Resource matchedRight = ResourceSimilarity.findMatchingResource(left, rightRemaining);
                Resource matchedAncestor = ResourceSimilarity.findMatchingResource(left, ancestorRemaining);
                if (matchedRight == null || ResourceSimilarity.findMatchingResource(matchedRight, leftRemaining) != left || matchedAncestor == null || ResourceSimilarity.findMatchingResource(matchedAncestor, leftRemaining) != left) continue;
                matchedResources.add(new Triplet<Resource>(left, matchedRight, matchedAncestor));
                leftRemaining.remove(left);
                rightRemaining.remove(matchedRight);
                ancestorRemaining.remove(matchedAncestor);
            }
            ++var8_9;
        }
        for (Triplet triplet : matchedResources) {
            if (this.hasFragments((Resource)triplet.getFirst()) || this.hasFragments((Resource)triplet.getSecond()) || this.hasFragments((Resource)triplet.getThird())) continue;
            byte[] leftContent = this.getContent((Resource)triplet.getFirst());
            byte[] rightContent = this.getContent((Resource)triplet.getSecond());
            byte[] ancestorContent = this.getContent((Resource)triplet.getThird());
            if (Arrays.equals(leftContent, ancestorContent) && Arrays.equals(rightContent, ancestorContent)) {
                leftResources.remove(triplet.getFirst());
                rightResources.remove(triplet.getSecond());
                ancestorResources.remove(triplet.getThird());
            }
            triplet.clear();
        }
        leftRemaining.clear();
        rightRemaining.clear();
        ancestorRemaining.clear();
        matchedResources.clear();
    }

    private byte[] getContent(Resource resource) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            resource.save((OutputStream)stream, null);
        }
        catch (IOException e) {
            EMFComparePlugin.log((Exception)e, (boolean)false);
        }
        return stream.toByteArray();
    }

    private boolean hasFragments(Resource resource) {
        TreeIterator iterator = resource.getAllContents();
        while (iterator.hasNext()) {
            if (((EObject)iterator.next()).eResource() == resource) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Doublet<T> {
        private T first;
        private T second;

        public Doublet(T firstElement, T secondElement) {
            this.first = firstElement;
            this.second = secondElement;
        }

        public T getFirst() {
            return this.first;
        }

        public T getSecond() {
            return this.second;
        }

        public void clear() {
            this.first = null;
            this.second = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Triplet<T>
    extends Doublet<T> {
        private T third;

        public Triplet(T firstElement, T secondElement, T thirdElement) {
            super(firstElement, secondElement);
            this.third = thirdElement;
        }

        @Override
        public T getFirst() {
            return super.getFirst();
        }

        @Override
        public T getSecond() {
            return super.getSecond();
        }

        public T getThird() {
            return this.third;
        }

        @Override
        public void clear() {
            super.clear();
            this.third = null;
        }
    }
}

