/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.util;

import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import org.eclipse.xsd.util.DefaultJAXPConfiguration;
import org.eclipse.xsd.util.JAXPConfiguration;
import org.eclipse.xsd.util.JAXPPool;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class DefaultJAXPPool
implements JAXPPool {
    private final List<DocumentBuilder> documentBuilderCache = new ArrayList<DocumentBuilder>();
    private final List<Transformer> transformerCache = new ArrayList<Transformer>();
    private final List<SAXParser> saxParserCache = new ArrayList<SAXParser>();
    private final JAXPConfiguration configuration;

    public DefaultJAXPPool() {
        this(new DefaultJAXPConfiguration());
    }

    public DefaultJAXPPool(JAXPConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized DocumentBuilder getDocumentBuilder(ErrorHandler errorHandler) throws ParserConfigurationException, SAXException {
        int size = this.documentBuilderCache.size();
        if (size > 0) {
            DocumentBuilder documentBuilder = this.documentBuilderCache.remove(size - 1);
            documentBuilder.setErrorHandler(errorHandler);
            return documentBuilder;
        }
        return this.configuration.createDocumentBuilder(errorHandler);
    }

    public synchronized void releaseDocumentBuilder(DocumentBuilder documentBuilder) {
        if (documentBuilder != null) {
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException exception) throws SAXException {
                }

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void warning(SAXParseException exception) throws SAXException {
                }
            });
            this.documentBuilderCache.add(documentBuilder);
        }
    }

    public synchronized SAXParser getSAXParser(LexicalHandler lexicalHandler) throws ParserConfigurationException, SAXException {
        int size = this.saxParserCache.size();
        if (size > 0) {
            SAXParser saxParser = this.saxParserCache.remove(size - 1);
            saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
            return saxParser;
        }
        return this.configuration.createSAXParser(lexicalHandler);
    }

    public synchronized void releaseSAXParser(SAXParser parser) {
        if (parser != null) {
            try {
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", new LexicalHandler(){

                    public void comment(char[] comment, int start, int length) throws SAXException {
                    }

                    public void endCDATA() throws SAXException {
                    }

                    public void endDTD() throws SAXException {
                    }

                    public void endEntity(String name) throws SAXException {
                    }

                    public void startCDATA() throws SAXException {
                    }

                    public void startDTD(String name, String publicId, String systemId) throws SAXException {
                    }

                    public void startEntity(String name) throws SAXException {
                    }
                });
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
            }
            catch (SAXNotSupportedException sAXNotSupportedException) {}
            this.saxParserCache.add(parser);
        }
    }

    public synchronized Transformer getTransformer(String encoding) throws TransformerException {
        int size = this.transformerCache.size();
        if (size > 0) {
            Transformer transformer = this.transformerCache.remove(size - 1);
            if (encoding != null) {
                transformer.setOutputProperty("encoding", encoding);
            }
            return transformer;
        }
        return this.configuration.createTransformer(encoding);
    }

    public synchronized void releaseTransformer(Transformer transformer) {
        if (transformer != null) {
            this.transformerCache.add(transformer);
        }
    }
}

