/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j;

import java.util.concurrent.ExecutorService;
import org.eclipse.internal.net4j.buffer.BufferProvider;
import org.eclipse.net4j.util.container.IElementProcessor;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.registry.IRegistry;
import org.eclipse.net4j.util.security.INegotiator;
import org.eclipse.spi.net4j.InternalAcceptor;
import org.eclipse.spi.net4j.InternalConnector;

public class Net4jTransportInjector
implements IElementProcessor {
    public static INegotiator serverNegotiator;
    public static INegotiator clientNegotiator;

    public Object process(IManagedContainer container, String productGroup, String factoryType, String description, Object element) {
        if (element instanceof InternalAcceptor) {
            InternalAcceptor acceptor = (InternalAcceptor)element;
            this.processAcceptor(container, factoryType, description, acceptor);
        } else if (element instanceof InternalConnector) {
            InternalConnector connector = (InternalConnector)element;
            this.processConnector(container, factoryType, description, connector);
        }
        return element;
    }

    protected void processAcceptor(IManagedContainer container, String factoryType, String description, InternalAcceptor acceptor) {
        if (acceptor.getBufferProvider() == null) {
            acceptor.setBufferProvider(this.getBufferProvider(container));
        }
        if (acceptor.getReceiveExecutor() == null) {
            acceptor.setReceiveExecutor(this.getExecutorService(container));
        }
        if (acceptor.getProtocolFactoryRegistry() == null) {
            acceptor.setProtocolFactoryRegistry((IRegistry<IFactoryKey, IFactory>)container.getFactoryRegistry());
        }
        if (acceptor.getProtocolPostProcessors() == null) {
            acceptor.setProtocolPostProcessors(container.getPostProcessors());
        }
        if (serverNegotiator != null && acceptor.getNegotiator() == null) {
            acceptor.setNegotiator(serverNegotiator);
        }
    }

    protected void processConnector(IManagedContainer container, String factoryType, String description, InternalConnector connector) {
        if (connector.getBufferProvider() == null) {
            connector.setBufferProvider(this.getBufferProvider(container));
        }
        if (connector.getReceiveExecutor() == null) {
            connector.setReceiveExecutor(this.getExecutorService(container));
        }
        if (connector.getProtocolFactoryRegistry() == null) {
            connector.setProtocolFactoryRegistry((IRegistry<IFactoryKey, IFactory>)container.getFactoryRegistry());
        }
        if (connector.getProtocolPostProcessors() == null) {
            connector.setProtocolPostProcessors(container.getPostProcessors());
        }
        if (clientNegotiator != null && connector.isClient() && connector.getNegotiator() == null) {
            connector.setNegotiator(clientNegotiator);
        }
    }

    protected BufferProvider getBufferProvider(IManagedContainer container) {
        return (BufferProvider)container.getElement("org.eclipse.net4j.bufferProviders", "default", null);
    }

    protected ExecutorService getExecutorService(IManagedContainer container) {
        return (ExecutorService)container.getElement("org.eclipse.net4j.executorServices", "default", null);
    }
}

