/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.importer.java.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.importer.ModelImporter;
import org.eclipse.emf.importer.java.JavaImporter;
import org.eclipse.emf.importer.java.JavaImporterPlugin;
import org.eclipse.emf.importer.ui.contribution.base.ModelPackagePage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class JavaPackagePage
extends ModelPackagePage {
    public JavaPackagePage(ModelImporter modelImporter, String pageName) {
        super(modelImporter, pageName);
        this.setDescription(JavaImporterPlugin.INSTANCE.getString("_UI_PackageSelection_description"));
    }

    public JavaImporter getJavaImporter() {
        return (JavaImporter)this.getModelImporter();
    }

    protected void pageActivated(final boolean firstTime, int cause) {
        if (this.getJavaImporter().canImport()) {
            this.setErrorMessage(null);
            this.getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    JavaPackagePage.this.computeEPackages();
                    JavaPackagePage.this.filterPackagesTable(firstTime);
                    JavaPackagePage.this.getContainer().updateButtons();
                }
            });
        } else {
            this.setErrorMessage(JavaImporterPlugin.INSTANCE.getString("_UI_JavaProjectRequired_message"));
            this.setPageComplete(false);
        }
    }

    protected void computeEPackages() {
        WorkspaceModifyOperation initializeOperation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor progressMonitor) throws CoreException {
                try {
                    try {
                        JavaPackagePage.this.computeEPackages(progressMonitor);
                    }
                    catch (Exception e) {
                        JavaImporterPlugin.INSTANCE.log(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    progressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                progressMonitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)initializeOperation);
        }
        catch (Exception exception) {
            JavaImporterPlugin.INSTANCE.log(exception);
        }
    }

    protected void computeEPackages(IProgressMonitor progressMonitor) throws Exception {
        IStatus status = this.getJavaImporter().computeEPackages(progressMonitor);
        this.getJavaImporter().adjustEPackages(progressMonitor);
        String message = JavaImporterPlugin.INSTANCE.getString("_UI_ProblemsEncounteredProcessingJava_message");
        this.handleStatus(status, message, JavaImporterPlugin.INSTANCE.getString("_UI_LoadProblem_title"), message);
    }
}

