/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import java.util.concurrent.ExecutionException;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDTemp;
import org.eclipse.emf.cdo.common.io.CDODataInput;
import org.eclipse.emf.cdo.common.io.CDODataOutput;
import org.eclipse.emf.cdo.internal.server.XATransactionCommitContext;
import org.eclipse.emf.cdo.internal.server.bundle.OM;
import org.eclipse.emf.cdo.internal.server.protocol.CDOServerProtocol;
import org.eclipse.emf.cdo.internal.server.protocol.CommitTransactionIndication;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class CommitTransactionPhase2Indication
extends CommitTransactionIndication {
    private static final ContextTracer PROTOCOL = new ContextTracer(OM.DEBUG_PROTOCOL, CommitTransactionPhase2Indication.class);

    public CommitTransactionPhase2Indication(CDOServerProtocol protocol) {
        super(protocol, (short)14);
    }

    protected void indicating(CDODataInput in, OMMonitor monitor) throws Exception {
        this.indicatingTransaction(in);
        XATransactionCommitContext xaContextContext = (XATransactionCommitContext)this.commitContext;
        int size = in.readInt();
        if (PROTOCOL.isEnabled()) {
            PROTOCOL.format("Receiving {0} mapping informations", new Object[]{size});
        }
        int i = 0;
        while (i < size) {
            CDOIDTemp oldID = (CDOIDTemp)in.readCDOID();
            CDOID newID = in.readCDOID();
            xaContextContext.addIDMapping(oldID, newID);
            ++i;
        }
        xaContextContext.getState().set((Object)XATransactionCommitContext.CommitState.APPLY_ID_MAPPING_DONE);
    }

    protected void responding(CDODataOutput out, OMMonitor monitor) throws Exception {
        String exceptionMessage = null;
        try {
            this.getRepository().getCommitManager().waitForTermination(this.commitContext.getTransaction());
        }
        catch (InterruptedException ex) {
            exceptionMessage = ex.getMessage();
        }
        catch (ExecutionException ex) {
            exceptionMessage = ex.getMessage();
        }
        if (exceptionMessage == null) {
            exceptionMessage = this.commitContext.getRollbackMessage();
        }
        this.respondingException(out, exceptionMessage);
    }

    protected void indicatingTransaction(CDODataInput in) throws Exception {
        int viewID = in.readInt();
        this.commitContext = this.getRepository().getCommitManager().get(this.getTransaction(viewID));
    }
}

