/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server.protocol;

import org.eclipse.emf.cdo.internal.common.protocol.CDOProtocolImpl;
import org.eclipse.emf.cdo.internal.server.protocol.ChangeSubscriptionIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CommitTransactionCancelIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CommitTransactionIndication;
import org.eclipse.emf.cdo.internal.server.protocol.CommitTransactionPhase1Indication;
import org.eclipse.emf.cdo.internal.server.protocol.CommitTransactionPhase2Indication;
import org.eclipse.emf.cdo.internal.server.protocol.CommitTransactionPhase3Indication;
import org.eclipse.emf.cdo.internal.server.protocol.GetRemoteSessionsIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LoadChunkIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LoadLibrariesIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LoadPackagesIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LoadRevisionByTimeIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LoadRevisionByVersionIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LoadRevisionIndication;
import org.eclipse.emf.cdo.internal.server.protocol.LockObjectsIndication;
import org.eclipse.emf.cdo.internal.server.protocol.ObjectLockedIndication;
import org.eclipse.emf.cdo.internal.server.protocol.OpenSessionIndication;
import org.eclipse.emf.cdo.internal.server.protocol.QueryCancelIndication;
import org.eclipse.emf.cdo.internal.server.protocol.QueryIndication;
import org.eclipse.emf.cdo.internal.server.protocol.RepositoryTimeIndication;
import org.eclipse.emf.cdo.internal.server.protocol.ResourceIDIndication;
import org.eclipse.emf.cdo.internal.server.protocol.SetAuditIndication;
import org.eclipse.emf.cdo.internal.server.protocol.SetPassiveUpdateIndication;
import org.eclipse.emf.cdo.internal.server.protocol.SyncRevisionsIndication;
import org.eclipse.emf.cdo.internal.server.protocol.UnlockObjectsIndication;
import org.eclipse.emf.cdo.internal.server.protocol.UnsubscribeRemoteSessionsIndication;
import org.eclipse.emf.cdo.internal.server.protocol.VerifyRevisionIndication;
import org.eclipse.emf.cdo.internal.server.protocol.ViewsChangedIndication;
import org.eclipse.emf.cdo.server.IRepositoryProvider;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.io.StringIO;

public class CDOServerProtocol
extends CDOProtocolImpl {
    private IRepositoryProvider repositoryProvider;
    private StringIO packageURICompressor = new StringCompressor(false);

    public CDOServerProtocol(IRepositoryProvider repositoryProvider) {
        this.repositoryProvider = repositoryProvider;
    }

    public IRepositoryProvider getRepositoryProvider() {
        return this.repositoryProvider;
    }

    public StringIO getPackageURICompressor() {
        return this.packageURICompressor;
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 1: {
                return new OpenSessionIndication(this);
            }
            case 3: {
                return new LoadLibrariesIndication(this);
            }
            case 4: {
                return new ViewsChangedIndication(this);
            }
            case 5: {
                return new ResourceIDIndication(this);
            }
            case 6: {
                return new LoadPackagesIndication(this);
            }
            case 7: {
                return new LoadRevisionIndication(this);
            }
            case 8: {
                return new LoadRevisionByTimeIndication(this);
            }
            case 9: {
                return new LoadRevisionByVersionIndication(this);
            }
            case 10: {
                return new LoadChunkIndication(this);
            }
            case 11: {
                return new VerifyRevisionIndication(this);
            }
            case 12: {
                return new CommitTransactionIndication(this);
            }
            case 13: {
                return new CommitTransactionPhase1Indication(this);
            }
            case 14: {
                return new CommitTransactionPhase2Indication(this);
            }
            case 15: {
                return new CommitTransactionPhase3Indication(this);
            }
            case 16: {
                return new CommitTransactionCancelIndication(this);
            }
            case 18: {
                return new QueryIndication(this);
            }
            case 19: {
                return new QueryCancelIndication(this);
            }
            case 20: {
                return new SyncRevisionsIndication(this);
            }
            case 21: {
                return new SetPassiveUpdateIndication(this);
            }
            case 22: {
                return new ChangeSubscriptionIndication(this);
            }
            case 23: {
                return new SetAuditIndication(this);
            }
            case 24: {
                return new RepositoryTimeIndication(this);
            }
            case 25: {
                return new LockObjectsIndication(this);
            }
            case 26: {
                return new UnlockObjectsIndication(this);
            }
            case 27: {
                return new ObjectLockedIndication(this);
            }
            case 28: {
                return new GetRemoteSessionsIndication(this);
            }
            case 29: {
                return new UnsubscribeRemoteSessionsIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }
}

