/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.hibernate;

import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateCommitContext;
import org.eclipse.emf.cdo.server.internal.hibernate.HibernateStoreAccessor;
import org.eclipse.emf.cdo.server.internal.hibernate.bundle.OM;
import org.eclipse.net4j.util.om.trace.ContextTracer;

public class HibernateThreadContext {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG, HibernateThreadContext.class);
    private static ThreadLocal<HibernateCommitContext> commitContext = new ThreadLocal();
    private static ThreadLocal<HibernateStoreAccessor> accessor = new ThreadLocal();

    public static HibernateStoreAccessor getCurrentHibernateStoreAccessor() {
        return accessor.get();
    }

    public static void setCurrentHibernateStoreAccessor(HibernateStoreAccessor hbStoreAccessor) {
        accessor.set(hbStoreAccessor);
    }

    public static HibernateCommitContext getHibernateCommitContext() {
        HibernateCommitContext result = commitContext.get();
        if (result == null) {
            throw new IllegalStateException("CommitContext not set");
        }
        return result;
    }

    public static boolean isHibernateCommitContextSet() {
        return commitContext.get() != null;
    }

    public static void setCommitContext(IStoreAccessor.CommitContext newCommitContext) {
        if (newCommitContext != null && commitContext.get() != null) {
            throw new IllegalStateException("CommitContext already set");
        }
        if (TRACER.isEnabled()) {
            if (newCommitContext == null) {
                TRACER.trace("Clearing commitcontext in threadlocal");
            } else {
                TRACER.trace("Setting commitcontext in threadlocal");
            }
        }
        if (newCommitContext == null) {
            commitContext.set(null);
        } else {
            HibernateCommitContext hcc = new HibernateCommitContext();
            hcc.setCommitContext(newCommitContext);
            commitContext.set(hcc);
        }
    }
}

