/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.general.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditor;
import org.eclipse.emf.validation.examples.general.actions.LiveValidationContentAdapter;
import org.eclipse.emf.validation.examples.general.internal.l10n.ValidationMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class EnableLiveValidationDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    protected static final String MESSAGE_EXCEPTION = ValidationMessages.message_exception;
    protected Shell shell = null;
    protected EXTLibraryEditor editor = null;
    protected Collection<Resource> selectedResources = null;
    String title = ValidationMessages.EnableLiveValidationDelegate_title;

    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedResources = null;
        action.setEnabled(false);
        try {
            try {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    List selectedHunh = structuredSelection.toList();
                    for (Object next : selectedHunh) {
                        if (!(next instanceof Resource)) {
                            action.setEnabled(false);
                            break;
                        }
                        if (this.resourceHasAdapter((Resource)next)) {
                            action.setEnabled(false);
                            break;
                        }
                        action.setEnabled(true);
                    }
                    this.selectedResources = action.isEnabled() ? selectedHunh : null;
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            action.setEnabled(this.selectedResources != null);
            throw throwable;
        }
        action.setEnabled(this.selectedResources != null);
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (EXTLibraryEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        for (Resource r : this.selectedResources) {
            if (this.resourceHasAdapter(r)) continue;
            LiveValidationContentAdapter liveValidationContentAdapter = new LiveValidationContentAdapter(this);
            r.eAdapters().add((Object)liveValidationContentAdapter);
        }
    }

    private boolean resourceHasAdapter(Resource r) {
        for (Adapter next : r.eAdapters()) {
            if (!(next instanceof LiveValidationContentAdapter)) continue;
            return true;
        }
        return false;
    }
}

