/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.engine.check;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.engine.check.AbstractCheck;
import org.eclipse.emf.compare.diff.metamodel.AttributeChange;
import org.eclipse.emf.compare.diff.metamodel.ConflictingDiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffGroup;
import org.eclipse.emf.compare.diff.metamodel.UpdateAttribute;
import org.eclipse.emf.compare.match.metamodel.Match2Elements;
import org.eclipse.emf.compare.match.metamodel.Match3Elements;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesCheck
extends AbstractCheck {
    public AttributesCheck(EcoreUtil.CrossReferencer referencer) {
        super(referencer);
    }

    public void checkAttributesUpdates(DiffGroup root, Match2Elements mapping) throws FactoryException {
        EClass eClass = mapping.getLeftElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next)) continue;
            this.checkAttributeUpdates(root, mapping, next);
        }
    }

    public void checkAttributesUpdates(DiffGroup root, Match3Elements mapping) throws FactoryException {
        if (mapping.getOriginElement() == null) {
            return;
        }
        EClass eClass = mapping.getOriginElement().eClass();
        EList eclassAttributes = eClass.getEAllAttributes();
        for (EAttribute next : eclassAttributes) {
            if (this.shouldBeIgnored(next)) continue;
            this.checkAttributeUpdates(root, mapping, next);
        }
    }

    protected boolean areDistinctValues(Object left, Object right) {
        boolean distinct;
        if (left instanceof EEnumLiteral && right instanceof EEnumLiteral) {
            StringBuilder value1 = new StringBuilder();
            value1.append(((EEnumLiteral)left).getLiteral()).append(((EEnumLiteral)left).getValue());
            StringBuilder value2 = new StringBuilder();
            value2.append(((EEnumLiteral)right).getLiteral()).append(((EEnumLiteral)right).getValue());
            distinct = !value1.toString().equals(value2.toString());
        } else {
            distinct = left instanceof EObject && right instanceof EObject ? left != this.getMatchedEObject((EObject)right) : left != null && !left.equals(right) || left == null && left != right;
        }
        return distinct;
    }

    protected final boolean attributeListContains(List<Object> values, Object value) {
        for (Object aValue : values) {
            if (this.areDistinctValues(aValue, value)) continue;
            return true;
        }
        return false;
    }

    protected void checkAttributeUpdates(DiffGroup root, Match2Elements mapping, EAttribute attribute) throws FactoryException {
        String attributeName = attribute.getName();
        boolean distinct = false;
        if (attribute.isMany()) {
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attributeName));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attributeName));
            if (leftValue.size() != rightValue.size()) {
                distinct = true;
            } else {
                for (Object left : leftValue) {
                    boolean bl = distinct = !this.attributeListContains(rightValue, left);
                    if (distinct) break;
                }
                for (Object right : rightValue) {
                    boolean bl = distinct = !this.attributeListContains(leftValue, right);
                    if (!distinct) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            Object leftValue = EFactory.eGet((EObject)mapping.getLeftElement(), (String)attributeName);
            Object rightValue = EFactory.eGet((EObject)mapping.getRightElement(), (String)attributeName);
            distinct = this.areDistinctValues(leftValue, rightValue);
        }
        if (distinct) {
            this.createNonConflictingAttributeChange(root, attribute, mapping.getLeftElement(), mapping.getRightElement());
        }
    }

    protected void checkAttributeUpdates(DiffGroup root, Match3Elements mapping, EAttribute attribute) throws FactoryException {
        String attributeName = attribute.getName();
        boolean rightDistinctFromOrigin = false;
        boolean rightDistinctFromLeft = false;
        boolean leftDistinctFromOrigin = false;
        if (attribute.isMany()) {
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attributeName));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attributeName));
            List<Object> ancestorValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)attributeName));
            for (Object right : rightValue) {
                boolean bl = rightDistinctFromOrigin = !this.attributeListContains(ancestorValue, right);
                if (rightDistinctFromOrigin) break;
            }
            for (Object right : rightValue) {
                boolean bl = rightDistinctFromLeft = !this.attributeListContains(leftValue, right);
                if (rightDistinctFromLeft) break;
            }
            for (Object left : leftValue) {
                boolean bl = leftDistinctFromOrigin = !this.attributeListContains(ancestorValue, left);
                if (!leftDistinctFromOrigin) {
                    continue;
                }
                break;
            }
        } else {
            Object leftValue = EFactory.eGet((EObject)mapping.getLeftElement(), (String)attributeName);
            Object rightValue = EFactory.eGet((EObject)mapping.getRightElement(), (String)attributeName);
            Object ancestorValue = EFactory.eGet((EObject)mapping.getOriginElement(), (String)attributeName);
            rightDistinctFromOrigin = this.areDistinctValues(rightValue, ancestorValue);
            rightDistinctFromLeft = this.areDistinctValues(rightValue, leftValue);
            leftDistinctFromOrigin = this.areDistinctValues(leftValue, ancestorValue);
        }
        if (leftDistinctFromOrigin && !rightDistinctFromOrigin) {
            this.createNonConflictingAttributeChange(root, attribute, mapping.getLeftElement(), mapping.getRightElement());
        } else if (rightDistinctFromOrigin && !leftDistinctFromOrigin) {
            this.createRemoteAttributeChange(root, attribute, mapping);
        } else if (rightDistinctFromOrigin && leftDistinctFromOrigin || rightDistinctFromLeft) {
            this.checkConflictingAttributesUpdate(root, attribute, mapping);
        }
    }

    protected boolean shouldBeIgnored(EAttribute attribute) {
        boolean ignore = attribute.isTransient();
        ignore = ignore || attribute.isDerived();
        return ignore;
    }

    private void checkConflictingAttributesUpdate(DiffGroup root, EAttribute attribute, Match3Elements mapping) throws FactoryException {
        if (!attribute.isMany()) {
            this.createConflictingAttributeChange(root, attribute, mapping);
        } else {
            AttributeChange operation;
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attribute.getName()));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attribute.getName()));
            List<Object> ancestorValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getOriginElement(), (String)attribute.getName()));
            for (Object aValue : leftValue) {
                if (this.attributeListContains(rightValue, aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAttributeChangeLeftTarget();
                if (ancestorValue.contains(aValue)) {
                    operation.setRemote(true);
                }
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setLeftTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
            for (Object aValue : rightValue) {
                if (this.attributeListContains(leftValue, aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAttributeChangeRightTarget();
                if (ancestorValue.contains(aValue)) {
                    operation.setRemote(true);
                }
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setRightTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
        }
    }

    private void createConflictingAttributeChange(DiffGroup root, EAttribute attribute, Match3Elements mapping) throws FactoryException {
        DiffGroup dummyGroup = DiffFactory.eINSTANCE.createDiffGroup();
        this.createNonConflictingAttributeChange(dummyGroup, attribute, mapping.getLeftElement(), mapping.getRightElement());
        if (dummyGroup.getSubDiffElements().size() > 0) {
            ConflictingDiffElement conflictingDiff = DiffFactory.eINSTANCE.createConflictingDiffElement();
            conflictingDiff.setLeftParent(mapping.getLeftElement());
            conflictingDiff.setRightParent(mapping.getRightElement());
            conflictingDiff.setOriginElement(mapping.getOriginElement());
            for (DiffElement subDiff : new ArrayList<DiffElement>((Collection<DiffElement>)dummyGroup.getSubDiffElements())) {
                conflictingDiff.getSubDiffElements().add((Object)subDiff);
            }
            root.getSubDiffElements().add((Object)conflictingDiff);
        }
    }

    private void createNonConflictingAttributeChange(DiffGroup root, EAttribute attribute, EObject leftElement, EObject rightElement) throws FactoryException {
        if (attribute.isMany()) {
            AttributeChange operation;
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)leftElement, (String)attribute.getName()));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)rightElement, (String)attribute.getName()));
            for (Object aValue : leftValue) {
                if (this.attributeListContains(rightValue, aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAttributeChangeLeftTarget();
                operation.setAttribute(attribute);
                operation.setRightElement(rightElement);
                operation.setLeftElement(leftElement);
                operation.setLeftTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
            for (Object aValue : rightValue) {
                if (this.attributeListContains(leftValue, aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAttributeChangeRightTarget();
                operation.setAttribute(attribute);
                operation.setRightElement(rightElement);
                operation.setLeftElement(leftElement);
                operation.setRightTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
        } else {
            UpdateAttribute operation = DiffFactory.eINSTANCE.createUpdateAttribute();
            operation.setRightElement(rightElement);
            operation.setLeftElement(leftElement);
            operation.setAttribute(attribute);
            root.getSubDiffElements().add((Object)operation);
        }
    }

    private void createRemoteAttributeChange(DiffGroup root, EAttribute attribute, Match3Elements mapping) throws FactoryException {
        if (attribute.isMany()) {
            AttributeChange operation;
            List<Object> leftValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getLeftElement(), (String)attribute.getName()));
            List<Object> rightValue = this.convertFeatureMapList(EFactory.eGetAsList((EObject)mapping.getRightElement(), (String)attribute.getName()));
            for (Object aValue : leftValue) {
                if (this.attributeListContains(rightValue, aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAttributeChangeLeftTarget();
                operation.setRemote(true);
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setLeftTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
            for (Object aValue : rightValue) {
                if (this.attributeListContains(leftValue, aValue)) continue;
                operation = DiffFactory.eINSTANCE.createAttributeChangeRightTarget();
                operation.setRemote(true);
                operation.setAttribute(attribute);
                operation.setRightElement(mapping.getRightElement());
                operation.setLeftElement(mapping.getLeftElement());
                operation.setRightTarget(aValue);
                root.getSubDiffElements().add((Object)operation);
            }
        } else {
            UpdateAttribute operation = DiffFactory.eINSTANCE.createUpdateAttribute();
            operation.setRemote(true);
            operation.setRightElement(mapping.getRightElement());
            operation.setLeftElement(mapping.getLeftElement());
            operation.setAttribute(attribute);
            root.getSubDiffElements().add((Object)operation);
        }
    }
}

