/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.codegen.jet.JETCompileTemplateOperation;
import org.eclipse.emf.codegen.jet.JETNature;
import org.eclipse.emf.codegen.presentation.CodeGenUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileTemplateAction
implements IActionDelegate {
    protected ISelection selection;

    public void run(IAction action) {
        if (action.isEnabled()) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    try {
                        for (IFile file : CompileTemplateAction.this.getSelectedObjects()) {
                            JETNature jetNature = JETNature.getRuntime((IProject)file.getProject());
                            if (jetNature == null) continue;
                            JETCompileTemplateOperation compileTemplate = new JETCompileTemplateOperation(file.getProject(), (Collection)jetNature.getTemplateContainers(), (Collection)Collections.singleton(file));
                            compileTemplate.run(monitor);
                        }
                    }
                    catch (Exception e) {
                        CodeGenUIPlugin.write(e);
                    }
                }
            };
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(CodeGenUIPlugin.getPlugin().getWorkbench().getActiveWorkbenchWindow().getShell());
                dialog.run(false, true, op);
            }
            catch (Exception e) {
                CodeGenUIPlugin.write(e);
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
        this.setActionState(action);
    }

    protected void setActionState(IAction action) {
        action.setEnabled(true);
    }

    protected List<?> getSelectedObjects() {
        return this.selection instanceof IStructuredSelection ? ((IStructuredSelection)this.selection).toList() : Collections.EMPTY_LIST;
    }

    protected boolean isSupportedAction(Object object) {
        return object instanceof IFile && ((IFile)object).isAccessible();
    }
}

