/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.edit.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.ChildrenToCopyProvider;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.AbstractEMFOperation;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.mdht.uml.common.modelfilter.ModelFilterUtil;
import org.eclipse.mdht.uml.common.notation.IExtendedNotationProvider;
import org.eclipse.mdht.uml.common.notation.INotationProvider;
import org.eclipse.mdht.uml.common.notation.NotationRegistry;
import org.eclipse.mdht.uml.common.notation.NotationUtil;
import org.eclipse.mdht.uml.common.util.NamedElementUtil;
import org.eclipse.mdht.uml.common.util.UMLUtil;
import org.eclipse.mdht.uml.edit.IUMLTableProperties;
import org.eclipse.mdht.uml.edit.command.CommandWrapperWithChildrenToCopy;
import org.eclipse.mdht.uml.edit.internal.Logger;
import org.eclipse.mdht.uml.edit.internal.UMLExtEditPlugin;
import org.eclipse.mdht.uml.edit.provider.PropertyExtItemProvider;
import org.eclipse.mdht.uml.edit.provider.UML2ExtendedAdapterFactory;
import org.eclipse.mdht.uml.edit.provider.operations.NamedElementOperations;
import org.eclipse.uml2.uml.AggregationKind;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.VisibilityKind;
import org.eclipse.uml2.uml.edit.providers.AssociationItemProvider;

public class AssociationExtItemProvider
extends AssociationItemProvider
implements ITableItemLabelProvider,
ICellModifier {
    public AssociationExtItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Object getImage(Object object) {
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)((Association)object));
        ComposedImage composedImage = (ComposedImage)super.getImage(object);
        if (navigableEnd != null) {
            composedImage = (ComposedImage)this.overlayImage(object, UMLExtEditPlugin.INSTANCE.getImage("full/obj16/Association_navigable"));
            if (ModelFilterUtil.isHidden((NamedElement)navigableEnd)) {
                composedImage.getImages().add(UMLExtEditPlugin.INSTANCE.getImage("full/ovr16/filtered"));
            }
        }
        return composedImage;
    }

    protected String getName(NamedElement namedElement) {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        return adapterFactory instanceof UML2ExtendedAdapterFactory && ((UML2ExtendedAdapterFactory)adapterFactory).isShowBusinessNames() ? NamedElementUtil.getBusinessName((NamedElement)namedElement) : namedElement.getName();
    }

    public String getText(Object object) {
        String label = this.getName((NamedElement)((Association)object));
        if (label == null) {
            StringBuffer labelBuffer = new StringBuffer();
            for (Property end : ((Association)object).getMemberEnds()) {
                if (!end.isNavigable()) continue;
                if (labelBuffer.length() > 0) {
                    labelBuffer.append("_");
                }
                if (end.getName() != null) {
                    labelBuffer.append(this.getName((NamedElement)end));
                    continue;
                }
                if (end.getType() != null) {
                    labelBuffer.append(this.getName((NamedElement)end.getType()));
                    continue;
                }
                labelBuffer.append("NULL");
            }
            label = labelBuffer.toString();
        }
        return label;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        return Collections.emptyList();
    }

    public Object getParent(Object object) {
        Object result;
        Association association = (Association)object;
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)association);
        Class clazz = result = navigableEnd == null ? null : navigableEnd.getClass_();
        if (result == null) {
            result = super.getParent(object);
        }
        return result;
    }

    public Collection<?> getChildren(Object object) {
        Association association = (Association)object;
        ArrayList<Object> children = new ArrayList<Object>();
        children.addAll((Collection<Object>)association.getOwnedComments());
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)association);
        EReference navigableEndRef = UMLPackage.Literals.ASSOCIATION__END_TYPE;
        if (navigableEnd != null && navigableEnd.getType() instanceof Class) {
            Class endType = (Class)navigableEnd.getType();
            for (Property property : endType.getOwnedAttributes()) {
                if (property.getAssociation() != null) continue;
                children.add(this.wrap((EObject)association, (EStructuralFeature)navigableEndRef, property, -1));
            }
            for (Property property : endType.getOwnedAttributes()) {
                if (property.getAssociation() == null || property.getOtherEnd() == null || property.getOtherEnd().getType() != endType) continue;
                children.add(this.wrap((EObject)association, (EStructuralFeature)navigableEndRef, property.getAssociation(), -1));
            }
            for (Object next : endType.getGeneralizations()) {
                children.add(this.wrap((EObject)endType, (EStructuralFeature)navigableEndRef, next, -1));
            }
        } else {
            for (Property ownedEnd : association.getOwnedEnds()) {
                children.add(ownedEnd);
            }
        }
        children.addAll((Collection<Object>)association.getOwnedRules());
        return children;
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    public Object getColumnImage(Object object, int columnIndex) {
        Association association = (Association)object;
        if (association.getNearestPackage() == null) {
            return null;
        }
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)association);
        Class endType = null;
        if (navigableEnd != null && navigableEnd.getType() instanceof Class) {
            endType = (Class)navigableEnd.getType();
        }
        switch (columnIndex) {
            case 0: {
                return this.getImage(object);
            }
            case 1: {
                if (endType != null) {
                    IItemLabelProvider provider;
                    Object image = null;
                    INotationProvider notationProvider = NotationRegistry.INSTANCE.getNotationProvider((Element)navigableEnd);
                    if (notationProvider instanceof IExtendedNotationProvider) {
                        image = ((IExtendedNotationProvider)notationProvider).getElementTypeImage((Element)endType);
                    } else if (notationProvider != null) {
                        image = notationProvider.getElementImage((Element)endType);
                    }
                    if (image == null && (provider = (IItemLabelProvider)this.getAdapterFactory().adapt((Notifier)endType, IItemLabelProvider.class)) != null) {
                        image = provider.getImage((Object)endType);
                    }
                    return image;
                }
            }
            case 5: {
                return NotationUtil.getAnnotationImage((Element)association);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Association association = (Association)element;
        if (association.getNearestPackage() == null) {
            return null;
        }
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)association);
        Class endType = null;
        if (navigableEnd != null && navigableEnd.getType() instanceof Class) {
            endType = (Class)navigableEnd.getType();
        }
        switch (columnIndex) {
            case 0: {
                return this.getText(element);
            }
            case 1: {
                return endType == null ? null : endType.getName();
            }
            case 2: {
                return PropertyExtItemProvider.displayColumnMultiplicity((MultiplicityElement)navigableEnd);
            }
            case 4: {
                if (VisibilityKind.PUBLIC_LITERAL == association.getVisibility()) {
                    return "";
                }
                return association.getVisibility().getName();
            }
            case 5: {
                String annotation = NotationUtil.getAnnotation((Element)association);
                if ((annotation == null || annotation.length() == 0) && navigableEnd != null) {
                    annotation = NotationUtil.getAnnotation((Element)navigableEnd);
                }
                return annotation;
            }
            case 6: {
                String text = null;
                if (navigableEnd != null) {
                    text = NotationUtil.getShortDescription((Element)navigableEnd);
                }
                return text == null ? "" : text;
            }
        }
        return null;
    }

    public boolean canModify(Object element, String property) {
        if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
            return true;
        }
        if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
            return true;
        }
        if ("multiplicity".equals(property)) {
            return true;
        }
        return IUMLTableProperties.VISIBILITY_PROPERTY.equals(property);
    }

    public Object getValue(Object element, String property) {
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)((Association)element));
        if (navigableEnd != null) {
            if (IUMLTableProperties.NAME_PROPERTY.equals(property)) {
                return navigableEnd.getName();
            }
            if (IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
                return new Integer(navigableEnd.getVisibility().getValue());
            }
            if (IUMLTableProperties.TYPE_PROPERTY.equals(property)) {
                return navigableEnd.getType();
            }
            if ("multiplicity".equals(property)) {
                return PropertyExtItemProvider.displayColumnMultiplicity((MultiplicityElement)navigableEnd);
            }
        }
        return null;
    }

    public void modify(Object element, final String property, final Object value) {
        Association association = (Association)element;
        final Property navigableEnd = UMLUtil.getNavigableEnd((Association)association);
        if (navigableEnd == null) {
            return;
        }
        if (IUMLTableProperties.NAME_PROPERTY.equals(property) || IUMLTableProperties.VISIBILITY_PROPERTY.equals(property)) {
            NamedElementOperations.modify(navigableEnd, property, value);
            return;
        }
        try {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)navigableEnd);
            AbstractEMFOperation operation = new AbstractEMFOperation(editingDomain, "temp"){

                protected IStatus doExecute(IProgressMonitor monitor, IAdaptable info) {
                    if (IUMLTableProperties.TYPE_PROPERTY.equals(property) && value instanceof Classifier) {
                        this.setLabel("Set Type");
                        navigableEnd.setType((Type)((Classifier)value));
                        Class owner = navigableEnd.getClass_();
                        int position = owner.getOwnedAttributes().lastIndexOf((Object)navigableEnd);
                        owner.getOwnedAttributes().remove((Object)navigableEnd);
                        owner.getOwnedAttributes().add(position, (Object)navigableEnd);
                    } else if (IUMLTableProperties.AGGREGATION_PROPERTY.equals(property) && value instanceof Integer) {
                        this.setLabel("Set Aggregation");
                        navigableEnd.setAggregation(AggregationKind.get((int)((Integer)value)));
                    } else if ("multiplicity".equals(property) && value instanceof String) {
                        this.setLabel("Set Multiplicity");
                        PropertyExtItemProvider.setMultiplicity((MultiplicityElement)navigableEnd, value.toString());
                    } else {
                        return Status.CANCEL_STATUS;
                    }
                    return Status.OK_STATUS;
                }
            };
            try {
                IWorkspaceCommandStack commandStack = (IWorkspaceCommandStack)editingDomain.getCommandStack();
                operation.addContext(commandStack.getDefaultUndoContext());
                commandStack.getOperationHistory().execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException ee) {
                Logger.logException(ee);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getCause());
        }
    }

    protected Command createCreateCopyCommand(EditingDomain domain, EObject owner, CopyCommand.Helper helper) {
        Property navigableEnd = UMLUtil.getNavigableEnd((Association)((Association)owner));
        Object result = super.createCreateCopyCommand(domain, owner, helper);
        if (navigableEnd != null) {
            class CompoundWithChildrenToCopy
            extends CompoundCommand
            implements ChildrenToCopyProvider {
                CompoundWithChildrenToCopy() {
                    super(Integer.MAX_VALUE);
                }

                public Collection<?> getChildrenToCopy() {
                    ArrayList result = new ArrayList();
                    for (Command next : this.commandList) {
                        if (!(next instanceof ChildrenToCopyProvider)) continue;
                        result.addAll(((ChildrenToCopyProvider)next).getChildrenToCopy());
                    }
                    return result;
                }
            }
            CompoundWithChildrenToCopy compound = new CompoundWithChildrenToCopy();
            compound.append((Command)result);
            result = compound;
            compound.append(CreateCopyCommand.create((EditingDomain)domain, (Object)navigableEnd, (CopyCommand.Helper)helper));
        }
        return result;
    }

    protected Command wrapCommand(Command command, Object object, java.lang.Class<? extends Command> commandClass, CommandParameter commandParameter, CommandParameter oldCommandParameter) {
        Object result = super.wrapCommand(command, object, commandClass, commandParameter, oldCommandParameter);
        if (result != command && command instanceof ChildrenToCopyProvider) {
            result = new CommandWrapperWithChildrenToCopy((Command)result, (ChildrenToCopyProvider)command);
        }
        return result;
    }
}

