/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.cda.xml.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.AnalyzeCDAHandler;
import org.eclipse.mdht.cda.xml.ui.handlers.CDAValueUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.EncounterUtil;
import org.eclipse.mdht.cda.xml.ui.handlers.GenerateCDADataHandler;
import org.eclipse.mdht.cda.xml.ui.handlers.MatchEncounterBy;
import org.eclipse.mdht.uml.cda.Act;
import org.eclipse.mdht.uml.cda.AssignedAuthor;
import org.eclipse.mdht.uml.cda.Author;
import org.eclipse.mdht.uml.cda.CDAFactory;
import org.eclipse.mdht.uml.cda.ClinicalDocument;
import org.eclipse.mdht.uml.cda.Consumable;
import org.eclipse.mdht.uml.cda.DocumentationOf;
import org.eclipse.mdht.uml.cda.Encounter;
import org.eclipse.mdht.uml.cda.InFulfillmentOf;
import org.eclipse.mdht.uml.cda.InformationRecipient;
import org.eclipse.mdht.uml.cda.LanguageCommunication;
import org.eclipse.mdht.uml.cda.ManufacturedProduct;
import org.eclipse.mdht.uml.cda.Observation;
import org.eclipse.mdht.uml.cda.Organization;
import org.eclipse.mdht.uml.cda.Organizer;
import org.eclipse.mdht.uml.cda.Participant1;
import org.eclipse.mdht.uml.cda.Participant2;
import org.eclipse.mdht.uml.cda.Patient;
import org.eclipse.mdht.uml.cda.PatientRole;
import org.eclipse.mdht.uml.cda.Performer1;
import org.eclipse.mdht.uml.cda.Performer2;
import org.eclipse.mdht.uml.cda.Procedure;
import org.eclipse.mdht.uml.cda.ReferenceRange;
import org.eclipse.mdht.uml.cda.Section;
import org.eclipse.mdht.uml.cda.ServiceEvent;
import org.eclipse.mdht.uml.cda.Specimen;
import org.eclipse.mdht.uml.cda.StrucDocText;
import org.eclipse.mdht.uml.cda.SubstanceAdministration;
import org.eclipse.mdht.uml.cda.Supply;
import org.eclipse.mdht.uml.cda.ui.editors.MDHTPreferences;
import org.eclipse.mdht.uml.cda.ui.internal.Activator;
import org.eclipse.mdht.uml.cda.util.CDAUtil;
import org.eclipse.mdht.uml.cda.util.ValidationResult;
import org.eclipse.mdht.uml.hl7.datatypes.AD;
import org.eclipse.mdht.uml.hl7.datatypes.ADXP;
import org.eclipse.mdht.uml.hl7.datatypes.ANY;
import org.eclipse.mdht.uml.hl7.datatypes.CD;
import org.eclipse.mdht.uml.hl7.datatypes.CE;
import org.eclipse.mdht.uml.hl7.datatypes.ED;
import org.eclipse.mdht.uml.hl7.datatypes.EN;
import org.eclipse.mdht.uml.hl7.datatypes.II;
import org.eclipse.mdht.uml.hl7.datatypes.IVL_TS;
import org.eclipse.mdht.uml.hl7.datatypes.ON;
import org.eclipse.mdht.uml.hl7.datatypes.PN;
import org.eclipse.mdht.uml.hl7.datatypes.ST;
import org.eclipse.mdht.uml.hl7.datatypes.SXCM_TS;
import org.eclipse.mdht.uml.hl7.datatypes.TEL;
import org.openhealthtools.mdht.uml.cda.consol.CoverageActivity;
import org.openhealthtools.mdht.uml.cda.consol.GeneralHeaderConstraints;
import org.openhealthtools.mdht.uml.cda.consol.NoteActivity;
import org.openhealthtools.mdht.uml.cda.consol.PolicyActivity;

public class SpreadsheetSerializer {
    public static boolean processNarrative = true;
    public static int narrativeSize = 0;

    public static void appendToDemographicsSheet(CDAUtil.Query query, SXSSFSheet sheet, CDAValueUtil.DocumentMetadata documentMetadata, PatientRole patientRole, List<Participant1> participant) {
        SXSSFRow row = sheet.createRow(sheet.getPhysicalNumberOfRows());
        int offset = SpreadsheetSerializer.serializePatient2((Row)row, 0, documentMetadata, patientRole, participant, (Sheet)sheet);
        SpreadsheetSerializer.serializeSectionAndFileName((Row)row, offset, null, documentMetadata.completePath);
    }

    public static void appendToEncounterSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata documentMetadata, PatientRole patientRole, ServiceEvent serviceEvent, EList<Organizer> organizers, List<Encounter> encounters, String fileName) {
        for (Encounter encounter : encounters) {
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            int offset = SpreadsheetSerializer.serializePatient(row, 0, documentMetadata, patientRole);
            offset = SpreadsheetSerializer.serializeEncounter(row, offset, encounter);
            offset = SpreadsheetSerializer.serializeSectionAndFileName(row, offset, encounter.getSection(), documentMetadata.completePath);
            offset = SpreadsheetSerializer.appendValidation(row, offset, (EObject)encounter);
        }
    }

    public static int serializeStrucDocText(Row row, int offset, StrucDocText text) {
        if (processNarrative && text != null && !StringUtils.isEmpty((String)text.getText())) {
            String narrative = text.getText();
            if (narrativeSize != 0) {
                narrative = narrative.substring(0, narrativeSize);
            }
            row.createCell(offset++).setCellValue(StringUtils.left((String)StringUtils.trim((String)narrative), (int)500));
        } else {
            row.createCell(offset++).setCellValue(processNarrative ? "OMMITTED" : "No Narrative");
        }
        return offset;
    }

    public static int serializeClinicalStatement(Row row, int offset, Act act) {
        StringBuffer sb = new StringBuffer();
        for (II ii : act.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(act.getEffectiveTime()));
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)act.getEffectiveTime()));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendCode(row, offset, act.getSection(), act.getCode(), act.getText());
        String organizationValue = "";
        String personValue = "";
        for (Performer2 performer : act.getPerformers()) {
            if (performer.getAssignedEntity() == null) continue;
            for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                for (ON on : organization.getNames()) {
                    organizationValue = String.valueOf(organizationValue) + CDAValueUtil.getValues((EN)on);
                }
            }
            if (performer.getAssignedEntity().getAssignedPerson() == null) continue;
            for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                personValue = CDAValueUtil.getValues((EN)pn);
            }
        }
        row.createCell(offset++).setCellValue(personValue);
        row.createCell(offset++).setCellValue(organizationValue);
        return offset;
    }

    public static int serializeClinicalStatement(Row row, int offset, Observation observation) {
        StringBuffer sb = new StringBuffer();
        for (II ii : observation.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(observation.getEffectiveTime()));
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)observation.getEffectiveTime()));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendCode(row, offset, observation.getSection(), observation.getCode(), observation.getText());
        String organizationValue = "";
        String personValue = "";
        for (Performer2 performer : observation.getPerformers()) {
            if (performer.getAssignedEntity() == null) continue;
            for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                for (ON on : organization.getNames()) {
                    organizationValue = String.valueOf(organizationValue) + CDAValueUtil.getValues((EN)on);
                }
            }
            if (performer.getAssignedEntity().getAssignedPerson() == null) continue;
            for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                personValue = CDAValueUtil.getValues((EN)pn);
            }
        }
        row.createCell(offset++).setCellValue(personValue);
        row.createCell(offset++).setCellValue(organizationValue);
        return offset;
    }

    public static int serializeClinicalStatement(Row row, int offset, Organizer organizer) {
        StringBuffer sb = new StringBuffer();
        for (II ii : organizer.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(organizer.getEffectiveTime()));
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)organizer.getEffectiveTime()));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendCode(row, offset, organizer.getSection(), organizer.getCode(), null);
        String organizationValue = "";
        String personValue = "";
        for (Performer2 performer : organizer.getPerformers()) {
            if (performer.getAssignedEntity() == null) continue;
            for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                for (ON on : organization.getNames()) {
                    organizationValue = String.valueOf(organizationValue) + CDAValueUtil.getValues((EN)on);
                }
            }
            if (performer.getAssignedEntity().getAssignedPerson() == null) continue;
            for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                personValue = CDAValueUtil.getValues((EN)pn);
            }
        }
        row.createCell(offset++).setCellValue(personValue);
        row.createCell(offset++).setCellValue(organizationValue);
        return offset;
    }

    public static int serializeClinicalStatement(Row row, int offset, Procedure procedure) {
        StringBuffer sb = new StringBuffer();
        for (II ii : procedure.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(procedure.getEffectiveTime()));
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)procedure.getEffectiveTime()));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendCode(row, offset, procedure.getSection(), procedure.getCode(), procedure.getText());
        String organizationValue = "";
        String personValue = "";
        for (Performer2 performer : procedure.getPerformers()) {
            if (performer.getAssignedEntity() == null) continue;
            for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                for (ON on : organization.getNames()) {
                    organizationValue = String.valueOf(organizationValue) + CDAValueUtil.getValues((EN)on);
                }
            }
            if (performer.getAssignedEntity().getAssignedPerson() == null) continue;
            for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                personValue = CDAValueUtil.getValues((EN)pn);
            }
        }
        row.createCell(offset++).setCellValue(personValue);
        row.createCell(offset++).setCellValue(organizationValue);
        return offset;
    }

    public static int serializeClinicalStatement(Row row, int offset, SubstanceAdministration substanceAdministration) {
        StringBuffer sb = new StringBuffer();
        for (II ii : substanceAdministration.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        String time = "";
        SXCM_TS source = null;
        Iterator iterator = substanceAdministration.getEffectiveTimes().iterator();
        while (iterator.hasNext()) {
            SXCM_TS t;
            source = t = (SXCM_TS)iterator.next();
            if (!StringUtils.isEmpty((String)t.getValue())) {
                time = t.getValue();
            }
            if (!(t instanceof IVL_TS)) continue;
            time = CDAValueUtil.getValueAsString((IVL_TS)t);
        }
        Date d = CDAValueUtil.getDate(time);
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)source));
        } else {
            row.createCell(offset++).setCellValue(time);
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, substanceAdministration.getSection(), substanceAdministration.getCode(), substanceAdministration.getText());
        String organizationValue = "";
        String personValue = "";
        for (Performer2 performer : substanceAdministration.getPerformers()) {
            if (performer.getAssignedEntity() == null) continue;
            for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                for (ON on : organization.getNames()) {
                    organizationValue = String.valueOf(organizationValue) + CDAValueUtil.getValues((EN)on);
                }
            }
            if (performer.getAssignedEntity().getAssignedPerson() == null) continue;
            for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                personValue = CDAValueUtil.getValues((EN)pn);
            }
        }
        row.createCell(offset++).setCellValue(personValue);
        row.createCell(offset++).setCellValue(organizationValue);
        return offset;
    }

    public static int serializeEnounterID(Row row, int offset, Observation observation, List<Encounter> encounters) {
        for (Encounter encounter : encounters) {
            MatchEncounterBy result = EncounterUtil.matchesEncounter(encounter, observation);
            if (result == MatchEncounterBy.NOMATCH) continue;
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, encounter, result);
            return offset;
        }
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset++;
    }

    public static int serializeEnounterID(Row row, int offset, Organizer organizer, List<Encounter> encounters) {
        for (Encounter encounter : encounters) {
            MatchEncounterBy result = EncounterUtil.matchesEncounter(encounter, organizer);
            if (result == MatchEncounterBy.NOMATCH) continue;
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, encounter, result);
            return offset;
        }
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset++;
    }

    public static int serializeEnounterID(Row row, int offset, Procedure procedure, List<Encounter> encounters) {
        for (Encounter encounter : encounters) {
            MatchEncounterBy result = EncounterUtil.matchesEncounter(encounter, procedure);
            if (result == MatchEncounterBy.NOMATCH) continue;
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, encounter, result);
            return offset;
        }
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset++;
    }

    public static int serializeEnounterID(Row row, int offset, SubstanceAdministration substanceAdministration, List<Encounter> encounters) {
        for (Encounter encounter : encounters) {
            MatchEncounterBy result = EncounterUtil.matchesEncounter(encounter, substanceAdministration);
            if (result == MatchEncounterBy.NOMATCH) continue;
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, encounter, result);
            return offset;
        }
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset++;
    }

    public static int serializeEnounterID(Row row, int offset, Supply supply, List<Encounter> encounters) {
        for (Encounter encounter : encounters) {
            MatchEncounterBy result = EncounterUtil.matchesEncounter(encounter, supply);
            if (result == MatchEncounterBy.NOMATCH) continue;
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, encounter, result);
            return offset;
        }
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset++;
    }

    public static int serializeProblemObservationClinicalStatement(Row row, int offset, Observation problemObservation, boolean checkForNotes) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        for (II ii : problemObservation.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        sb = new StringBuffer();
        IVL_TS ivlts = problemObservation.getEffectiveTime();
        if (ivlts != null) {
            Date d;
            if (ivlts.getValue() != null && !StringUtils.isEmpty((String)ivlts.getValue())) {
                d = CDAValueUtil.getDate(ivlts.getValue());
                sb.append(CDAValueUtil.DATE_PRETTY.format(d));
            }
            if (ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                d = CDAValueUtil.getDate(ivlts.getLow().getValue());
                if (d != null) {
                    sb.append(CDAValueUtil.DATE_PRETTY.format(d));
                } else {
                    sb.append(ivlts.getLow().getValue());
                }
            }
            if (ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                d = CDAValueUtil.getDate(ivlts.getHigh().getValue());
                if (d != null) {
                    if (sb.length() > 0) {
                        sb.append(" - ");
                    }
                    sb.append(CDAValueUtil.DATE_PRETTY.format(d));
                } else {
                    sb.append(ivlts.getHigh().getValue());
                }
            }
        }
        cell.setCellValue(sb.toString());
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivlts));
        CD problemCode = null;
        for (ANY any : problemObservation.getValues()) {
            if (!(any instanceof CD)) continue;
            problemCode = (CD)any;
        }
        offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, problemObservation.getSection(), problemCode, problemObservation.getText(), true) : SpreadsheetSerializer.appendCode(row, offset, problemObservation.getSection(), problemCode, problemObservation.getText());
        if (checkForNotes) {
            boolean hasNotes = false;
            Act note = null;
            for (Act act : problemObservation.getActs()) {
                if (!(act instanceof NoteActivity)) continue;
                hasNotes = true;
                note = act;
            }
            if (hasNotes) {
                row.createCell(offset++).setCellValue(hasNotes);
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
            } else {
                row.createCell(offset++).setCellValue(false);
                row.createCell(offset++).setCellValue("");
            }
        }
        offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)problemObservation.getAuthors());
        return offset;
    }

    public static int serializeSupply(Row row, int offset, Supply supply) {
        StringBuffer sb = new StringBuffer();
        for (II ii : supply.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        offset = SpreadsheetSerializer.appendCode(row, offset, supply.getSection(), supply.getCode(), supply.getText());
        if (supply.getStatusCode() != null && !StringUtils.isEmpty((String)supply.getStatusCode().getCode())) {
            row.createCell(offset++).setCellValue(supply.getStatusCode().getCode());
        } else {
            row.createCell(offset++).setCellValue("Missing Status");
        }
        SXCM_TS source = null;
        String time = "";
        Iterator iterator = supply.getEffectiveTimes().iterator();
        while (iterator.hasNext()) {
            SXCM_TS t;
            source = t = (SXCM_TS)iterator.next();
            if (!StringUtils.isEmpty((String)t.getValue())) {
                time = t.getValue();
            }
            if (!(t instanceof IVL_TS)) continue;
            time = CDAValueUtil.getValueAsString((IVL_TS)t);
        }
        Date d = CDAValueUtil.getDate(time);
        if (d != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)source));
        } else {
            row.createCell(offset++).setCellValue(time);
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)supply.getAuthors());
        return offset;
    }

    static int appendCode(Row row, int offset, Section section, CD cd, ED ed) {
        if (cd != null) {
            ED theED;
            ED eD = theED = cd.getOriginalText() != null ? cd.getOriginalText() : ed;
            if (section != null || ed != null) {
                row.createCell(offset++).setCellValue(CDAValueUtil.getValue(section, theED));
            } else {
                row.createCell(offset++).setCellValue(CDAValueUtil.getValueAsString(section, cd));
            }
            row.createCell(offset++).setCellValue(CDAValueUtil.getValueAsString(section, cd));
            row.createCell(offset++).setCellValue(cd.getCode());
            row.createCell(offset++).setCellValue(cd.getCodeSystem());
            row.createCell(offset++).setCellValue(cd.getCodeSystemName());
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)cd));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        return offset;
    }

    static int appendAddr(Row row, int offset, AD ad) {
        if (ad != null) {
            row.createCell(offset++).setCellValue(CDAValueUtil.getValues((List<ADXP>)ad.getStreetAddressLines()));
            row.createCell(offset++).setCellValue(CDAValueUtil.getValues((List<ADXP>)ad.getCities()));
            row.createCell(offset++).setCellValue(CDAValueUtil.getValues((List<ADXP>)ad.getStates()));
            row.createCell(offset++).setCellValue(CDAValueUtil.getValues((List<ADXP>)ad.getPostalCodes()));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        return offset;
    }

    static int appendOrganizationAndAuthor(Row row, int offset, EList<Author> authors) {
        String organization = CDAValueUtil.getValue(authors, GenerateCDADataHandler.PorO.ORGANIZATION);
        String person = CDAValueUtil.getValue(authors, GenerateCDADataHandler.PorO.PERSON);
        row.createCell(offset++).setCellValue(organization);
        row.createCell(offset++).setCellValue(person);
        return offset;
    }

    static void appendProcedureToProcedureSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, EList<Procedure> procedureActivityProcedures, List<Encounter> encounters, String fileName) {
        for (Procedure sa : procedureActivityProcedures) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, sa, encounters);
            offset = SpreadsheetSerializer.serializeProcedureActivityProcedure(row, offset, sa, true);
            offset = SpreadsheetSerializer.serializeSectionAndFileName(row, offset, sa.getSection(), organizationAndSoftware.completePath);
            offset = SpreadsheetSerializer.appendValidation(row, offset, (EObject)sa);
        }
    }

    static void appendToEncounterSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, List<Encounter> encounters, String fileName) {
        for (Encounter encoutner : encounters) {
            if (encoutner.getEffectiveTime() == null) continue;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            int offset = SpreadsheetSerializer.serializePatient(row, 0, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEncounter(row, offset, encoutner);
            SpreadsheetSerializer.serializeSectionAndFileName(row, offset, encoutner.getSection(), organizationAndSoftware.completePath);
            offset = SpreadsheetSerializer.appendValidation(row, offset, (EObject)encoutner);
        }
    }

    static CDAValueUtil.DocumentMetadata appendToPatientSheet(CDAUtil.Query query, Sheet sheet, PatientRole patientRole, InformationRecipient ir, InFulfillmentOf iffo, IFile theFile) {
        PN pn;
        Iterator iterator;
        String fileName = theFile.getName();
        CDAValueUtil.DocumentMetadata documentMetadata = new CDAValueUtil.DocumentMetadata();
        ClinicalDocument cd = (ClinicalDocument)query.getEObject(ClinicalDocument.class);
        documentMetadata.documentRootID = CDAValueUtil.getAnyValue(null, (ANY)cd.getId());
        EClass eClass = cd.eClass();
        if (cd.getEffectiveTime() != null && !StringUtils.isEmpty((String)cd.getEffectiveTime().getValue())) {
            documentMetadata.documentDate = CDAValueUtil.getDate(cd.getEffectiveTime().getValue());
        }
        documentMetadata.documentLibrary = cd instanceof GeneralHeaderConstraints ? "C-CDA" : "C32";
        if (cd != null && cd.getCode() != null) {
            documentMetadata.documentType = StringUtils.isEmpty((String)cd.getCode().getDisplayName()) ? "MISSING" : cd.getCode().getDisplayName();
            documentMetadata.documentCode = StringUtils.isEmpty((String)cd.getCode().getCode()) ? "MISSING" : cd.getCode().getCode();
            documentMetadata.documentCodeSystem = StringUtils.isEmpty((String)cd.getCode().getCodeSystem()) ? "MISSING" : cd.getCode().getCodeSystem();
        } else {
            documentMetadata.documentType = "MISSING";
            documentMetadata.documentCode = "MISSING";
            documentMetadata.documentCodeSystem = "MISSING";
        }
        if (cd != null) {
            cd.getCode();
        }
        EAnnotation annotation = eClass.getEAnnotation("http://www.openhealthtools.org/mdht/uml/cda/annotation");
        String templateRoot = "MISSING";
        String templateExtension = null;
        if (annotation != null) {
            if (annotation.getDetails().containsKey((Object)"templateId.root")) {
                templateRoot = (String)annotation.getDetails().get((Object)"templateId.root");
            }
            if (annotation.getDetails().containsKey((Object)"templateId.extension")) {
                templateExtension = (String)annotation.getDetails().get((Object)"templateId.extension");
            }
        }
        documentMetadata.documentTemplateId = String.valueOf(templateRoot) + (templateExtension != null ? ":" + templateExtension : "");
        documentMetadata.fileName = fileName;
        if (theFile instanceof GenerateCDADataHandler.WrapperForZipEnty) {
            GenerateCDADataHandler.WrapperForZipEnty wrapperForZipEnty = (GenerateCDADataHandler.WrapperForZipEnty)theFile;
            documentMetadata.completePath = wrapperForZipEnty.getFullPath().toOSString();
        } else {
            documentMetadata.completePath = fileName;
        }
        if (!cd.getAuthors().isEmpty()) {
            for (Author a : cd.getAuthors()) {
                if (a.getAssignedAuthor() == null) continue;
                AssignedAuthor aa = a.getAssignedAuthor();
                if (aa.getRepresentedOrganization() != null) {
                    for (Iterator on : aa.getRepresentedOrganization().getNames()) {
                        documentMetadata.documentOrganization = CDAValueUtil.getValues((EN)on);
                    }
                }
                if (aa.getAssignedAuthoringDevice() == null) continue;
                if (aa.getAssignedAuthoringDevice().getManufacturerModelName() != null) {
                    documentMetadata.documentSoftware = aa.getAssignedAuthoringDevice().getManufacturerModelName().getText();
                }
                if (aa.getAssignedAuthoringDevice().getSoftwareName() == null) continue;
                documentMetadata.documentSoftware = String.valueOf(documentMetadata.documentSoftware) + " " + aa.getAssignedAuthoringDevice().getSoftwareName().getText();
            }
        }
        for (DocumentationOf documentationOf : cd.getDocumentationOfs()) {
            if (documentationOf.getServiceEvent() == null) continue;
            for (Performer1 performer : documentationOf.getServiceEvent().getPerformers()) {
                if (performer.getFunctionCode() == null || StringUtils.isEmpty((String)performer.getFunctionCode().getCode()) || !"PCP".equals(performer.getFunctionCode().getCode()) || performer.getAssignedEntity() == null) continue;
                iterator = performer.getAssignedEntity().getAddrs().iterator();
                if (iterator.hasNext()) {
                    AD ad = (AD)iterator.next();
                    documentMetadata.pcpAddress = CDAValueUtil.getValues(ad);
                }
                if (performer.getAssignedEntity().getAssignedPerson() == null || !(iterator = performer.getAssignedEntity().getAssignedPerson().getNames().iterator()).hasNext()) continue;
                pn = (PN)iterator.next();
                documentMetadata.pcpName = CDAValueUtil.getValues((EN)pn);
            }
        }
        Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
        int offset = SpreadsheetSerializer.serializePatient(row, 0, documentMetadata, patientRole);
        String name1 = "";
        String name2 = "";
        if (ir != null && ir.getIntendedRecipient() != null && ir.getIntendedRecipient().getInformationRecipient() != null) {
            iterator = ir.getIntendedRecipient().getInformationRecipient().getNames().iterator();
            if (iterator.hasNext()) {
                pn = (PN)iterator.next();
                name1 = CDAValueUtil.getAnyValue(null, (ANY)pn);
            }
            if (ir.getIntendedRecipient() != null && ir.getIntendedRecipient().getReceivedOrganization() != null && ir.getIntendedRecipient().getReceivedOrganization().getNames() != null && (iterator = ir.getIntendedRecipient().getReceivedOrganization().getNames().iterator()).hasNext()) {
                ON on = (ON)iterator.next();
                name2 = CDAValueUtil.getAnyValue(null, (ANY)on);
            }
        }
        row.createCell(offset++).setCellValue(name1);
        row.createCell(offset++).setCellValue(name2);
        String orderId = "";
        if (iffo != null && iffo.getOrder() != null) {
            for (II ii : iffo.getOrder().getIds()) {
                orderId = CDAValueUtil.getAnyValue(null, (ANY)ii);
            }
        }
        row.createCell(offset++).setCellValue(orderId);
        SpreadsheetSerializer.serializeSectionAndFileName(row, offset, null, fileName);
        return documentMetadata;
    }

    static void appendToResultsSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, List<? extends Organizer> results, List<Encounter> encounters, String fileName) {
        for (Organizer organizer : results) {
            for (Observation resultObservation : organizer.getObservations()) {
                int offset = 0;
                Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, organizer, encounters);
                offset = SpreadsheetSerializer.serializeOrganizer(row, offset, organizer, true, false);
                offset = SpreadsheetSerializer.serializeObservation(row, offset, resultObservation, true, false, GenerateCDADataHandler.exportCDTranslations, true);
                offset = SpreadsheetSerializer.serializeSectionAndFileName(row, offset, organizer.getSection(), organizationAndSoftware.completePath);
                offset = SpreadsheetSerializer.appendValidation(row, offset, (EObject)organizer);
            }
        }
    }

    static void appendToSubstanceAdministrationSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, List<Encounter> encounters, List<? extends SubstanceAdministration> sas, String fileName) {
        for (SubstanceAdministration substanceAdministration : sas) {
            int offset = 0;
            Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
            offset = SpreadsheetSerializer.serializePatient(row, offset, organizationAndSoftware, patientRole);
            offset = SpreadsheetSerializer.serializeEnounterID(row, offset, substanceAdministration, encounters);
            offset = SpreadsheetSerializer.serializeSubstanceAdministration(row, offset, substanceAdministration, true);
            offset = SpreadsheetSerializer.serializeSectionAndFileName(row, offset, substanceAdministration.getSection(), organizationAndSoftware.completePath);
            offset = SpreadsheetSerializer.appendValidation(row, offset, (EObject)substanceAdministration);
        }
    }

    static void appendToVitalSignsSheet(CDAUtil.Query query, Sheet sheet, CDAValueUtil.DocumentMetadata organizationAndSoftware, PatientRole patientRole, ServiceEvent serviceEvent, List<Organizer> vitalSignsOrganizers, List<Encounter> encounters, String fileName) {
        for (Organizer organizer : vitalSignsOrganizers) {
            for (Observation observation : organizer.getObservations()) {
                Row row = sheet.createRow(sheet.getPhysicalNumberOfRows());
                int offset = SpreadsheetSerializer.serializePatient(row, 0, organizationAndSoftware, patientRole);
                offset = SpreadsheetSerializer.serializeEnounterID(row, offset, organizer, encounters);
                offset = SpreadsheetSerializer.serializeOrganizer(row, offset, organizer, false, false);
                offset = SpreadsheetSerializer.serializeObservation(row, offset, observation, true, false, GenerateCDADataHandler.exportCDTranslations, true);
                SpreadsheetSerializer.serializeSectionAndFileName(row, offset, observation.getSection(), organizationAndSoftware.completePath);
                offset = SpreadsheetSerializer.appendValidation(row, offset, (EObject)observation);
            }
        }
    }

    static void handleDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        switch (diagnostic.getSeverity()) {
            case 4: {
                handler.handleError(diagnostic);
                break;
            }
            case 2: {
                handler.handleWarning(diagnostic);
                break;
            }
            case 1: {
                handler.handleInfo(diagnostic);
            }
        }
    }

    static void processDiagnostic(Diagnostic diagnostic, CDAUtil.ValidationHandler handler) {
        LinkedList<Diagnostic> queue = new LinkedList<Diagnostic>();
        queue.add(diagnostic);
        while (!queue.isEmpty()) {
            Diagnostic d = (Diagnostic)queue.remove();
            if (GenerateCDADataHandler.shouldHandle(d)) {
                SpreadsheetSerializer.handleDiagnostic(d, handler);
            }
            for (Diagnostic childDiagnostic : d.getChildren()) {
                queue.add(childDiagnostic);
            }
        }
    }

    static int serializeDianostic(Row row, int offset, Diagnostic diagnostic) {
        ValidationResult vr = new ValidationResult();
        StringBuffer sb = new StringBuffer();
        if (diagnostic.getChildren().size() > 0) {
            SpreadsheetSerializer.processDiagnostic(diagnostic, (CDAUtil.ValidationHandler)vr);
        }
        sb = new StringBuffer();
        for (Diagnostic dq : vr.getErrorDiagnostics()) {
            sb.append(dq.getMessage()).append("\r");
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        for (Diagnostic dq : vr.getWarningDiagnostics()) {
            sb.append(dq.getMessage()).append("\r");
        }
        for (Diagnostic dq : vr.getInfoDiagnostics()) {
            sb.append(dq.getMessage()).append("\r");
        }
        row.createCell(offset++).setCellValue(sb.toString());
        return offset;
    }

    static int serializeDocumentMetadata(Row row, int offset, CDAValueUtil.DocumentMetadata documentMetadata) {
        return SpreadsheetSerializer.serializeDocumentMetadata(row, offset, documentMetadata, true);
    }

    static int serializeDocumentMetadata(Row row, int offset, CDAValueUtil.DocumentMetadata documentMetadata, boolean filename) {
        Cell cell = null;
        if (filename) {
            cell = row.createCell(offset++);
            cell.setCellValue(documentMetadata.fileName);
            cell = row.createCell(offset++);
            cell.setCellValue(documentMetadata.documentRootID);
        }
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentLibrary);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentType);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentTemplateId);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentCode);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentCodeSystem);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentOrganization);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentSoftware);
        if (documentMetadata.documentDate != null) {
            cell = row.createCell(offset++);
            cell.setCellValue(CDAValueUtil.DATE_PRETTY.format(documentMetadata.documentDate));
        } else {
            row.createCell(offset++);
        }
        if (documentMetadata.pcpName != null) {
            cell = row.createCell(offset++);
            cell.setCellValue(documentMetadata.pcpName);
        } else {
            row.createCell(offset++);
        }
        if (documentMetadata.pcpAddress != null) {
            cell = row.createCell(offset++);
            cell.setCellValue(documentMetadata.pcpAddress);
        } else {
            row.createCell(offset++);
        }
        return offset;
    }

    static int serializeEncounter(Row row, int offset, Encounter encounter) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        for (II ii : encounter.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        sb = new StringBuffer();
        IVL_TS ivlts = encounter.getEffectiveTime();
        if (ivlts != null) {
            Date d;
            if (ivlts.getValue() != null && !StringUtils.isEmpty((String)ivlts.getValue()) && (d = CDAValueUtil.getDate(ivlts.getValue())) != null) {
                sb.append(CDAValueUtil.DATE_PRETTY.format(d));
            }
            if (ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                d = CDAValueUtil.getDate(ivlts.getLow().getValue());
                if (d != null) {
                    sb.append(CDAValueUtil.DATE_PRETTY.format(d));
                } else {
                    sb.append(ivlts.getLow().getValue());
                }
            }
            if (ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                d = CDAValueUtil.getDate(ivlts.getHigh().getValue());
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                if (d != null) {
                    sb.append(CDAValueUtil.DATE_PRETTY.format(d));
                } else {
                    sb.append(ivlts.getHigh().getValue());
                }
            }
        }
        cell.setCellValue(sb.toString());
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivlts));
        offset = SpreadsheetSerializer.appendCode(row, offset, encounter.getSection(), encounter.getCode(), encounter.getText());
        boolean hasDiagnosis = false;
        for (Act act : encounter.getActs()) {
            Iterator iterator = act.getObservations().iterator();
            if (iterator.hasNext()) {
                Observation observation = (Observation)iterator.next();
                offset = SpreadsheetSerializer.serializeProblemObservationClinicalStatement(row, offset, observation, true);
                hasDiagnosis = true;
            }
            if (hasDiagnosis) break;
        }
        if (!hasDiagnosis) {
            offset += 11;
        }
        offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)encounter.getAuthors());
        return offset;
    }

    static int serializeEncounterID(Row row, int offset, Encounter encounter, MatchEncounterBy result) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        for (II ii : encounter.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        cell.setCellValue(result.getMatch());
        return offset;
    }

    static int serializeEnounterID(Row row, int offset, Act act, List<Encounter> encounters) {
        for (Encounter encounter : encounters) {
            MatchEncounterBy result = EncounterUtil.matchesEncounter(encounter, act);
            if (result == MatchEncounterBy.NOMATCH) continue;
            offset = SpreadsheetSerializer.serializeEncounterID(row, offset, encounter, result);
            return offset;
        }
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset++;
    }

    static int serializeObservation(Row row, int offset, Observation observation, boolean referenceRange, boolean author, boolean exportTranslation) {
        return SpreadsheetSerializer.serializeObservation(row, offset, observation, referenceRange, author, exportTranslation, false);
    }

    static int serializeObservation(Row row, int offset, Observation observation, boolean referenceRange, boolean author, boolean exportTranslation, boolean checkForNotes) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        for (II ii : observation.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        sb = new StringBuffer();
        IVL_TS ivlts = observation.getEffectiveTime();
        if (ivlts != null) {
            Date d;
            if (ivlts.getValue() != null && !StringUtils.isEmpty((String)ivlts.getValue()) && (d = CDAValueUtil.getDate(ivlts.getValue())) != null) {
                sb.append(CDAValueUtil.DATE_PRETTY.format(d));
            }
            if (ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue()) && (d = CDAValueUtil.getDate(ivlts.getLow().getValue())) != null) {
                sb.append(CDAValueUtil.DATE_PRETTY.format(d));
            }
            if (ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                d = CDAValueUtil.getDate(ivlts.getHigh().getValue());
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                if (d != null) {
                    sb.append(CDAValueUtil.DATE_PRETTY.format(d));
                }
            }
        }
        cell.setCellValue(sb.toString());
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivlts));
        if (referenceRange) {
            if (observation.getStatusCode() != null && !StringUtils.isEmpty((String)observation.getStatusCode().getCode())) {
                row.createCell(offset++).setCellValue(observation.getStatusCode().getCode());
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)observation.getStatusCode()));
            } else {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
        }
        offset = exportTranslation ? SpreadsheetSerializer.appendExtendedCode(row, offset, observation.getSection(), observation.getCode(), observation.getText(), false) : SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, observation.getSection(), observation.getCode(), observation.getText());
        String value = "";
        String valueLocation = "";
        for (ANY any : observation.getValues()) {
            value = CDAValueUtil.getAnyValue(observation.getSection(), any);
            valueLocation = CDAUtil.getDomainPath((EObject)any);
        }
        if (value.length() < 1000) {
            row.createCell(offset++).setCellValue(value);
        } else {
            row.createCell(offset++).setCellValue(value.substring(0, 1000));
        }
        row.createCell(offset++).setCellValue(valueLocation);
        String referenceRangeValue = "";
        ANY anyRangeValue = null;
        for (ReferenceRange rr : observation.getReferenceRanges()) {
            if (rr.getObservationRange() == null || rr.getObservationRange().getValue() == null) continue;
            anyRangeValue = rr.getObservationRange().getValue();
            referenceRangeValue = CDAValueUtil.getAnyValue(observation.getSection(), rr.getObservationRange().getValue());
        }
        if (referenceRange) {
            row.createCell(offset++).setCellValue(referenceRangeValue);
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath(anyRangeValue));
        }
        if (checkForNotes) {
            boolean hasNotes = false;
            Act note = null;
            for (Act act : observation.getActs()) {
                if (!(act instanceof NoteActivity)) continue;
                hasNotes = true;
                note = act;
            }
            if (hasNotes) {
                row.createCell(offset++).setCellValue(hasNotes);
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
            } else {
                row.createCell(offset++).setCellValue(false);
                row.createCell(offset++).setCellValue("");
            }
        }
        if (author) {
            offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)observation.getAuthors());
        }
        return offset;
    }

    static int serializeOrganizer(Row row, int offset, Organizer resultOrganizer, boolean serializeSpecimen, boolean serializeSubject) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        for (II ii : resultOrganizer.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        sb = new StringBuffer();
        IVL_TS ivlts = resultOrganizer.getEffectiveTime();
        if (ivlts != null) {
            Date d;
            if (ivlts.getValue() != null && !StringUtils.isEmpty((String)ivlts.getValue()) && (d = CDAValueUtil.getDate(ivlts.getValue())) != null) {
                sb.append(CDAValueUtil.DATE_PRETTY.format(d));
            }
            if (ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue()) && (d = CDAValueUtil.getDate(ivlts.getLow().getValue())) != null) {
                sb.append(CDAValueUtil.DATE_PRETTY.format(d));
            }
            if (ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                d = CDAValueUtil.getDate(ivlts.getHigh().getValue());
                if (sb.length() > 0) {
                    sb.append(" - ");
                }
                if (d != null) {
                    sb.append(CDAValueUtil.DATE_PRETTY.format(d));
                }
            }
        }
        cell.setCellValue(sb.toString());
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivlts));
        offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, resultOrganizer.getSection(), resultOrganizer.getCode(), null, true) : SpreadsheetSerializer.appendCode(row, offset, resultOrganizer.getSection(), resultOrganizer.getCode(), null);
        if (serializeSubject) {
            offset = resultOrganizer.getSubject() != null && resultOrganizer.getSubject().getRelatedSubject() != null ? (GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, resultOrganizer.getSection(), (CD)resultOrganizer.getSubject().getRelatedSubject().getCode(), null, false) : SpreadsheetSerializer.appendCode(row, offset, resultOrganizer.getSection(), (CD)resultOrganizer.getSubject().getRelatedSubject().getCode(), null)) : (GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, resultOrganizer.getSection(), null, null, false) : SpreadsheetSerializer.appendCode(row, offset, resultOrganizer.getSection(), null, null));
        }
        if (serializeSpecimen) {
            CE specimenCode = null;
            for (Specimen specimen : resultOrganizer.getSpecimens()) {
                if (specimen.getSpecimenRole() == null || specimen.getSpecimenRole().getSpecimenPlayingEntity() == null) continue;
                specimenCode = specimen.getSpecimenRole().getSpecimenPlayingEntity().getCode();
                break;
            }
            offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, resultOrganizer.getSection(), specimenCode, null, false) : SpreadsheetSerializer.appendCode(row, offset, resultOrganizer.getSection(), specimenCode, null);
        }
        offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)resultOrganizer.getAuthors());
        return offset;
    }

    static int serializePatient(Row row, int offset, CDAValueUtil.DocumentMetadata documentMetadata, PatientRole patientRole) {
        Cell cell = row.createCell(offset++);
        cell.setCellValue((double)(row.getRowNum() - 1));
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.fileName);
        cell = row.createCell(offset++);
        cell.setCellValue(documentMetadata.documentRootID);
        cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        if (patientRole != null) {
            for (II ii : patientRole.getIds()) {
                if ("2.16.840.1.113883.4.1".equals(ii.getRoot())) continue;
                sb.append(CDAValueUtil.getKey2(ii));
                break;
            }
        }
        cell.setCellValue(sb.toString());
        if (!GenerateCDADataHandler.omitDOB) {
            offset = SpreadsheetSerializer.serializePatientDOB(row, offset, patientRole, patientRole != null ? patientRole.getPatient() : null);
        }
        if (!GenerateCDADataHandler.omitDOD) {
            cell = row.createCell(offset++);
            if (patientRole.getPatient().getSDTCDeceasedTime() != null) {
                Date dodDate = CDAValueUtil.getDate(patientRole.getPatient().getSDTCDeceasedTime().getValue());
                cell.setCellValue(CDAValueUtil.DATETIME_PRETTY.format(dodDate));
            }
        }
        if (documentMetadata != null) {
            offset = SpreadsheetSerializer.serializeDocumentMetadata(row, offset, documentMetadata, false);
        }
        return offset;
    }

    static int serializePatient(Row row, int offset, PatientRole patientRole) {
        return SpreadsheetSerializer.serializePatient(row, offset, null, patientRole);
    }

    static int serializePatient2(Row row, int offset, CDAValueUtil.DocumentMetadata documentMetadata, PatientRole patientRole, List<Participant1> participant, Sheet sheet) {
        block15: {
            int relatedPersonCount;
            block16: {
                offset = SpreadsheetSerializer.serializePatient(row, offset, documentMetadata, patientRole);
                if (patientRole == null || patientRole.getPatient() == null) break block15;
                Cell cell = row.createCell(offset++);
                if (!patientRole.getPatient().getNames().isEmpty()) {
                    cell.setCellValue(CDAValueUtil.getValues((EN)patientRole.getPatient().getNames().get(0)));
                }
                if (!patientRole.getAddrs().isEmpty()) {
                    offset = SpreadsheetSerializer.appendAddr(row, offset, (AD)patientRole.getAddrs().get(0));
                }
                offset = SpreadsheetSerializer.appendCode(row, offset, null, (CD)patientRole.getPatient().getRaceCode(), null);
                offset = SpreadsheetSerializer.appendCode(row, offset, null, (CD)patientRole.getPatient().getEthnicGroupCode(), null);
                offset = SpreadsheetSerializer.appendCode(row, offset, null, (CD)patientRole.getPatient().getAdministrativeGenderCode(), null);
                offset = SpreadsheetSerializer.appendCode(row, offset, null, (CD)patientRole.getPatient().getMaritalStatusCode(), null);
                if (!patientRole.getPatient().getLanguageCommunications().isEmpty()) {
                    LanguageCommunication preferredLanguage = null;
                    for (LanguageCommunication lc : patientRole.getPatient().getLanguageCommunications()) {
                        if (preferredLanguage == null && lc.getLanguageCode() != null) {
                            preferredLanguage = lc;
                        }
                        if (lc.getLanguageCode() == null || lc.getPreferenceInd() == null || !lc.getPreferenceInd().getValue().booleanValue()) continue;
                        preferredLanguage = lc;
                        break;
                    }
                    if (preferredLanguage != null && preferredLanguage.getLanguageCode() != null) {
                        offset = SpreadsheetSerializer.appendCode(row, offset, null, (CD)preferredLanguage.getLanguageCode(), null);
                    }
                }
                cell = row.createCell(offset++);
                if (!patientRole.getTelecoms().isEmpty()) {
                    cell.setCellValue(CDAValueUtil.getValueAsString((TEL)patientRole.getTelecoms().get(0)));
                } else {
                    cell.setCellValue("");
                }
                relatedPersonCount = 0;
                relatedPersonCount = Activator.getDefault().getPreferenceStore().isDefault(MDHTPreferences.RELATED_PERSON_COUNT_VALUE) ? (System.getProperty("org.eclipse.mdht.cda.xls.relatedpersoncount") != null ? Integer.valueOf(System.getProperty("org.eclipse.mdht.cda.xls.relatedpersoncount")).intValue() : Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.RELATED_PERSON_COUNT_VALUE)) : Activator.getDefault().getPreferenceStore().getInt(MDHTPreferences.RELATED_PERSON_COUNT_VALUE);
                if (participant == null || participant.size() == 0) break block16;
                int i = 0;
                for (Participant1 part : participant) {
                    if (++i > relatedPersonCount) {
                        return offset;
                    }
                    cell = row.createCell(offset++);
                    if (!part.getAssociatedEntity().getAssociatedPerson().getNames().isEmpty()) {
                        cell.setCellValue(CDAValueUtil.getValues((EN)part.getAssociatedEntity().getAssociatedPerson().getNames().get(0)));
                    }
                    if (!part.getAssociatedEntity().getAddrs().isEmpty()) {
                        offset = SpreadsheetSerializer.appendAddr(row, offset, (AD)part.getAssociatedEntity().getAddrs().get(0));
                    }
                    offset = SpreadsheetSerializer.appendCode(row, offset, null, (CD)part.getAssociatedEntity().getCode(), null);
                    cell = row.createCell(offset++);
                    if (!part.getAssociatedEntity().getTelecoms().isEmpty()) {
                        cell.setCellValue(CDAValueUtil.getValueAsString((TEL)part.getAssociatedEntity().getTelecoms().get(0)));
                        continue;
                    }
                    cell.setCellValue("");
                }
                if (i >= relatedPersonCount) break block15;
                int j = i;
                while (j < relatedPersonCount) {
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue("");
                    ++j;
                }
                break block15;
            }
            int i = 0;
            while (i < relatedPersonCount) {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                ++i;
            }
        }
        return offset;
    }

    static int serializePatientDOB(Row row, int offset, PatientRole patientRole, Patient patient) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        if (patientRole != null) {
            for (II ii : patientRole.getIds()) {
                if ("2.16.840.1.113883.4.1".equals(ii.getRoot())) continue;
                sb.append(CDAValueUtil.getKey3(ii));
            }
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        if (patient != null && patient.getNames() != null && !patient.getNames().isEmpty()) {
            cell.setCellValue(CDAValueUtil.getValues((EN)patient.getNames().get(0)));
        }
        cell = row.createCell(offset++);
        if (patient != null && patient.getBirthTime() != null) {
            Date d = CDAValueUtil.getDate(patient.getBirthTime().getValue());
            if (d != null) {
                cell.setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
            } else {
                cell.setCellValue(patient.getBirthTime().getValue());
            }
        }
        return offset;
    }

    static int serializeCompleteDate(Row row, int offset, SXCM_TS sxcm_ts) {
        if (sxcm_ts != null) {
            if (sxcm_ts instanceof IVL_TS) {
                IVL_TS ivl_ts = (IVL_TS)sxcm_ts;
                if (ivl_ts != null) {
                    if (ivl_ts.getValue() != null) {
                        Date effectiveDate = CDAValueUtil.getDate(ivl_ts.getValue());
                        if (effectiveDate != null) {
                            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(effectiveDate));
                        } else {
                            row.createCell(offset++).setCellValue("");
                        }
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivl_ts));
                    } else {
                        row.createCell(offset++).setCellValue("");
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivl_ts));
                    }
                    if (ivl_ts.getLow() != null) {
                        Date effectiveDateLow = CDAValueUtil.getDate(ivl_ts.getLow().getValue());
                        if (effectiveDateLow != null) {
                            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(effectiveDateLow));
                        } else {
                            row.createCell(offset++).setCellValue("");
                        }
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivl_ts.getLow()));
                    } else {
                        row.createCell(offset++).setCellValue("");
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivl_ts));
                    }
                    if (ivl_ts.getHigh() != null) {
                        Date effectiveDateHigh = CDAValueUtil.getDate(ivl_ts.getHigh().getValue());
                        if (effectiveDateHigh != null) {
                            row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(effectiveDateHigh));
                        } else {
                            row.createCell(offset++).setCellValue("");
                        }
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivl_ts.getHigh()));
                    } else {
                        row.createCell(offset++).setCellValue("");
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)ivl_ts));
                    }
                }
            } else {
                if (sxcm_ts.getValue() != null) {
                    Date effectiveDate = CDAValueUtil.getDate(sxcm_ts.getValue());
                    if (effectiveDate != null) {
                        row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(effectiveDate));
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)sxcm_ts));
                    } else {
                        row.createCell(offset++).setCellValue("");
                        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)sxcm_ts));
                    }
                } else {
                    row.createCell(offset++).setCellValue("");
                    row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)sxcm_ts));
                }
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        return offset;
    }

    static int serializeProcedureActivityAct(Row row, int offset, Act procedureActivityAct, boolean checkForNotes) {
        StringBuffer sb = new StringBuffer();
        for (II ii : procedureActivityAct.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        offset = SpreadsheetSerializer.serializeCompleteDate(row, offset, (SXCM_TS)procedureActivityAct.getEffectiveTime());
        offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, procedureActivityAct.getSection(), procedureActivityAct.getCode(), procedureActivityAct.getText(), true) : SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, procedureActivityAct.getSection(), procedureActivityAct.getCode(), procedureActivityAct.getText());
        if (checkForNotes) {
            boolean hasNotes = false;
            Act note = null;
            for (Act act : procedureActivityAct.getActs()) {
                if (!(act instanceof NoteActivity)) continue;
                hasNotes = true;
                note = act;
            }
            if (hasNotes) {
                row.createCell(offset++).setCellValue(hasNotes);
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
            } else {
                row.createCell(offset++).setCellValue(false);
                row.createCell(offset++).setCellValue("");
            }
        }
        offset = SpreadsheetSerializer.appendProcedurePerformaerAndOrganization(row, offset, (EList<Performer2>)procedureActivityAct.getPerformers());
        return offset;
    }

    static int appendProcedurePerformaerAndOrganization(Row row, int offset, EList<Performer2> performers) {
        String organizationValue = "";
        String organizationValueLocation = "";
        String personValue = "";
        String personValueLocation = "";
        for (Performer2 performer : performers) {
            if (performer.getAssignedEntity() == null) continue;
            for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                for (ON on : organization.getNames()) {
                    organizationValue = String.valueOf(organizationValue) + CDAValueUtil.getValues((EN)on);
                    organizationValueLocation = CDAUtil.getDomainPath((EObject)on);
                }
            }
            if (performer.getAssignedEntity().getAssignedPerson() == null) continue;
            for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                personValue = CDAValueUtil.getValues((EN)pn);
                personValueLocation = CDAUtil.getDomainPath((EObject)pn);
            }
        }
        row.createCell(offset++).setCellValue(personValue);
        row.createCell(offset++).setCellValue(personValueLocation);
        row.createCell(offset++).setCellValue(organizationValue);
        row.createCell(offset++).setCellValue(organizationValueLocation);
        return offset;
    }

    static int serializeProcedureActivityObservation(Row row, int offset, Observation procedureActivityObservation, boolean checkForNotes) {
        StringBuffer sb = new StringBuffer();
        for (II ii : procedureActivityObservation.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        offset = SpreadsheetSerializer.serializeCompleteDate(row, offset, (SXCM_TS)procedureActivityObservation.getEffectiveTime());
        offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, procedureActivityObservation.getSection(), procedureActivityObservation.getCode(), procedureActivityObservation.getText(), true) : SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, procedureActivityObservation.getSection(), procedureActivityObservation.getCode(), procedureActivityObservation.getText());
        if (checkForNotes) {
            boolean hasNotes = false;
            Act note = null;
            for (Act act : procedureActivityObservation.getActs()) {
                if (!(act instanceof NoteActivity)) continue;
                hasNotes = true;
                note = act;
            }
            if (hasNotes) {
                row.createCell(offset++).setCellValue(hasNotes);
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
            } else {
                row.createCell(offset++).setCellValue(false);
                row.createCell(offset++).setCellValue("");
            }
        }
        offset = SpreadsheetSerializer.appendProcedurePerformaerAndOrganization(row, offset, (EList<Performer2>)procedureActivityObservation.getPerformers());
        return offset;
    }

    static int serializeProcedureActivityProcedure(Row row, int offset, Procedure procedureActivityProcedure, boolean checkForNotes) {
        StringBuffer sb = new StringBuffer();
        for (II ii : procedureActivityProcedure.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        offset = SpreadsheetSerializer.serializeCompleteDate(row, offset, (SXCM_TS)procedureActivityProcedure.getEffectiveTime());
        offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, procedureActivityProcedure.getSection(), procedureActivityProcedure.getCode(), procedureActivityProcedure.getText(), true) : SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, procedureActivityProcedure.getSection(), procedureActivityProcedure.getCode(), procedureActivityProcedure.getText());
        if (checkForNotes) {
            boolean hasNotes = false;
            Act note = null;
            for (Act act : procedureActivityProcedure.getActs()) {
                if (!(act instanceof NoteActivity)) continue;
                hasNotes = true;
                note = act;
            }
            if (hasNotes) {
                row.createCell(offset++).setCellValue(hasNotes);
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
            } else {
                row.createCell(offset++).setCellValue(false);
                row.createCell(offset++).setCellValue("");
            }
        }
        offset = SpreadsheetSerializer.appendProcedurePerformaerAndOrganization(row, offset, (EList<Performer2>)procedureActivityProcedure.getPerformers());
        return offset;
    }

    static void serializeSA(String prefix, SubstanceAdministration substanceAdministration, Sheet sheet, int rownumber) {
        ManufacturedProduct manufacturedProduct;
        Consumable consumable;
        Row row = sheet.createRow(rownumber);
        Cell cell = row.createCell(0);
        cell.setCellValue(prefix);
        StringBuffer sb = new StringBuffer();
        for (II ii : substanceAdministration.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(1).setCellValue(sb.toString());
        sb = new StringBuffer();
        substanceAdministration.getEffectiveTimes();
        if (substanceAdministration.getConsumable() != null && (consumable = substanceAdministration.getConsumable()).getManufacturedProduct() != null && (manufacturedProduct = consumable.getManufacturedProduct()).getManufacturedMaterial() != null && manufacturedProduct.getManufacturedMaterial().getName() != null) {
            sb.append(manufacturedProduct.getManufacturedMaterial().getName().getText());
        }
        row.createCell(2).setCellValue(sb.toString());
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)substanceAdministration);
        ValidationResult vr = new ValidationResult();
        if (diagnostic.getChildren().size() > 0) {
            SpreadsheetSerializer.processDiagnostic(diagnostic, (CDAUtil.ValidationHandler)vr);
        }
        sb = new StringBuffer();
        for (Diagnostic dq : vr.getErrorDiagnostics()) {
            sb.append(dq.getMessage()).append("\r");
        }
        row.createCell(3).setCellValue(sb.toString());
        sb = new StringBuffer();
        for (Diagnostic dq : vr.getWarningDiagnostics()) {
            sb.append(dq.getMessage()).append("\r");
        }
        row.createCell(3).setCellValue(sb.toString());
        sb = new StringBuffer();
        for (Diagnostic dq : vr.getInfoDiagnostics()) {
            sb.append(dq.getMessage()).append("\r");
        }
        row.createCell(3).setCellValue(sb.toString());
    }

    static int serializeSectionAndFileName(Row row, int offset, Section section, String fileLocation) {
        String narrativeText = "";
        if (section != null) {
            if (section.getTitle() != null) {
                row.createCell(offset++).setCellValue(section.getTitle().getText());
            }
            try {
                if (section.getEntries() == null || section.getEntries().size() == 0) {
                    ByteArrayOutputStream fa = new ByteArrayOutputStream();
                    Section s = CDAFactory.eINSTANCE.createSection();
                    s.setText((StrucDocText)EcoreUtil.copy((EObject)section.getText()));
                    if (section.getText() != null) {
                        CDAUtil.saveSnippet((EObject)EcoreUtil.copy((EObject)section.getText()), (OutputStream)fa);
                        narrativeText = CDAValueUtil.getNarrativeText(fa.toString());
                    } else {
                        narrativeText = "Missing Text";
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        Cell cell = row.createCell(offset++);
        cell.setCellValue(fileLocation);
        if (!StringUtils.isEmpty((String)narrativeText)) {
            row.createCell(offset++).setCellValue(narrativeText);
        }
        return offset;
    }

    static int serializeServiceEvent(Row row, int offset, ServiceEvent serviceEvent) {
        Cell cell = row.createCell(offset++);
        StringBuffer sb = new StringBuffer();
        for (II ii : serviceEvent.getIds()) {
            sb.append(CDAValueUtil.getKey(ii));
        }
        cell.setCellValue(sb.toString());
        cell = row.createCell(offset++);
        sb = new StringBuffer();
        IVL_TS ivlts = serviceEvent.getEffectiveTime();
        if (ivlts != null) {
            boolean hasLow = false;
            if (ivlts.getLow() != null && !StringUtils.isEmpty((String)ivlts.getLow().getValue())) {
                sb.append(ivlts.getLow().getValue());
                hasLow = true;
            }
            if (ivlts.getHigh() != null && !StringUtils.isEmpty((String)ivlts.getHigh().getValue())) {
                if (hasLow) {
                    sb.append(" - ");
                }
                sb.append(ivlts.getHigh().getValue());
            }
        }
        cell.setCellValue(sb.toString());
        sb = new StringBuffer();
        if (serviceEvent.getCode() != null) {
            if (!StringUtils.isEmpty((String)serviceEvent.getCode().getDisplayName())) {
                sb.append(serviceEvent.getCode().getDisplayName());
            } else if (serviceEvent.getCode().getOriginalText() != null && !StringUtils.isEmpty((String)serviceEvent.getCode().getOriginalText().getText())) {
                sb.append(serviceEvent.getCode().getOriginalText().getText());
            } else if (!StringUtils.isEmpty((String)serviceEvent.getCode().getCode())) {
                sb.append(serviceEvent.getCode().getCode());
            }
        }
        row.createCell(offset++).setCellValue(sb.toString());
        row.createCell(offset++).setCellValue("DOCUMENT SERVICE EVENT");
        return offset;
    }

    static int serializeSubstanceAdministration(Row row, int offset, SubstanceAdministration substanceAdministration, boolean checkForNotes) {
        ManufacturedProduct manufacturedProduct;
        Consumable consumable;
        StringBuffer sb = new StringBuffer();
        for (II ii : substanceAdministration.getIds()) {
            sb.append(CDAValueUtil.getKey2(ii));
        }
        row.createCell(offset++).setCellValue(sb.toString());
        sb = new StringBuffer();
        ST lotNumberText = null;
        boolean hasCode = false;
        if (substanceAdministration.getConsumable() != null && (consumable = substanceAdministration.getConsumable()).getManufacturedProduct() != null && (manufacturedProduct = consumable.getManufacturedProduct()).getManufacturedMaterial() != null && manufacturedProduct.getManufacturedMaterial().getCode() != null) {
            offset = GenerateCDADataHandler.exportCDTranslations ? SpreadsheetSerializer.appendExtendedCode(row, offset, substanceAdministration.getSection(), (CD)manufacturedProduct.getManufacturedMaterial().getCode(), substanceAdministration.getText(), true) : SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, substanceAdministration.getSection(), (CD)manufacturedProduct.getManufacturedMaterial().getCode(), substanceAdministration.getText());
            lotNumberText = manufacturedProduct.getManufacturedMaterial().getLotNumberText();
            hasCode = true;
        }
        if (!hasCode) {
            offset = SpreadsheetSerializer.appendCode(row, offset, substanceAdministration.getSection(), null, substanceAdministration.getText());
        }
        if (substanceAdministration.getStatusCode() != null && !StringUtils.isEmpty((String)substanceAdministration.getStatusCode().getCode())) {
            row.createCell(offset++).setCellValue(substanceAdministration.getStatusCode().getCode());
        } else {
            row.createCell(offset++).setCellValue("Missing Status");
        }
        row.createCell(offset++).setCellValue(CDAValueUtil.getValue(substanceAdministration.getDoseQuantity()));
        row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)substanceAdministration.getDoseQuantity()));
        boolean hasDate = false;
        Iterator iterator = substanceAdministration.getEffectiveTimes().iterator();
        if (iterator.hasNext()) {
            SXCM_TS sxcm_ts = (SXCM_TS)iterator.next();
            offset = SpreadsheetSerializer.serializeCompleteDate(row, offset, sxcm_ts);
            hasDate = true;
        }
        if (lotNumberText != null) {
            row.createCell(offset++).setCellValue(lotNumberText.getText());
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)lotNumberText));
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        offset = SpreadsheetSerializer.appendCode(row, offset, substanceAdministration.getSection(), (CD)substanceAdministration.getRouteCode(), null);
        row.createCell(offset++).setCellValue((String)GenerateCDADataHandler.sigSwitch.doSwitch((EObject)substanceAdministration));
        row.createCell(offset++).setCellValue((String)GenerateCDADataHandler.sigLocationSwitch.doSwitch((EObject)substanceAdministration));
        if (checkForNotes) {
            boolean hasNotes = false;
            Act note = null;
            for (Act act : substanceAdministration.getActs()) {
                if (!(act instanceof NoteActivity)) continue;
                hasNotes = true;
                note = act;
            }
            if (hasNotes) {
                row.createCell(offset++).setCellValue(hasNotes);
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)note));
            } else {
                row.createCell(offset++).setCellValue(false);
                row.createCell(offset++).setCellValue("");
            }
        }
        offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)substanceAdministration.getAuthors());
        return offset;
    }

    public static int serializeNoEnounterID(Row row, int offset) {
        Cell cell = row.createCell(offset++);
        cell = row.createCell(offset++);
        cell.setCellValue(MatchEncounterBy.NOMATCH.getMatch());
        return offset;
    }

    public static int appendValidation(Row row, int offset, EObject target) {
        if (!GenerateCDADataHandler.omitValidation) {
            StringBuffer sb = new StringBuffer();
            try {
                Diagnostic diagnostic = Diagnostician.INSTANCE.validate(target);
                ValidationResult vr = new ValidationResult();
                if (diagnostic.getChildren().size() > 0) {
                    SpreadsheetSerializer.processDiagnostic(diagnostic, (CDAUtil.ValidationHandler)vr);
                }
                for (Diagnostic dq : vr.getErrorDiagnostics()) {
                    sb.append(dq.getMessage()).append("\r");
                }
            }
            catch (Throwable e) {
                sb.append(e.getMessage());
            }
            row.createCell(offset++).setCellValue(sb.toString());
        }
        return offset;
    }

    public static void appendToMetricsSheet(CDAUtil.Query query, SXSSFSheet metricsSheet, CDAValueUtil.DocumentMetadata documentMetadata, PatientRole patientRole, List<Participant1> participant, AnalyzeCDAHandler.CDAAnalaysisInput.CDAMetrics metrics, String name) {
        SXSSFRow row = metricsSheet.createRow(metricsSheet.getPhysicalNumberOfRows());
        int offset = SpreadsheetSerializer.serializePatient2((Row)row, 0, documentMetadata, patientRole, participant, (Sheet)metricsSheet);
        SpreadsheetSerializer.serializeSectionAndFileName((Row)row, offset, null, documentMetadata.fileName);
        for (String key : metrics.codedMetrics.keySet()) {
            metrics.codedMetrics.get(key);
            Cell cell = row.createCell(offset++);
            cell.setCellValue(metrics.codedMetrics.get(key).booleanValue());
        }
    }

    public static int serializeCoverageActivity(Row row, int offset, CoverageActivity coverageActivity) {
        for (PolicyActivity policyActivity : coverageActivity.getPolicyActivities()) {
            StringBuffer sb = new StringBuffer();
            for (II ii : policyActivity.getIds()) {
                sb.append(CDAValueUtil.getKey2(ii));
            }
            row.createCell(offset++).setCellValue(sb.toString());
            Date d = CDAValueUtil.getDate(CDAValueUtil.getValueAsString(policyActivity.getEffectiveTime()));
            if (d != null) {
                row.createCell(offset++).setCellValue(CDAValueUtil.DATE_PRETTY.format(d));
                row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)policyActivity.getEffectiveTime()));
            } else {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
            offset = SpreadsheetSerializer.appendCode(row, offset, coverageActivity.getSection(), policyActivity.getCode(), policyActivity.getText());
            offset = SpreadsheetSerializer.appendOrganizationAndAuthor(row, offset, (EList<Author>)policyActivity.getAuthors());
            String payerorganizationValue = "";
            String payerpersonValue = "";
            String guarantororganizationvalue = "";
            String guarantorpersonValue = "";
            String coverageorganizationvalue = "";
            String coveragepersonValue = "";
            CE coverageRelationshipCode = null;
            String holderpersonValue = "";
            block2: for (Performer2 performer : policyActivity.getPerformers()) {
                for (II ii : performer.getTemplateIds()) {
                    if ("2.16.840.1.113883.10.20.22.4.87".equals(ii.getRoot())) {
                        if (performer.getAssignedEntity() == null) continue block2;
                        for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                            for (ON on : organization.getNames()) {
                                payerorganizationValue = String.valueOf(payerorganizationValue) + CDAValueUtil.getValues((EN)on);
                            }
                        }
                        if (performer.getAssignedEntity().getAssignedPerson() == null) continue block2;
                        for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                            payerpersonValue = CDAValueUtil.getValues((EN)pn);
                        }
                        continue block2;
                    }
                    if (!"2.16.840.1.113883.10.20.22.4.88".equals(ii.getRoot())) continue;
                    if (performer.getAssignedEntity() == null) continue block2;
                    for (Organization organization : performer.getAssignedEntity().getRepresentedOrganizations()) {
                        for (ON on : organization.getNames()) {
                            guarantororganizationvalue = String.valueOf(guarantororganizationvalue) + CDAValueUtil.getValues((EN)on);
                        }
                    }
                    if (performer.getAssignedEntity().getAssignedPerson() == null) continue block2;
                    for (PN pn : performer.getAssignedEntity().getAssignedPerson().getNames()) {
                        guarantorpersonValue = CDAValueUtil.getValues((EN)pn);
                    }
                    continue block2;
                }
            }
            block10: for (Participant2 participant : policyActivity.getParticipants()) {
                for (II ii : participant.getTemplateIds()) {
                    if ("2.16.840.1.113883.10.20.22.4.89".equals(ii.getRoot())) {
                        if (participant.getParticipantRole() == null || participant.getParticipantRole().getPlayingEntity() == null) continue block10;
                        coverageRelationshipCode = participant.getParticipantRole().getCode();
                        if (participant.getParticipantRole().getPlayingEntity() == null) continue block10;
                        for (PN pn : participant.getParticipantRole().getPlayingEntity().getNames()) {
                            coveragepersonValue = CDAValueUtil.getValues((EN)pn);
                        }
                        continue block10;
                    }
                    if (!"2.16.840.1.113883.10.20.22.4.90".equals(ii.getRoot())) continue;
                    if (participant.getParticipantRole() == null || participant.getParticipantRole().getPlayingEntity() == null || participant.getParticipantRole().getPlayingEntity() == null) continue block10;
                    for (PN pn : participant.getParticipantRole().getPlayingEntity().getNames()) {
                        holderpersonValue = CDAValueUtil.getValues((EN)pn);
                    }
                    continue block10;
                }
            }
            row.createCell(offset++).setCellValue(payerpersonValue);
            row.createCell(offset++).setCellValue(payerorganizationValue);
            row.createCell(offset++).setCellValue(guarantorpersonValue);
            row.createCell(offset++).setCellValue(guarantororganizationvalue);
            row.createCell(offset++).setCellValue(coveragepersonValue);
            offset = SpreadsheetSerializer.appendCode(row, offset, coverageActivity.getSection(), (CD)coverageRelationshipCode, null);
            row.createCell(offset++).setCellValue(holderpersonValue);
        }
        return offset;
    }

    public static int appendCodeShowNullFlavor(Row row, int offset, Section section, CD cd, ED ed) {
        if (cd != null) {
            ED theED;
            ED eD = theED = cd.getOriginalText() != null ? cd.getOriginalText() : ed;
            if (section != null || ed != null) {
                row.createCell(offset++).setCellValue(CDAValueUtil.getValue(section, theED));
            } else {
                row.createCell(offset++).setCellValue("");
            }
            row.createCell(offset++).setCellValue(CDAValueUtil.getValueAsString(section, cd));
            if (cd.isNullFlavorDefined() && StringUtils.isEmpty((String)cd.getCode())) {
                row.createCell(offset++).setCellValue(cd.getNullFlavor().getLiteral());
            } else {
                row.createCell(offset++).setCellValue(cd.getCode());
            }
            row.createCell(offset++).setCellValue(cd.getCodeSystem());
            row.createCell(offset++).setCellValue(cd.getCodeSystemName());
            row.createCell(offset++).setCellValue(CDAUtil.getDomainPath((EObject)cd));
        } else {
            if (section != null || ed != null) {
                row.createCell(offset++).setCellValue("");
            }
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        return offset;
    }

    public static int appendExtendedCode(Row row, int offset, Section section, CD cd, ED text, boolean showNullFlavor) {
        offset = showNullFlavor ? SpreadsheetSerializer.appendCodeShowNullFlavor(row, offset, section, cd, text) : SpreadsheetSerializer.appendCode(row, offset, section, cd, text);
        if (cd != null) {
            if (cd.getTranslations().size() >= 1) {
                offset = SpreadsheetSerializer.appendCode(row, offset, section, (CD)cd.getTranslations().get(0), null);
            } else {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
            if (cd.getTranslations().size() >= 2) {
                offset = SpreadsheetSerializer.appendCode(row, offset, section, (CD)cd.getTranslations().get(1), null);
            } else {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
            if (cd.getTranslations().size() >= 3) {
                offset = SpreadsheetSerializer.appendCode(row, offset, section, (CD)cd.getTranslations().get(2), null);
            } else {
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
                row.createCell(offset++).setCellValue("");
            }
        } else {
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
            row.createCell(offset++).setCellValue("");
        }
        return offset;
    }
}

