/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.transformation.ocl2java;

import org.apache.commons.lang.WordUtils;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.mdht.transformation.ocl.OCL2ProgrammingLanguageTransformation;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.OperationCallExp;

public abstract class OCL2JavaTransformation<PK, C, O extends EModelElement, P, EL, PM, S, COA, SSA, CT, CLS, E>
extends OCL2ProgrammingLanguageTransformation<PK, C, O, P, EL, PM, S, COA, SSA, CT, CLS, E> {
    public String count(String transform) {
        return String.valueOf(transform) + ".count()";
    }

    public String length(String string) {
        return String.valueOf(string) + ".length()";
    }

    public String contains(String set, String item) {
        return String.valueOf(set) + ".collect(Collectors.toList()).contains(" + item + ")";
    }

    public String deepEqual(String operator, String lhs, String rhs) {
        return String.valueOf(lhs) + ".collect(Collectors.toList())" + ".equals(" + rhs + ".collect(Collectors.toList())" + ")";
    }

    public String iterator(String body, String i, String n, String source) {
        String result;
        if ("collect".equals(n)) {
            if (!body.startsWith("Set(")) {
                body = "Set(" + body + ")";
            }
            result = "Flatten(" + this.listfunction(source, body, "map", i) + ")";
        } else {
            result = "forAll".equals(n) ? this.listfunction(source, body, "allMatch", i) : ("exists".equals(n) ? this.listfunction(source, body, "anyMatch", i) : this.listfunction(source, body, "filter", i));
        }
        if ("one".equals(n)) {
            return String.valueOf(this.count(result)) + "==1";
        }
        return result;
    }

    public String listfunction(String steps, String body, String function, String i) {
        return String.valueOf(steps) + "." + function + "(" + i + " -> " + body + ")";
    }

    public String typeCast(String object, String type) {
        return "(" + type + ") " + object;
    }

    public String instanceOf(String object, String type) {
        return String.valueOf(object) + " instanceof " + type;
    }

    public String getValue(P property, String value) {
        Object type = this.getType(property);
        if ("Integer".equals(this.getName(type))) {
            return value;
        }
        return super.getValue(property, value);
    }

    public String getQualifiedName(P referredProperty) {
        String name = super.getQualifiedName(referredProperty);
        Object type = this.getType(referredProperty);
        String prefix = "Boolean".equals(this.getName(type)) && this.isPrimitive(referredProperty) ? "is" : "get";
        String result = String.valueOf(prefix) + WordUtils.capitalize((String)name);
        if (this.getOCLInstance().getEnvironment().getUMLReflection().isMany(referredProperty) && !"text".equals(name) && !"any".equals(name)) {
            result = String.valueOf(result) + "s";
        }
        result = result.replaceAll("ys$", "ies");
        result = result.replaceAll("xs$", "xes");
        result = String.valueOf(result) + "()";
        return result;
    }

    abstract boolean isPrimitive(P var1);

    public String typeof(String typeName) {
        return String.valueOf(typeName) + ".class";
    }

    public String transform(OCLExpression exp) {
        if (exp instanceof OperationCallExp) {
            OperationCallExp op = (OperationCallExp)exp;
            String opName = this.getName(op.getReferredOperation());
            if ("first".equals(opName)) {
                return String.valueOf(this.transform(op.getSource())) + ".first()";
            }
            if ("last".equals(opName)) {
                return String.valueOf(this.transform(op.getSource())) + ".reduce((a,b)->b)";
            }
            if ("at".equals(opName)) {
                return String.valueOf(this.transform(op.getSource())) + ".get(" + this.transform((OCLExpression)op.getArgument().get(0)) + ")";
            }
        }
        return super.transform(exp);
    }
}

