/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mdht.uml.validation.ocl;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mdht.uml.validation.ocl.EcoreProfileEnvironment;
import org.eclipse.ocl.uml.UMLEnvironment;
import org.eclipse.ocl.uml.internal.UMLReflectionImpl;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.RedefinableElement;

class EcoreProfileReflection
extends UMLReflectionImpl {
    EcoreProfileReflection(EcoreProfileEnvironment env) {
        super((UMLEnvironment)env);
    }

    public Classifier getOCLType(Object metaElement) {
        if (metaElement instanceof Property) {
            metaElement = this.getRootDefinition((Property)metaElement);
        }
        return super.getOCLType(metaElement);
    }

    private Property getRootDefinition(Property property) {
        Property result = property;
        if (property.getOwner() instanceof Classifier) {
            String name = property.getName();
            Iterator iter = ((Classifier)property.getOwner()).allParents().iterator();
            while (iter.hasNext()) {
                Property redefined = ((Classifier)iter.next()).getAttribute(name, null);
                if (redefined == null) continue;
                result = redefined;
            }
        }
        return result;
    }

    public List<Property> getAttributes(Classifier classifier) {
        List result = super.getAttributes(classifier);
        ListIterator iter = result.listIterator();
        while (iter.hasNext()) {
            Property next = (Property)iter.next();
            if (!this.isRenameRedefinition((RedefinableElement)next)) continue;
            int index = iter.previousIndex();
            BasicEList filtered = new BasicEList(result.size());
            filtered.addAll(result.subList(0, index));
            filtered.add(this.getRenamedElement(next));
            while (iter.hasNext()) {
                next = (Property)iter.next();
                if (this.isRenameRedefinition((RedefinableElement)next)) {
                    filtered.add(this.getRenamedElement(next));
                    continue;
                }
                filtered.add(next);
            }
            result = filtered;
            break;
        }
        return result;
    }

    private boolean isRenameRedefinition(RedefinableElement element) {
        boolean result = false;
        EList redefined = element.getRedefinedElements();
        if (!redefined.isEmpty()) {
            String name = element.getName();
            for (RedefinableElement next : redefined) {
                if (UML2Util.safeEquals((Object)name, (Object)next.getName())) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private <T extends RedefinableElement> T getRenamedElement(T element) {
        Class<?> type = element.getClass();
        Object result = element;
        while (!result.getRedefinedElements().isEmpty()) {
            RedefinableElement next = (RedefinableElement)result.getRedefinedElements().get(0);
            if (!type.isInstance(next)) break;
            result = (RedefinableElement)type.cast(next);
        }
        return result;
    }
}

