/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableImage;

@JsonDeserialize(builder=ImmutableImage.Builder.class)
@Value.Immutable
public interface Image {
    @JsonProperty(value="Created")
    public String created();

    @JsonProperty(value="Id")
    public String id();

    @JsonProperty(value="ParentId")
    public String parentId();

    @JsonProperty(value="RepoTags")
    @Nullable
    public List<String> repoTags();

    @JsonProperty(value="RepoDigests")
    @Nullable
    public List<String> repoDigests();

    @JsonProperty(value="Size")
    public Long size();

    @Deprecated
    @JsonProperty(value="VirtualSize")
    @Value.Default
    default public Long virtualSize() {
        return this.size();
    }

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();
}

