/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.linuxtools.internal.docker.core.ProgressJob;

public class ProgressJob2
extends ProgressJob {
    private int percentageDone = 0;
    private String statusMessage = "";
    private Object lockObject = new Object();
    private String jobName;

    public ProgressJob2(String name, String jobName) {
        super(name, jobName);
        this.jobName = jobName;
    }

    @Override
    protected IStatus run(IProgressMonitor monitor) {
        monitor.beginTask(this.jobName, -1);
        boolean done = false;
        while (!done) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            String status = this.getStatusMessage();
            if (status != null && !status.isEmpty()) {
                monitor.subTask(this.statusMessage);
            }
            if (this.percentageDone >= 100) {
                done = true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                done = true;
            }
        }
        monitor.done();
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStatusMessage() {
        Object object = this.lockObject;
        synchronized (object) {
            return this.statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatusMessage(String statusMessage) {
        Object object = this.lockObject;
        synchronized (object) {
            this.statusMessage = statusMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPercentageDone(int percentage) {
        Object object = this.lockObject;
        synchronized (object) {
            if (percentage > this.percentageDone) {
                this.percentageDone = percentage;
            }
        }
    }
}

