/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.DockerConfigReader;
import org.mandas.docker.client.messages.ImmutableRegistryAuth;

@Value.Immutable
public interface RegistryAuth {
    @JsonProperty(value="username")
    @Nullable
    public String username();

    @JsonProperty(value="password")
    @Nullable
    @Value.Redacted
    public String password();

    @JsonProperty(value="email")
    @Nullable
    @Value.Redacted
    public String email();

    @JsonProperty(value="serveraddress")
    @Nullable
    public String serverAddress();

    @JsonProperty(value="identitytoken")
    @Nullable
    public String identityToken();

    @JsonIgnore
    @Value.Derived
    @Value.Auxiliary
    default public Builder toBuilder() {
        return ImmutableRegistryAuth.builder().from(this);
    }

    public static Builder fromDockerConfig(String serverAddress) throws IOException {
        DockerConfigReader dockerCfgReader = new DockerConfigReader();
        return dockerCfgReader.authForRegistry(dockerCfgReader.defaultConfigPath(), serverAddress).toBuilder();
    }

    @JsonCreator
    public static RegistryAuth create(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="email") String email, @JsonProperty(value="serveraddress") String serveraddress, @JsonProperty(value="identitytoken") String identitytoken, @JsonProperty(value="auth") String auth) {
        Builder builder = auth != null ? RegistryAuth.forAuth(auth) : RegistryAuth.builder().username(username).password(password);
        return builder.email(email).serverAddress(serveraddress).identityToken(identitytoken).build();
    }

    public static Builder forAuth(String auth) {
        byte[] authByteValue = Base64.getDecoder().decode(auth);
        String[] authParams = new String(authByteValue, StandardCharsets.UTF_8).split(":", 2);
        if (authParams.length != 2) {
            return RegistryAuth.builder();
        }
        return RegistryAuth.builder().username(authParams[0].trim()).password(authParams[1].trim());
    }

    public static Builder builder() {
        return ImmutableRegistryAuth.builder();
    }

    public static interface Builder {
        public Builder username(String var1);

        public Builder password(String var1);

        public Builder email(String var1);

        public Builder serverAddress(String var1);

        public Builder identityToken(String var1);

        public RegistryAuth build();
    }
}

