/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.RestartPolicy;

final class ImmutableRestartPolicy
implements RestartPolicy {
    @Nullable
    private final String condition;
    @Nullable
    private final Long delay;
    @Nullable
    private final Integer maxAttempts;
    @Nullable
    private final Long window;

    private ImmutableRestartPolicy(@Nullable String condition, @Nullable Long delay, @Nullable Integer maxAttempts, @Nullable Long window) {
        this.condition = condition;
        this.delay = delay;
        this.maxAttempts = maxAttempts;
        this.window = window;
    }

    @Override
    @JsonProperty(value="Condition")
    @Nullable
    public String condition() {
        return this.condition;
    }

    @Override
    @JsonProperty(value="Delay")
    @Nullable
    public Long delay() {
        return this.delay;
    }

    @Override
    @JsonProperty(value="MaxAttempts")
    @Nullable
    public Integer maxAttempts() {
        return this.maxAttempts;
    }

    @Override
    @JsonProperty(value="Window")
    @Nullable
    public Long window() {
        return this.window;
    }

    public final ImmutableRestartPolicy withCondition(@Nullable String value) {
        if (Objects.equals(this.condition, value)) {
            return this;
        }
        return new ImmutableRestartPolicy(value, this.delay, this.maxAttempts, this.window);
    }

    public final ImmutableRestartPolicy withDelay(@Nullable Long value) {
        if (Objects.equals(this.delay, value)) {
            return this;
        }
        return new ImmutableRestartPolicy(this.condition, value, this.maxAttempts, this.window);
    }

    public final ImmutableRestartPolicy withMaxAttempts(@Nullable Integer value) {
        if (Objects.equals(this.maxAttempts, value)) {
            return this;
        }
        return new ImmutableRestartPolicy(this.condition, this.delay, value, this.window);
    }

    public final ImmutableRestartPolicy withWindow(@Nullable Long value) {
        if (Objects.equals(this.window, value)) {
            return this;
        }
        return new ImmutableRestartPolicy(this.condition, this.delay, this.maxAttempts, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRestartPolicy && this.equalTo(0, (ImmutableRestartPolicy)another);
    }

    private boolean equalTo(int synthetic, ImmutableRestartPolicy another) {
        return Objects.equals(this.condition, another.condition) && Objects.equals(this.delay, another.delay) && Objects.equals(this.maxAttempts, another.maxAttempts) && Objects.equals(this.window, another.window);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.condition);
        h += (h << 5) + Objects.hashCode(this.delay);
        h += (h << 5) + Objects.hashCode(this.maxAttempts);
        h += (h << 5) + Objects.hashCode(this.window);
        return h;
    }

    public String toString() {
        return "RestartPolicy{condition=" + this.condition + ", delay=" + this.delay + ", maxAttempts=" + this.maxAttempts + ", window=" + this.window + "}";
    }

    public static ImmutableRestartPolicy copyOf(RestartPolicy instance) {
        if (instance instanceof ImmutableRestartPolicy) {
            return (ImmutableRestartPolicy)instance;
        }
        return ImmutableRestartPolicy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder
    implements RestartPolicy.Builder {
        private String condition;
        private Long delay;
        private Integer maxAttempts;
        private Long window;

        private Builder() {
        }

        public final Builder from(RestartPolicy instance) {
            Long windowValue;
            Integer maxAttemptsValue;
            Long delayValue;
            Objects.requireNonNull(instance, "instance");
            String conditionValue = instance.condition();
            if (conditionValue != null) {
                this.condition(conditionValue);
            }
            if ((delayValue = instance.delay()) != null) {
                this.delay(delayValue);
            }
            if ((maxAttemptsValue = instance.maxAttempts()) != null) {
                this.maxAttempts(maxAttemptsValue);
            }
            if ((windowValue = instance.window()) != null) {
                this.window(windowValue);
            }
            return this;
        }

        @Override
        @JsonProperty(value="Condition")
        public final Builder condition(@Nullable String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        @JsonProperty(value="Delay")
        public final Builder delay(@Nullable Long delay) {
            this.delay = delay;
            return this;
        }

        @Override
        @JsonProperty(value="MaxAttempts")
        public final Builder maxAttempts(@Nullable Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        @Override
        @JsonProperty(value="Window")
        public final Builder window(@Nullable Long window) {
            this.window = window;
            return this;
        }

        @Override
        public ImmutableRestartPolicy build() {
            return new ImmutableRestartPolicy(this.condition, this.delay, this.maxAttempts, this.window);
        }
    }
}

