/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.jsonp.signaturetest.jsonp;

import ee.jakarta.tck.jsonp.signaturetest.SigTestEE;
import ee.jakarta.tck.jsonp.signaturetest.SigTestResult;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Logger;
import org.junit.jupiter.api.Test;

public class JSONPSigTest
extends SigTestEE {
    private static final Logger LOGGER = Logger.getLogger(JSONPSigTest.class.getName());

    public JSONPSigTest() {
        this.setup();
    }

    @Override
    protected String[] getPackages(String vehicleName) {
        return new String[]{"jakarta.json", "jakarta.json.spi", "jakarta.json.stream"};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToTempFile(InputStream inputStream, String tempFilePrefix, String tempFileSuffix) throws IOException {
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File file = File.createTempFile(tempFilePrefix, tempFileSuffix);
            outputStream = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file2 = file;
            return file2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File writeStreamToSigFile(InputStream inputStream, String packageVersion) throws IOException {
        String tmpdir = System.getProperty("java.io.tmpdir");
        try (FileOutputStream outputStream = null;){
            int bytesRead;
            File sigfile = new File(tmpdir + File.separator + "jakarta.json.sig_" + packageVersion);
            if (sigfile.exists()) {
                sigfile.delete();
                LOGGER.info("Existing signature file deleted to create new one");
            }
            if (!sigfile.createNewFile()) {
                LOGGER.info("signature file is not created");
            }
            outputStream = new FileOutputStream(sigfile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, bytesRead);
            }
            File file = sigfile;
            return file;
        }
    }

    @Override
    @Test
    public void signatureTest() throws SigTestEE.Fault {
        LOGGER.info("$$$ JSONPSigTest.signatureTest() called");
        SigTestResult results = null;
        String mapFile = null;
        String packageFile = null;
        String repositoryDir = null;
        Properties mapFileAsProps = null;
        try {
            InputStream inStreamMapfile = JSONPSigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/jsonp/signaturetest/sig-test.map");
            File mFile = this.writeStreamToTempFile(inStreamMapfile, "sig-test", ".map");
            mapFile = mFile.getCanonicalPath();
            LOGGER.info("mapFile location is :" + mapFile);
            InputStream inStreamPackageFile = JSONPSigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/jsonp/signaturetest/sig-test-pkg-list.txt");
            File pFile = this.writeStreamToTempFile(inStreamPackageFile, "sig-test-pkg-list", ".txt");
            packageFile = pFile.getCanonicalPath();
            LOGGER.info("packageFile location is :" + packageFile);
            mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
            String packageVersion = mapFileAsProps.getProperty("jakarta.json");
            LOGGER.info("Package version from mapfile :" + packageVersion);
            InputStream inStreamSigFile = JSONPSigTest.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/jsonp/signaturetest/jakarta.json.sig_" + packageVersion);
            File sigFile = this.writeStreamToSigFile(inStreamSigFile, packageVersion);
            LOGGER.info("signature File location is :" + sigFile.getCanonicalPath());
            repositoryDir = System.getProperty("java.io.tmpdir");
        }
        catch (IOException ex) {
            LOGGER.info("Exception while creating temp files :" + ex);
        }
        String[] packages = this.getPackages(this.testInfo.getVehicle());
        String[] classes = this.getClasses(this.testInfo.getVehicle());
        String testClasspath = System.getProperty("signature.sigTestClasspath");
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = this.testInfo.getJImageDir();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            LOGGER.info("Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                LOGGER.info(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules");
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    LOGGER.info(line);
                }
                int rc = proc.waitFor();
                LOGGER.info("JImage RC = " + rc);
                out.close();
            }
            catch (Exception e) {
                LOGGER.info("Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            LOGGER.info(results.toString());
            if (!results.passed()) {
                LOGGER.info("results.passed() returned false");
                throw new Exception();
            }
            if ("standalone".equalsIgnoreCase(this.testInfo.getVehicle())) {
                if (mapFileAsProps == null || mapFileAsProps.size() == 0) {
                    LOGGER.info("JSONPSigTest.signatureTest() returning, as signature map file is empty.");
                    return;
                }
                boolean isJTASigTest = false;
                String jtaVersion = mapFileAsProps.getProperty("jakarta.transaction");
                if (jtaVersion == null || "".equals(jtaVersion.trim())) {
                    LOGGER.info("JSONPSigTest.signatureTest() returning, as this is neither JTA TCK run, not Java EE CTS run.");
                    return;
                }
                LOGGER.info("jtaVersion " + jtaVersion);
                if (mapFileAsProps.size() == 1) {
                    isJTASigTest = true;
                }
                if (isJTASigTest || !jtaVersion.startsWith("1.2")) {
                    this.verifyJtaJarTest();
                }
            }
            LOGGER.info("$$$ JSONPSigTest.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new SigTestEE.Fault("JSONPSigTest.signatureTest() failed!, diffs found");
            }
            LOGGER.info("Unexpected exception " + e.getMessage());
            throw new SigTestEE.Fault("signatureTest failed with an unexpected exception", e);
        }
    }
}

