/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.LongDataset;
import org.eclipse.january.dataset.Maths;
import org.eclipse.january.dataset.ShortDataset;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class MathsBasicTypeAbsFunctionParameterizeTest {
    @Parameterized.Parameter
    public Class<? extends Dataset> classType;
    private static final double ABSERRD = 1.0E-8;

    @Parameterized.Parameters(name="{index}: {0}")
    public static Collection<Object> data() {
        return Arrays.asList(FloatDataset.class, DoubleDataset.class, ByteDataset.class, ShortDataset.class, IntegerDataset.class, LongDataset.class);
    }

    @Test
    public void test() {
        Class<? extends Dataset> class1 = this.classType;
        double[] obj = new double[]{4.2, -2.9, 6.1};
        Dataset input = DatasetFactory.createFromObject(class1, (Object)obj);
        Dataset output = DatasetFactory.createFromObject(class1, (Object)new double[]{0.0, 0.0, 0.0});
        System.out.println(output.getElementsPerItem());
        int size = input.getSize();
        double[] c = new double[size];
        int i = 0;
        while (i < size) {
            double abs;
            c[i] = abs = Math.abs(obj[i]);
            ++i;
        }
        Dataset expectedResult = DatasetFactory.createFromObject(class1, (Object)c);
        Dataset actualResult = Maths.abs((Object)input, (Dataset)output);
        TestUtils.assertDatasetEquals((Dataset)expectedResult, (Dataset)actualResult, (boolean)true, (double)1.0E-8, (double)1.0E-8);
    }
}

