/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.january.dataset;

import org.eclipse.january.asserts.TestUtils;
import org.eclipse.january.dataset.ByteDataset;
import org.eclipse.january.dataset.CompoundByteDataset;
import org.eclipse.january.dataset.CompoundDataset;
import org.eclipse.january.dataset.CompoundIntegerDataset;
import org.eclipse.january.dataset.Dataset;
import org.eclipse.january.dataset.DatasetFactory;
import org.eclipse.january.dataset.DoubleDataset;
import org.eclipse.january.dataset.FloatDataset;
import org.eclipse.january.dataset.IntegerDataset;
import org.eclipse.january.dataset.RGBByteDataset;
import org.eclipse.january.dataset.ShortDataset;
import org.eclipse.january.dataset.Slice;
import org.junit.Assert;
import org.junit.Test;

public class RGBByteDatasetTest {
    @Test
    public void testConstructors() {
        Assert.assertEquals((long)0L, (long)new RGBByteDataset().getSize());
        Assert.assertEquals((long)0L, (long)((RGBByteDataset)DatasetFactory.createFromObject(RGBByteDataset.class, (Object)new byte[]{1, 3, 5})).getRank());
        int n = 250;
        Dataset r = DatasetFactory.createRange(IntegerDataset.class, (double)n);
        Dataset g = DatasetFactory.createRange(IntegerDataset.class, (double)1.0, (double)(n + 1), (double)1.0);
        Dataset b = DatasetFactory.createRange(IntegerDataset.class, (double)2.0, (double)(n + 2), (double)1.0);
        RGBByteDataset c = new RGBByteDataset(r, g, b);
        int i = 0;
        while (i < n) {
            Assert.assertEquals((long)i, (long)Byte.toUnsignedInt(c.getRed(i)));
            Assert.assertEquals((long)(i + 1), (long)Byte.toUnsignedInt(c.getGreen(i)));
            Assert.assertEquals((long)(i + 2), (long)Byte.toUnsignedInt(c.getBlue(i)));
            ++i;
        }
        c = new RGBByteDataset(g);
        i = 0;
        while (i < n) {
            Assert.assertEquals((long)(i + 1), (long)Byte.toUnsignedInt(c.getRed(i)));
            Assert.assertEquals((long)(i + 1), (long)Byte.toUnsignedInt(c.getGreen(i)));
            Assert.assertEquals((long)(i + 1), (long)Byte.toUnsignedInt(c.getBlue(i)));
            ++i;
        }
        r = r.cast(ByteDataset.class);
        g = g.cast(ByteDataset.class);
        b = b.cast(ByteDataset.class);
        c = new RGBByteDataset((byte[])r.getBuffer(), (byte[])g.getBuffer(), (byte[])b.getBuffer(), new int[0]);
        i = 0;
        while (i < n) {
            Assert.assertEquals((long)i, (long)Byte.toUnsignedInt(c.getRed(i)));
            Assert.assertEquals((long)(i + 1), (long)Byte.toUnsignedInt(c.getGreen(i)));
            Assert.assertEquals((long)(i + 2), (long)Byte.toUnsignedInt(c.getBlue(i)));
            ++i;
        }
        CompoundDataset cc = DatasetFactory.createRange((int)2, CompoundIntegerDataset.class, (double)n);
        c = RGBByteDataset.createFromCompoundDataset((CompoundDataset)cc);
        int i2 = 0;
        while (i2 < n) {
            Assert.assertEquals((long)i2, (long)Byte.toUnsignedInt(c.getRed(i2)));
            Assert.assertEquals((long)i2, (long)Byte.toUnsignedInt(c.getGreen(i2)));
            Assert.assertEquals((long)i2, (long)Byte.toUnsignedInt(c.getBlue(i2)));
            ++i2;
        }
        cc = DatasetFactory.createRange((int)4, CompoundIntegerDataset.class, (double)n);
        c = RGBByteDataset.createFromCompoundDataset((CompoundDataset)cc);
        i2 = 0;
        while (i2 < n) {
            Assert.assertEquals((long)i2, (long)Byte.toUnsignedInt(c.getRed(i2)));
            Assert.assertEquals((long)0L, (long)c.getGreen(i2));
            Assert.assertEquals((long)0L, (long)c.getBlue(i2));
            ++i2;
        }
    }

    @Test
    public void testConstructorsWithSliceViews() {
        int n = 10;
        Dataset a = ((IntegerDataset)DatasetFactory.createRange(IntegerDataset.class, (double)(3 * n))).reshape(new int[]{3, n});
        Dataset r = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(0), Integer.valueOf(1))}).squeeze();
        Dataset g = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(1), Integer.valueOf(2))}).squeeze();
        Dataset b = a.getSliceView(new Slice[]{new Slice(Integer.valueOf(2), Integer.valueOf(3))}).squeeze();
        RGBByteDataset c = new RGBByteDataset(r, g, b);
        int i = 0;
        while (i < n) {
            Assert.assertEquals((long)r.getInt(i), (long)c.getRed(i));
            Assert.assertEquals((long)g.getInt(i), (long)c.getGreen(i));
            Assert.assertEquals((long)b.getInt(i), (long)c.getBlue(i));
            ++i;
        }
    }

    @Test
    public void testConverters() {
        byte[] byArray = new byte[18];
        byArray[0] = -1;
        byArray[3] = -65;
        byArray[4] = -65;
        byArray[7] = 127;
        byArray[9] = 127;
        byArray[10] = -1;
        byArray[11] = -1;
        byArray[12] = 127;
        byArray[13] = 127;
        byArray[14] = -1;
        byArray[15] = -65;
        byArray[16] = 63;
        byArray[17] = -65;
        byte[] rgbs = byArray;
        RGBByteDataset rgb = RGBByteDataset.createFromCompoundDataset((CompoundDataset)new CompoundByteDataset(3, rgbs, new int[]{6}));
        ByteDataset g = new ByteDataset(new byte[]{76, -87, 74, -40, -115, 115}, new int[]{6});
        TestUtils.assertDatasetEquals((Dataset)g, (Dataset)rgb.createGreyDataset(ByteDataset.class), (double)1.0, (double)1.0);
        short[] sArray = new short[6];
        sArray[1] = 60;
        sArray[2] = 120;
        sArray[3] = 180;
        sArray[4] = 240;
        sArray[5] = 300;
        ShortDataset h = new ShortDataset(sArray, new int[]{6});
        FloatDataset v = new FloatDataset(new float[]{1.0f, 0.75f, 0.5f, 1.0f, 1.0f, 0.75f}, new int[]{6});
        DoubleDataset s = new DoubleDataset(new double[]{1.0, 1.0, 1.0, 0.5, 0.5, 0.667}, new int[]{6});
        RGBByteDataset a = RGBByteDataset.createFromHSV((Dataset)h, (Dataset)s, (Dataset)v);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        h.isubtract((Object)360);
        a = RGBByteDataset.createFromHSV((Dataset)h, (Dataset)s, (Dataset)v);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        FloatDataset l = new FloatDataset(new float[]{0.5f, 0.375f, 0.25f, 0.75f, 0.75f, 0.5f}, new int[]{6});
        s = new DoubleDataset(new double[]{1.0, 1.0, 1.0, 1.0, 1.0, 0.5}, new int[]{6});
        a = RGBByteDataset.createFromHSL((Dataset)h, (Dataset)s, (Dataset)l);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        h.iadd((Object)360);
        a = RGBByteDataset.createFromHSL((Dataset)h, (Dataset)s, (Dataset)l);
        TestUtils.assertDatasetEquals((Dataset)rgb, (Dataset)a, (double)1.0, (double)1.0);
        FloatDataset bf = (FloatDataset)rgb.createBlueDataset(FloatDataset.class);
        short[] sArray2 = new short[6];
        sArray2[3] = 255;
        sArray2[4] = 255;
        sArray2[5] = 191;
        s = DatasetFactory.createFromObject(FloatDataset.class, (Object)sArray2);
        TestUtils.assertDatasetEquals((Dataset)s, (Dataset)bf, (double)1.0, (double)1.0);
    }
}

