/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.exec.FilterSelectionHandler;
import com.sun.javatest.exec.TT_TestNode;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.exec.TreePanelModel;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import java.awt.EventQueue;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

class TestTree
extends JTree {
    private static int debug = Debug.getInt("debug." + TestTree.class.getName());
    private UIFactory uif;
    private TestTreeModel currModel;
    private TreePanelModel tpm;
    private FilterSelectionHandler filterHandler;
    private EventWatcher watcher = new EventWatcher();

    public TestTree(UIFactory uif, TreePanelModel model, FilterSelectionHandler fh, TestTreeModel treeModel) {
        this.uif = uif;
        this.tpm = model;
        this.filterHandler = fh;
        this.filterHandler.addObserver(this.watcher);
        this.currModel = treeModel;
        this.setModel(this.currModel);
        this.setLargeModel(true);
        this.setScrollsOnExpand(true);
        this.setName("tree");
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void updateGUI() {
        this.repaint();
    }

    @Override
    public void setModel(TreeModel newModel) {
        super.setModel(newModel);
        newModel.addTreeModelListener(this.watcher);
    }

    void setParameters(Parameters p) {
    }

    void setTreeModel(TestTreeModel mod) {
        if (this.currModel != null) {
            this.currModel.removeTreeModelListener(this.watcher);
        }
        this.currModel = mod;
        this.setModel(this.currModel);
    }

    TestResultTable getTestResultTable() {
        return this.currModel.getTestResultTable();
    }

    TreePath[] snapshotSelectedPaths() {
        TreeSelectionModel tsm = this.getSelectionModel();
        if (tsm == null) {
            return null;
        }
        return tsm.getSelectionPaths();
    }

    void restoreSelection(String ... selectedUrls) {
        if (selectedUrls == null || selectedUrls.length == 0) {
            return;
        }
        if (this.currModel instanceof TestTreeModel) {
            TreePath[] paths = this.currModel.urlsToPaths(selectedUrls);
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(() -> this.restoreSelection(paths));
            } else {
                this.restoreSelection(paths);
            }
        }
    }

    private void restoreSelection(TreePath ... selectedPaths) {
        if (selectedPaths == null || selectedPaths.length == 0) {
            return;
        }
        TreeSelectionModel tsm = this.getSelectionModel();
        if (tsm == null) {
            return;
        }
        tsm.addSelectionPaths(selectedPaths);
    }

    TreePath[] snapshotOpenPaths() {
        if (this.currModel == null || this.currModel.getRoot() == null) {
            return null;
        }
        TreePath[] paths = new TreePath[]{};
        Enumeration<TreePath> e = this.getDescendantToggledPaths(new TreePath(this.currModel.getRoot()));
        while (e != null && e.hasMoreElements()) {
            TreePath tp = e.nextElement();
            if (!this.isVisible(tp) || !this.isExpanded(tp)) continue;
            paths = DynamicArray.append(paths, tp);
        }
        return paths;
    }

    void restorePaths(String[] openUrls, boolean queue) {
        if (openUrls == null || openUrls.length == 0) {
            return;
        }
        if (this.currModel instanceof TestTreeModel) {
            TreePath[] paths = this.currModel.urlsToPaths(openUrls);
            if (!EventQueue.isDispatchThread() || queue) {
                EventQueue.invokeLater(() -> this.restorePaths(paths));
            } else {
                this.restorePaths(paths);
            }
        }
    }

    void restorePaths(TreePath ... paths) {
        if (paths == null || paths.length == 0) {
            return;
        }
        for (TreePath path : paths) {
            if (path.getPathCount() == 1) continue;
            this.setExpandedState(path, true);
            this.makeVisible(path);
        }
    }

    private class EventWatcher
    implements TreeModelListener,
    FilterSelectionHandler.Observer {
        private EventWatcher() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
            String activeTest = TestTree.this.tpm.getSelectedTest();
            if (activeTest == null) {
                return;
            }
            Object[] targets = e.getChildren();
            if (targets == null) {
                return;
            }
            for (Object target : targets) {
                TestResult tr;
                if (!(target instanceof TT_TestNode) || !(tr = ((TT_TestNode)target).getTestResult()).getTestName().equals(activeTest)) continue;
                TestTree.this.tpm.showTest(tr);
            }
            TestTree.this.repaint();
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
            String activeTest = TestTree.this.tpm.getSelectedTest();
            if (activeTest == null) {
                return;
            }
            Object[] targets = e.getChildren();
            if (targets == null) {
                return;
            }
            for (Object target : targets) {
                TestResult tr;
                if (!(target instanceof TT_TestNode) || !(tr = ((TT_TestNode)target).getTestResult()).getTestName().equals(activeTest)) continue;
                TestTree.this.tpm.showTest(tr);
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreePath[] tp = TestTree.this.snapshotOpenPaths();
            TreePath[] selected = TestTree.this.snapshotSelectedPaths();
            if (tp != null && tp.length != 0) {
                TestTree.this.restorePaths(tp);
            }
            TestTree.this.restoreSelection(selected);
        }

        @Override
        public void filterUpdated(TestFilter f) {
            TestTree.this.updateGUI();
        }

        @Override
        public void filterSelected(TestFilter f) {
            TestTree.this.updateGUI();
        }

        @Override
        public void filterAdded(TestFilter f) {
        }

        @Override
        public void filterRemoved(TestFilter f) {
        }
    }
}

